/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Input;
import beast.core.State;
import beast.evolution.tree.TreeDistribution;
import beast.evolution.tree.coalescent.IntervalList;
import beast.evolution.tree.coalescent.IntervalType;
import beast.evolution.tree.coalescent.PopulationFunction;
import beast.evolution.tree.coalescent.TreeIntervals;
import beast.math.Binomial;
import java.util.Collections;
import java.util.List;
import java.util.Random;

@Description(value="Calculates the probability of a beast.tree conditional on a population size function. Note that this does not take the number of possible tree interval/tree topology combinations in account, in other words, the constant required for making this a proper distribution that integrates to unity is not calculated (partly, because we don't know how for sequentially sampled data).")
public class Coalescent
extends TreeDistribution {
    public final Input<PopulationFunction> popSizeInput = new Input("populationModel", "A population size model", Input.Validate.REQUIRED);
    TreeIntervals intervals;

    @Override
    public void initAndValidate() {
        this.intervals = (TreeIntervals)this.treeIntervalsInput.get();
        if (this.intervals == null) {
            throw new IllegalArgumentException("Expected treeIntervals to be specified");
        }
        this.calculateLogP();
    }

    @Override
    public double calculateLogP() {
        this.logP = this.calculateLogLikelihood(this.intervals, this.popSizeInput.get());
        if (Double.isInfinite(this.logP)) {
            this.logP = Double.NEGATIVE_INFINITY;
        }
        return this.logP;
    }

    @Override
    public void sample(State state, Random random) {
        throw new UnsupportedOperationException("This should eventually sample a coalescent tree conditional on population size function.");
    }

    @Override
    public List<String> getArguments() {
        return Collections.singletonList(((TreeIntervals)this.treeIntervalsInput.get()).getID());
    }

    @Override
    public List<String> getConditions() {
        return this.popSizeInput.get().getParameterIds();
    }

    public double calculateLogLikelihood(IntervalList intervalList, PopulationFunction populationFunction) {
        return this.calculateLogLikelihood(intervalList, populationFunction, 0.0);
    }

    public double calculateLogLikelihood(IntervalList intervalList, PopulationFunction populationFunction, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = intervalList.getIntervalCount();
        for (int i = 0; i < n; ++i) {
            double d4 = intervalList.getInterval(i);
            double d5 = d3 + d4;
            double d6 = populationFunction.getIntegral(d3, d5);
            if (d6 == 0.0 && d4 != 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            int n2 = intervalList.getLineageCount(i);
            double d7 = Binomial.choose2(n2);
            d2 += -d7 * d6;
            if (intervalList.getIntervalType(i) == IntervalType.COALESCENT) {
                double d8 = populationFunction.getPopSize(d5);
                if (d4 == 0.0 || d8 * (d6 / d4) >= d) {
                    d2 -= Math.log(d8);
                } else {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            d3 = d5;
        }
        return d2;
    }

    @Override
    protected boolean requiresRecalculation() {
        return ((CalculationNode)((Object)this.popSizeInput.get())).isDirtyCalculation() || super.requiresRecalculation();
    }
}

