/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.BooleanParameter;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import beast.util.Randomizer;

@Description(value="Sample values from a distribution")
public class SampleOffValues
extends Operator {
    public final Input<RealParameter> valuesInput = new Input("values", "vector of target values", Input.Validate.REQUIRED);
    public final Input<BooleanParameter> indicatorsInput = new Input("indicators", "Sample only entries which are 'off'");
    public final Input<ParametricDistribution> distInput = new Input("dist", "distribution to sample from.", Input.Validate.REQUIRED);
    public final Input<Boolean> scaleAll = new Input<Boolean>("all", "if true, sample all off values in one go.", false);

    @Override
    public void initAndValidate() {
    }

    @Override
    public double proposal() {
        int n;
        BooleanParameter booleanParameter = this.indicatorsInput.get(this);
        RealParameter realParameter = this.valuesInput.get(this);
        ParametricDistribution parametricDistribution = this.distInput.get();
        int n2 = booleanParameter.getDimension();
        int n3 = n = realParameter.getDimension() - 1 == n2 ? 1 : 0;
        assert (n == 1 || realParameter.getDimension() == n2) : "" + n2 + " (?+1) != " + realParameter.getDimension();
        double d = Double.NEGATIVE_INFINITY;
        if (this.scaleAll.get().booleanValue()) {
            for (int i = n; i < n2; ++i) {
                if (((Boolean)booleanParameter.getValue(i - n)).booleanValue()) continue;
                try {
                    double d2 = parametricDistribution.inverseCumulativeProbability(Randomizer.nextDouble());
                    d += parametricDistribution.logDensity((Double)realParameter.getValue(i));
                    realParameter.setValue(i, d2);
                    continue;
                }
                catch (Exception exception) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
        } else {
            int n4;
            int[] nArray = new int[n2];
            int n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (((Boolean)booleanParameter.getValue(n4)).booleanValue()) continue;
                nArray[n5] = n4 + n;
                ++n5;
            }
            if (n5 > 0) {
                n4 = nArray[Randomizer.nextInt(n5)];
                try {
                    double d3 = parametricDistribution.inverseCumulativeProbability(Randomizer.nextDouble());
                    d = parametricDistribution.logDensity((Double)realParameter.getValue(n4));
                    realParameter.setValue(n4, d3);
                }
                catch (Exception exception) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
        }
        return d;
    }
}

