/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

public class OutputUtils {
    public static final String SPACE = " ";

    public static String format(String string) {
        return OutputUtils.format(string, SPACE);
    }

    public static String format(String string, String string2) {
        while (string.length() < 8) {
            string = string + SPACE;
        }
        return string + string2;
    }

    public static String format(Double d) {
        if (Double.isNaN(d)) {
            return "NaN     ";
        }
        if (Math.abs(d) > 1.0E-4 || d == 0.0) {
            DecimalFormat decimalFormat = new DecimalFormat("#0.######", new DecimalFormatSymbols(Locale.US));
            String string = decimalFormat.format(d);
            if (string.length() > 8) {
                string = string.substring(0, 8);
            }
            while (string.length() < 8) {
                string = string + SPACE;
            }
            return string;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##E0", new DecimalFormatSymbols(Locale.US));
        String string = decimalFormat.format(d);
        if (string.length() > 8) {
            String[] stringArray = string.split("E");
            string = stringArray[0].substring(0, 8 - stringArray[1].length() - 1) + "E" + stringArray[1];
        }
        while (string.length() < 8) {
            string = string + SPACE;
        }
        return string;
    }

    public static String toString(List<?> list) {
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            Object obj = list.get(i);
            string = string + obj.toString();
        }
        return string;
    }
}

