/*
 * Decompiled with CFR 0.152.
 */
package jam.console;

import jam.console.ConsoleApplication;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ConsoleFrame
extends DocumentFrame {
    PipedInputStream piOut;
    PipedInputStream piErr;
    PipedOutputStream poOut;
    PipedOutputStream poErr;
    JTextArea textArea = new JTextArea();

    public ConsoleFrame() throws IOException {
        this.piOut = new PipedInputStream();
        this.poOut = new PipedOutputStream(this.piOut);
        System.setOut(new PrintStream(this.poOut, true));
        this.piErr = new PipedInputStream();
        this.poErr = new PipedOutputStream(this.piErr);
        System.setErr(new PrintStream(this.poErr, true));
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 || e.getKeyCode() == 67 && e.isControlDown() || e.getKeyCode() == 46 && e.isMetaDown()) {
                    ConsoleFrame.this.escapePressed();
                }
            }
        });
    }

    @Override
    protected void initializeComponents() {
        this.textArea.setEditable(false);
        this.textArea.setRows(25);
        this.textArea.setColumns(80);
        this.textArea.setEditable(false);
        Font font = this.textArea.getFont();
        this.textArea.setFont(new Font("Monospaced", 0, font.getSize()));
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.pack();
        this.setVisible(true);
        new ReaderThread(this.piOut).start();
        new ReaderThread(this.piErr).start();
        this.getCutAction().setEnabled(false);
        this.getPasteAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
        this.getFindAction().setEnabled(false);
    }

    @Override
    protected boolean readFromFile(File file) throws FileNotFoundException, IOException {
        throw new RuntimeException("Cannot read file");
    }

    @Override
    protected boolean writeToFile(File file) throws IOException {
        this.textArea.write(new FileWriter(file));
        return true;
    }

    @Override
    public JComponent getExportableComponent() {
        return this.textArea;
    }

    protected void escapePressed() {
        int option = JOptionPane.showConfirmDialog(this, "Are you sure you wish to stop?", "Stop", 2, 2);
        if (option == 0) {
            ((ConsoleApplication)Application.getApplication()).doStop();
        }
    }

    @Override
    public void doCopy() {
        this.textArea.copy();
    }

    @Override
    public void doSelectAll() {
        this.textArea.selectAll();
    }

    class ReaderThread
    extends Thread {
        PipedInputStream pi;

        ReaderThread(PipedInputStream pi) {
            this.pi = pi;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    int available;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    String input = "";
                    while ((available = this.pi.available()) != 0) {
                        byte[] b = new byte[available];
                        this.pi.read(b);
                        if (!(input = String.valueOf(input) + new String(b)).endsWith("\n") && !input.endsWith("\r\n")) continue;
                    }
                    if (input.length() <= 0) continue;
                    SwingUtilities.invokeLater(new WriteText(input));
                }
            }
            catch (IOException iOException) {
                return;
            }
        }

        class WriteText
        implements Runnable {
            String text;

            WriteText(String text) {
                this.text = text;
            }

            @Override
            public void run() {
                ((ReaderThread)ReaderThread.this).ConsoleFrame.this.textArea.append(this.text);
                ((ReaderThread)ReaderThread.this).ConsoleFrame.this.textArea.setCaretPosition(((ReaderThread)ReaderThread.this).ConsoleFrame.this.textArea.getDocument().getLength());
                int idealSize = 128000;
                int maxExcess = 16000;
                int excess = ((ReaderThread)ReaderThread.this).ConsoleFrame.this.textArea.getDocument().getLength() - idealSize;
                if (excess >= maxExcess) {
                    ((ReaderThread)ReaderThread.this).ConsoleFrame.this.textArea.replaceRange("", 0, excess);
                }
                ConsoleFrame.this.setDirty();
            }
        }
    }
}

