/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.distribution.GammaDistributionImpl;

public class ChiSquaredDistributionImpl
extends AbstractContinuousDistribution
implements ChiSquaredDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -8352658048349159782L;
    private GammaDistribution gamma;
    private final double solverAbsoluteAccuracy;

    public ChiSquaredDistributionImpl(double d) {
        this(d, new GammaDistributionImpl(d / 2.0, 2.0));
    }

    @Deprecated
    public ChiSquaredDistributionImpl(double d, GammaDistribution gammaDistribution) {
        this.setGammaInternal(gammaDistribution);
        this.setDegreesOfFreedomInternal(d);
        this.solverAbsoluteAccuracy = 1.0E-9;
    }

    public ChiSquaredDistributionImpl(double d, double d2) {
        this.gamma = new GammaDistributionImpl(d / 2.0, 2.0);
        this.setDegreesOfFreedomInternal(d);
        this.solverAbsoluteAccuracy = d2;
    }

    @Override
    @Deprecated
    public void setDegreesOfFreedom(double d) {
        this.setDegreesOfFreedomInternal(d);
    }

    private void setDegreesOfFreedomInternal(double d) {
        this.gamma.setAlpha(d / 2.0);
    }

    @Override
    public double getDegreesOfFreedom() {
        return this.gamma.getAlpha() * 2.0;
    }

    @Override
    @Deprecated
    public double density(Double d) {
        return this.density((double)d);
    }

    @Override
    public double density(double d) {
        return this.gamma.density(d);
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        return this.gamma.cumulativeProbability(d);
    }

    @Override
    public double inverseCumulativeProbability(double d) throws MathException {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(d);
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return Double.MIN_VALUE * this.gamma.getBeta();
    }

    @Override
    protected double getDomainUpperBound(double d) {
        double d2 = d < 0.5 ? this.getDegreesOfFreedom() : Double.MAX_VALUE;
        return d2;
    }

    @Override
    protected double getInitialDomain(double d) {
        double d2 = d < 0.5 ? this.getDegreesOfFreedom() * 0.5 : this.getDegreesOfFreedom();
        return d2;
    }

    @Deprecated
    public void setGamma(GammaDistribution gammaDistribution) {
        this.setGammaInternal(gammaDistribution);
    }

    private void setGammaInternal(GammaDistribution gammaDistribution) {
        this.gamma = gammaDistribution;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

