/*
 * Decompiled with CFR 0.152.
 */
package viz;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import viz.DensiTree;
import viz.Node;
import viz.RotationPoint;
import viz.graphics.ArcBranchDrawer;
import viz.graphics.BufferedImageBounded;
import viz.graphics.BufferedImageF;
import viz.graphics.SVGTreeDrawer;
import viz.graphics.SteepArcBranchDrawer;
import viz.graphics.TreeDrawer;

public class TreeSetPanel
extends JPanel
implements MouseListener,
Printable,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    DensiTree m_dt;
    int m_nDrawThreads = 2;
    Thread[] m_drawThread;
    private BufferedImageF m_image;
    private BufferedImage m_selectedImage;
    RotationPoint[] m_rotationPoints = null;
    boolean m_bIsMoving = false;
    boolean m_bIsDragging = false;

    public TreeSetPanel(DensiTree dt) {
        this.m_dt = dt;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.m_drawThread = new Thread[2];
    }

    void stopDrawThreads() {
        try {
            int i = 0;
            while (i < this.m_nDrawThreads) {
                if (this.m_drawThread[i] != null) {
                    ((DrawThread)this.m_drawThread[i]).m_bStop = true;
                }
                ++i;
            }
            i = 0;
            while (i < this.m_nDrawThreads) {
                if (this.m_drawThread[i] != null) {
                    this.m_drawThread[i].join();
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void clearImage() {
        this.m_image = null;
        this.stopDrawThreads();
    }

    boolean isDrawing() {
        int i = 0;
        while (i < this.m_nDrawThreads) {
            if (this.m_drawThread[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void drawLabelsSVG(Node node, StringBuffer buf) {
        if (node.isLeaf()) {
            Color color = null;
            color = this.m_dt.m_bSelection[node.m_iLabel] ? this.m_dt.m_color[DensiTree.LABELCOLOR] : Color.GRAY;
            int x = 0;
            int y = 0;
            if (this.m_dt.m_treeDrawer.m_bRootAtTop) {
                x = (int)(node.m_fPosX * this.m_dt.m_fScaleX) + 10;
                y = this.m_dt.getPosY((node.m_fPosY - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
            } else {
                y = (int)(node.m_fPosX * this.m_dt.m_fScaleY);
                x = this.m_dt.getPosX((node.m_fPosY - this.m_dt.m_fTreeOffset) * this.m_dt.m_fTreeScale);
            }
            buf.append("<text x='" + x + "' y='" + y + "' " + "font-family='" + this.m_dt.m_font.getFamily() + "' " + "font-size='" + this.m_dt.m_font.getSize() + "pt' " + "font-style='" + (this.m_dt.m_font.isBold() ? "oblique" : "") + (this.m_dt.m_font.isItalic() ? "italic" : "") + "' " + "stroke='rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")' " + ">" + this.m_dt.m_sLabels.elementAt(node.m_iLabel) + "</text>\n");
        } else {
            this.drawLabelsSVG(node.m_left, buf);
            this.drawLabelsSVG(node.m_right, buf);
        }
    }

    void toSVG(String sFileName) {
        try {
            if (this.m_dt.m_font == null) {
                this.m_dt.m_font = new Font("Monospaced", 0, 10);
            }
            StringBuffer buf = new StringBuffer();
            SVGTreeDrawer treeDrawer = new SVGTreeDrawer(buf);
            TreeDrawer t = this.m_dt.m_treeDrawer;
            treeDrawer.LINE_WIDTH_SCALE = this.m_dt.m_treeDrawer.LINE_WIDTH_SCALE;
            treeDrawer.m_bRootAtTop = this.m_dt.m_treeDrawer.m_bRootAtTop;
            treeDrawer.m_bViewBlockTree = this.m_dt.m_treeDrawer.m_bViewBlockTree;
            if (this.m_dt.m_treeDrawer.getBranchDrawer() instanceof SteepArcBranchDrawer) {
                treeDrawer.m_bViewBlockTree = false;
                JOptionPane.showMessageDialog(this, "Steep arcs not implemented yet for SVG export, using straigh lines instead");
            }
            if (this.m_dt.m_treeDrawer.getBranchDrawer() instanceof ArcBranchDrawer) {
                treeDrawer.m_branchStyle = 2;
            }
            DrawThread thread = new DrawThread("draw thread", 0, this.m_dt.m_trees.length, 1, treeDrawer);
            thread.run();
            this.drawLabelsSVG(this.m_dt.m_trees[0], buf);
            this.m_dt.m_gridDrawer.drawHeightInfoSVG(buf);
            PrintStream out = new PrintStream(sFileName);
            out.println("<?xml version='1.0'?>\n<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.1//EN'\n  'http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd'>\n<svg xmlns='http://www.w3.org/2000/svg' version='1.1'\n      width='" + this.getWidth() + "' height='" + this.getHeight() + "' viewBox='0 0 " + this.getWidth() + " " + this.getHeight() + "'>\n" + "<rect fill='#fff' width='" + this.getWidth() + "' height='" + this.getHeight() + "'/>");
            out.println(buf.toString());
            out.println("</svg>");
            this.m_dt.m_treeDrawer = t;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    double calcImageEntropy() throws Exception {
        if (this.m_image == null) {
            return 0.0;
        }
        Thread.sleep(100L);
        int[] nAlpha = new int[256];
        try {
            int i = 0;
            while (i < this.m_image.getWidth() - this.m_dt.m_nLabelWidth) {
                int j = 0;
                while (j < this.m_image.getHeight()) {
                    int y;
                    int x = this.m_image.getRGB(i, j);
                    int n = y = ((x & 0xFF) + ((x & 0xFF00) >> 8) + ((x & 0xFF0000) >> 16)) / 3;
                    nAlpha[n] = nAlpha[n] + 1;
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return 0.0;
        }
        double fQ = 0.0;
        int i = 1;
        while (i < 255) {
            fQ -= (double)nAlpha[i] * Math.log((double)i / 255.0);
            ++i;
        }
        return 100.0 * fQ / (double)((this.m_image.getWidth() - this.m_dt.m_nLabelWidth) * this.m_image.getHeight());
    }

    @Override
    public void paintComponent(Graphics g) {
        this.m_dt.a_undo.setEnabled(this.m_dt.m_doActions.size() > 0 && this.m_dt.m_iUndo > 1);
        this.m_dt.a_redo.setEnabled(this.m_dt.m_iUndo < this.m_dt.m_doActions.size());
        g.setFont(this.m_dt.m_font);
        switch (this.m_dt.m_viewMode) {
            case DRAW: {
                this.drawTreeSet((Graphics2D)g);
                break;
            }
            case ANIMATE: {
                this.drawFrame(g);
                this.m_dt.m_gridDrawer.paintHeightInfo(g);
                try {
                    Thread.sleep(this.m_dt.m_nAnimationDelay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_dt.m_iAnimateTree = (this.m_dt.m_iAnimateTree + 1) % this.m_dt.m_nTopologies;
                this.repaint();
                return;
            }
            case BROWSE: {
                this.drawFrame(g);
                this.m_dt.m_gridDrawer.paintHeightInfo(g);
                this.m_dt.setDefaultCursor();
                return;
            }
        }
        if (this.m_dt.m_sOutputFile != null && !this.isDrawing()) {
            try {
                Graphics2D g2 = this.m_image.createGraphics();
                this.m_dt.drawLabels(this.m_dt.m_trees[0], g2);
                ImageIO.write((RenderedImage)this.m_image.m_localImage, "png", new File(this.m_dt.m_sOutputFile));
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_dt.m_bViewEditTree && this.m_dt.m_Xmode == 0) {
            this.viewEditTree(g);
        }
        if (this.m_dt.m_bViewClades && this.m_dt.m_bCladesReady && (this.m_dt.m_Xmode == 1 || this.m_dt.m_Xmode == 2)) {
            this.m_dt.m_cladeDrawer.viewClades(g);
        }
        if (this.m_dt.m_showLegend && (this.m_dt.m_lineColorMode == DensiTree.LineColorMode.BY_METADATA_PATTERN || this.m_dt.m_lineColorMode == DensiTree.LineColorMode.COLOR_BY_METADATA_TAG)) {
            Font font = new Font(g.getFont().getName(), 1, 14);
            g.setFont(font);
            int k = 0;
            for (String s : this.m_dt.m_colorMetaDataCategories.keySet()) {
                g.setColor(this.m_dt.m_color[9 + this.m_dt.m_colorMetaDataCategories.get(s) % (this.m_dt.m_color.length - 9)]);
                g.drawString(s, 10, k * 15 + 15);
                ++k;
            }
        }
        if (this.m_selectedImage != null) {
            int w = this.m_selectedImage.getWidth();
            int h = this.m_selectedImage.getHeight();
            g.drawImage(this.m_selectedImage, 0, 0, w, h, 0, 0, w, h, null);
        }
    }

    void viewEditTree(Graphics g) {
        float fScaleX = this.m_dt.m_fScaleX;
        float fScaleY = this.m_dt.m_fScaleY;
        if (this.m_dt.m_bUseLogScale) {
            if (this.m_dt.m_treeDrawer.m_bRootAtTop) {
                fScaleY *= this.m_dt.m_fHeight / (float)Math.log((double)this.m_dt.m_fHeight + 1.0);
            } else {
                fScaleX *= this.m_dt.m_fHeight / (float)Math.log((double)this.m_dt.m_fHeight + 1.0);
            }
        }
        int x = 0;
        int y = 0;
        int x0 = 0;
        int y0 = 0;
        int x1 = 0;
        int y1 = 0;
        g.setColor(Color.BLACK);
        BasicStroke stroke = new BasicStroke(5.0f, 0, 2);
        ((Graphics2D)g).setStroke(stroke);
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
        int h = this.m_dt.m_rotate.getHeight(null);
        int w = this.m_dt.m_rotate.getWidth(null);
        boolean bUpdatePoints = false;
        if (this.m_rotationPoints == null) {
            this.m_rotationPoints = new RotationPoint[this.m_dt.m_fRLinesX[0].length / 4];
            bUpdatePoints = true;
        }
        int i = 1;
        while (i < this.m_dt.m_fRLinesX[0].length - 2) {
            if (this.m_dt.m_treeDrawer.m_bRootAtTop) {
                x = (int)((this.m_dt.m_fRLinesX[0][i] + this.m_dt.m_fRLinesX[0][i + 1]) * fScaleX / 2.0f);
                y = (int)((this.m_dt.m_fCLinesY[0][i] + this.m_dt.m_fRLinesY[0][i + 1]) * fScaleY / 2.0f);
                x0 = (int)(this.m_dt.m_fRLinesX[0][i - 1] * fScaleX);
                y0 = (int)(this.m_dt.m_fRLinesY[0][i - 1] * fScaleY);
                x1 = (int)(this.m_dt.m_fRLinesX[0][i + 2] * fScaleX);
                y1 = (int)(this.m_dt.m_fRLinesY[0][i + 2] * fScaleY);
            } else {
                x = (int)((this.m_dt.m_fRLinesY[0][i] + this.m_dt.m_fRLinesY[0][i + 1]) * fScaleX / 2.0f);
                y = (int)((this.m_dt.m_fRLinesX[0][i] + this.m_dt.m_fRLinesX[0][i + 1]) * fScaleY / 2.0f);
                x0 = (int)(this.m_dt.m_fRLinesY[0][i - 1] * fScaleX);
                y0 = (int)(this.m_dt.m_fRLinesX[0][i - 1] * fScaleY);
                x1 = (int)(this.m_dt.m_fRLinesY[0][i + 2] * fScaleX);
                y1 = (int)(this.m_dt.m_fRLinesX[0][i + 2] * fScaleY);
            }
            if (bUpdatePoints) {
                this.m_rotationPoints[i / 4] = new RotationPoint(x, y);
            }
            g.drawLine(x, y, x0, y0);
            g.drawLine(x, y, x1, y1);
            g.drawImage(this.m_dt.m_rotate, x - w / 2, y - h / 2, x + h / 2, y + w / 2, 0, 0, h, w, null);
            i += 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawTreeSet(Graphics2D g) {
        Color oldBackground = g.getBackground();
        g.setBackground(this.m_dt.m_color[DensiTree.BGCOLOR]);
        Rectangle r = g.getClipBounds();
        g.clearRect(r.x, r.y, r.width, r.height);
        g.setBackground(oldBackground);
        g.setClip(r.x, r.y, r.width, r.height);
        if (this.m_dt.m_trees == null || this.m_dt.m_fCLinesY == null || this.m_dt.m_bInitializing) {
            return;
        }
        TreeSetPanel treeSetPanel = this;
        synchronized (treeSetPanel) {
            this.m_dt.setWaitCursor();
            if (this.m_image == null) {
                System.err.println("Setting up new image");
                this.m_image = !this.m_dt.m_bShowBounds ? new BufferedImageF((int)((float)this.getWidth() * this.m_dt.m_fScale), (int)((float)this.getHeight() * this.m_dt.m_fScale)) : new BufferedImageBounded((int)((float)this.getWidth() * this.m_dt.m_fScale), (int)((float)this.getHeight() * this.m_dt.m_fScale));
                this.m_dt.m_treeDrawer.setImage(this.m_image);
                Graphics2D g2 = this.m_image.createGraphics();
                this.m_image.init(g2, this.m_dt.m_color[DensiTree.BGCOLOR], this.m_dt.m_bgImage, this.m_dt.m_fBGImageBox, this.m_dt.m_nLabelWidth, this.m_dt.m_fMinLong, this.m_dt.m_fMaxLong, this.m_dt.m_fMinLat, this.m_dt.m_fMaxLat);
                this.m_dt.m_gridDrawer.paintHeightInfo(g2);
                if (this.m_image == null) {
                    return;
                }
                this.m_image.SyncIntToRGBImage();
                int nDrawThreads = Math.min(this.m_nDrawThreads, this.m_dt.m_trees.length);
                int i = 0;
                while (i < nDrawThreads) {
                    this.m_drawThread[i] = new DrawThread("draw thread", i, this.m_dt.m_trees.length + i, nDrawThreads, this.m_dt.m_treeDrawer);
                    this.m_drawThread[i].start();
                    ++i;
                }
                if (this.m_dt.m_bShowRootCanalTopology) {
                    this.drawRootCanalTree(g);
                }
            }
        }
        if (this.m_image == null) {
            return;
        }
        this.m_image.drawImage(g, this);
        if (this.m_dt.m_nSelectedRect != null) {
            if (this.m_dt.m_bViewEditTree && this.m_dt.m_Xmode == 0) {
                int h = this.m_dt.m_rotate.getHeight(null);
                int w = this.m_dt.m_rotate.getWidth(null);
                int x = this.m_dt.m_nSelectedRect.x + (this.m_dt.m_treeDrawer.m_bRootAtTop ? this.m_dt.m_nSelectedRect.width : 0);
                int y = this.m_dt.m_nSelectedRect.y + (this.m_dt.m_treeDrawer.m_bRootAtTop ? 0 : this.m_dt.m_nSelectedRect.height);
                g.drawImage(this.m_dt.m_rotate, x - w / 2, y - h / 2, x + h / 2, y + w / 2, 0, 0, h, w, null);
            } else {
                g.drawRect(this.m_dt.m_nSelectedRect.x + Math.min(this.m_dt.m_nSelectedRect.width, 0), this.m_dt.m_nSelectedRect.y + Math.min(this.m_dt.m_nSelectedRect.height, 0), Math.abs(this.m_dt.m_nSelectedRect.width), Math.abs(this.m_dt.m_nSelectedRect.height));
            }
        }
        this.m_dt.drawLabels(this.m_dt.m_trees[0], g);
        if (this.m_dt.m_bDrawGeo && this.m_dt.m_fLatitude.size() > 0) {
            g.setColor(this.m_dt.m_color[DensiTree.GEOCOLOR]);
            BasicStroke stroke = new BasicStroke(this.m_dt.m_nGeoWidth, 0, 2);
            g.setStroke(stroke);
            this.m_dt.drawGeo(this.m_dt.m_cTrees[0], g);
        }
        if (this.isDrawing()) {
            try {
                Thread.sleep(this.m_dt.m_nAnimationDelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
            if (this.m_dt.m_bRecord) {
                try {
                    System.err.println(" writing /tmp/frame" + this.m_dt.m_nFrameNr + ".jpg " + this.isDrawing());
                    ImageIO.write((RenderedImage)this.m_image.m_localImage, "jpg", new File("/tmp/frame" + this.m_dt.m_nFrameNr + ".jpg"));
                    ++this.m_dt.m_nFrameNr;
                }
                catch (Exception exception) {}
            }
        } else {
            this.m_dt.setDefaultCursor();
            if (this.m_dt.m_bRecord) {
                try {
                    System.err.println(" writing /tmp/frame" + this.m_dt.m_nFrameNr + ".jpg " + this.isDrawing());
                    ImageIO.write((RenderedImage)this.m_image.m_localImage, "jpg", new File("/tmp/frame" + this.m_dt.m_nFrameNr + ".jpg"));
                    ++this.m_dt.m_nFrameNr;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_dt.m_bRecord = false;
        }
    }

    void drawRootCanalTree(Graphics2D g) {
        float fScaleX = this.m_dt.m_fScaleX;
        float fScaleY = this.m_dt.m_fScaleY;
        if (this.m_dt.m_bUseLogScale) {
            if (this.m_dt.m_treeDrawer.m_bRootAtTop) {
                fScaleY *= this.m_dt.m_fHeight / (float)Math.log((double)this.m_dt.m_fHeight + 1.0);
            } else {
                fScaleX *= this.m_dt.m_fHeight / (float)Math.log((double)this.m_dt.m_fHeight + 1.0);
            }
        }
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        BasicStroke stroke = new BasicStroke(this.m_dt.m_nCTreeWidth, 0, 2);
        g.setStroke(stroke);
        g.setColor(this.m_dt.m_color[DensiTree.ROOTCANALCOLOR]);
        this.m_dt.m_treeDrawer.draw(0, this.m_dt.m_fRLinesX, this.m_dt.m_fRLinesY, this.m_dt.m_fRLineWidth, this.m_dt.m_fRTopLineWidth, this.m_dt.m_nRLineColor, g, fScaleX, fScaleY);
    }

    void drawFrame(Graphics g) {
        Color oldBackground = ((Graphics2D)g).getBackground();
        ((Graphics2D)g).setBackground(this.m_dt.m_color[DensiTree.BGCOLOR]);
        Rectangle r = g.getClipBounds();
        g.clearRect(r.x, r.y, r.width, r.height);
        ((Graphics2D)g).setBackground(oldBackground);
        g.setClip(r.x, r.y, r.width, r.height);
        if (this.m_dt.m_trees == null || this.m_dt.m_fCLinesY == null || this.m_dt.m_bInitializing) {
            return;
        }
        this.m_dt.setWaitCursor();
        if (this.m_image == null || this.m_dt.m_bAnimateOverwrite || this.m_dt.m_iAnimateTree == 0) {
            this.m_image = !this.m_dt.m_bShowBounds ? new BufferedImageF((int)((float)this.getWidth() * this.m_dt.m_fScale), (int)((float)this.getHeight() * this.m_dt.m_fScale)) : new BufferedImageBounded((int)((float)this.getWidth() * this.m_dt.m_fScale), (int)((float)this.getHeight() * this.m_dt.m_fScale));
            this.m_dt.m_treeDrawer.setImage(this.m_image);
            Graphics2D g2 = this.m_image.createGraphics();
            this.m_image.init(g2, this.m_dt.m_color[DensiTree.BGCOLOR], this.m_dt.m_bgImage, this.m_dt.m_fBGImageBox, this.m_dt.m_nLabelWidth, this.m_dt.m_fMinLong, this.m_dt.m_fMaxLong, this.m_dt.m_fMinLat, this.m_dt.m_fMaxLat);
            if (this.m_dt.m_bDrawGeo && this.m_dt.m_fLatitude.size() > 0) {
                g2.setColor(this.m_dt.m_color[DensiTree.GEOCOLOR]);
                BasicStroke stroke = new BasicStroke(this.m_dt.m_nGeoWidth, 0, 2);
                g2.setStroke(stroke);
                this.m_dt.drawGeo(this.m_dt.m_cTrees[0], g2);
            }
            this.m_dt.m_gridDrawer.paintHeightInfo(g2);
            this.m_dt.drawLabels(this.m_dt.m_trees[0], g2);
            this.m_image.SyncIntToRGBImage();
        }
        int i = 0;
        while (i < this.m_nDrawThreads) {
            this.m_drawThread[i] = new DrawThread("draw thread", i, this.m_dt.m_trees.length + i, this.m_nDrawThreads, this.m_dt.m_iAnimateTree, this.m_dt.m_treeDrawer);
            this.m_drawThread[i].start();
            ++i;
        }
        while (this.isDrawing()) {
            try {
                Thread.sleep(this.m_dt.m_nAnimationDelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_image.drawImage(g, this);
            System.err.print("X");
        }
        this.m_image.drawImage(g, this);
        this.m_dt.setDefaultCursor();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        float fHeight = (float)pageFormat.getImageableHeight();
        float fWidth = (float)pageFormat.getImageableWidth();
        float fScaleX = this.m_dt.m_fScaleX;
        this.m_dt.m_fScaleX = fWidth / (float)this.m_dt.m_sLabels.size();
        float fScaleY = this.m_dt.m_fScaleY;
        this.m_dt.m_fScaleY = (fHeight - 10.0f) / this.m_dt.m_fHeight;
        this.paint(g2d);
        this.m_dt.m_fScaleX = fScaleX;
        this.m_dt.m_fScaleY = fScaleY;
        return 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    void clearSelection() {
        int i = 0;
        while (i < this.m_dt.m_bSelection.length) {
            if (this.m_dt.m_bSelection[i]) {
                this.m_dt.m_bSelection[i] = false;
                this.m_dt.m_bSelectionChanged = true;
            }
            ++i;
        }
        this.m_dt.m_cladeSelection.clear();
        this.m_dt.resetCladeSelection();
    }

    void toggleSelection(Rectangle r) {
        float f = this.m_dt.m_fScale;
        this.m_dt.m_fScale = 1.0f;
        r.x = (int)((float)r.x / this.m_dt.m_fScale);
        r.y = (int)((float)r.y / this.m_dt.m_fScale);
        r.width = 1 + (int)((float)r.width / this.m_dt.m_fScale);
        r.height = 1 + (int)((float)r.height / this.m_dt.m_fScale);
        int i = 0;
        while (i < this.m_dt.m_bSelection.length) {
            if (this.m_dt.m_bLabelRectangle[i].intersects(r)) {
                this.m_dt.m_bSelection[i] = !this.m_dt.m_bSelection[i];
                this.m_dt.m_bSelectionChanged = true;
            }
            ++i;
        }
        if (this.m_rotationPoints != null) {
            r.x += 5;
            r.y += 5;
            Rectangle rotationPoint = new Rectangle(10, 10);
            int i2 = 0;
            while (i2 < this.m_rotationPoints.length) {
                rotationPoint.x = this.m_rotationPoints[i2].m_nX;
                rotationPoint.y = this.m_rotationPoints[i2].m_nY;
                if (r.intersects(rotationPoint)) {
                    if (this.m_dt.m_cladeSelection.contains(i2)) {
                        this.m_dt.m_cladeSelection.remove(i2);
                    } else {
                        this.m_dt.m_cladeSelection.add(i2);
                    }
                }
                ++i2;
            }
            this.m_dt.resetCladeSelection();
        }
        this.m_dt.m_fScale = f;
    }

    void addToSelection(Rectangle r) {
        float f = this.m_dt.m_fScale;
        this.m_dt.m_fScale = 1.0f;
        r.x = (int)((float)r.x / this.m_dt.m_fScale);
        r.y = (int)((float)r.y / this.m_dt.m_fScale);
        r.width = 1 + (int)((float)r.width / this.m_dt.m_fScale);
        r.height = 1 + (int)((float)r.height / this.m_dt.m_fScale);
        int i = 0;
        while (i < this.m_dt.m_bSelection.length) {
            if ((this.m_dt.m_bLabelRectangle[i].intersects(r) || this.m_dt.m_bGeoRectangle[i] != null && this.m_dt.m_bGeoRectangle[i].intersects(r)) && !this.m_dt.m_bSelection[i] && this.m_dt.m_cladeWeight.get(i) >= this.m_dt.m_smallestCladeSupport) {
                this.m_dt.m_bSelection[i] = true;
                this.m_dt.m_bSelectionChanged = true;
            }
            ++i;
        }
        if (this.m_rotationPoints != null) {
            r.x += 5;
            r.y += 5;
            Rectangle rotationPoint = new Rectangle(10, 10);
            int i2 = 0;
            while (i2 < this.m_rotationPoints.length) {
                rotationPoint.x = this.m_rotationPoints[i2].m_nX;
                rotationPoint.y = this.m_rotationPoints[i2].m_nY;
                if (r.intersects(rotationPoint) && this.m_dt.m_cladeWeight.get(i2) >= this.m_dt.m_smallestCladeSupport) {
                    this.m_dt.m_cladeSelection.add(i2);
                }
                ++i2;
            }
            System.err.println(Arrays.toString((Object[])this.m_dt.m_cladeSelection.toArray(new Integer[0])));
            this.m_dt.resetCladeSelection();
        }
        this.m_dt.m_fScale = f;
        System.out.print("selected: ");
        i = 0;
        while (i < this.m_dt.m_bSelection.length) {
            if (this.m_dt.m_bSelection[i]) {
                System.out.println(String.valueOf(this.m_dt.m_sLabels.get(i)) + " ");
            }
            ++i;
        }
        System.out.println();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_bIsDragging = false;
        this.m_dt.m_nSelectedRect = new Rectangle(e.getPoint(), new Dimension(1, 1));
        if (this.m_dt.m_bViewEditTree && this.m_dt.m_Xmode == 0) {
            if (this.m_rotationPoints != null) {
                int i = 0;
                while (i < this.m_rotationPoints.length) {
                    if (this.m_rotationPoints[i].intersects(e.getPoint().x, e.getPoint().y)) {
                        this.m_bIsMoving = true;
                        this.m_dt.m_nSelectedRect = new Rectangle(e.getPoint(), new Dimension(1, 1));
                        return;
                    }
                    ++i;
                }
                this.m_dt.m_nSelectedRect = null;
                this.repaint();
            }
        } else if (this.m_dt.m_bViewClades && (this.m_dt.m_Xmode == 1 || this.m_dt.m_Xmode == 2)) {
            if (this.m_rotationPoints != null) {
                int i = 0;
                while (i < this.m_rotationPoints.length) {
                    if (this.m_rotationPoints[i].intersects(e.getPoint().x, e.getPoint().y) && this.m_dt.m_cladeSelection.contains(i)) {
                        this.m_bIsMoving = true;
                        return;
                    }
                    ++i;
                }
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.m_dt.m_bViewEditTree && this.m_dt.m_Xmode == 0 && e.getButton() == 1 && !this.m_bIsDragging) {
            if (this.m_rotationPoints != null) {
                int i = 0;
                while (i < this.m_rotationPoints.length) {
                    if (this.m_rotationPoints[i].intersects(e.getX(), e.getY())) {
                        this.m_dt.rotateAround(i);
                        this.m_dt.m_nSelectedRect = null;
                        return;
                    }
                    ++i;
                }
            }
        } else if (this.m_dt.m_nSelectedRect != null) {
            if (!this.m_bIsMoving) {
                if (this.m_dt.m_nSelectedRect.width < 0) {
                    this.m_dt.m_nSelectedRect.x += this.m_dt.m_nSelectedRect.width;
                    this.m_dt.m_nSelectedRect.width = -this.m_dt.m_nSelectedRect.width;
                }
                if (this.m_dt.m_nSelectedRect.height < 0) {
                    this.m_dt.m_nSelectedRect.y += this.m_dt.m_nSelectedRect.height;
                    this.m_dt.m_nSelectedRect.height = -this.m_dt.m_nSelectedRect.height;
                }
                if ((e.getModifiersEx() & 0x80) != 0) {
                    this.toggleSelection(this.m_dt.m_nSelectedRect);
                } else if ((e.getModifiersEx() & 0x40) != 0) {
                    this.addToSelection(this.m_dt.m_nSelectedRect);
                } else {
                    this.clearSelection();
                    this.addToSelection(this.m_dt.m_nSelectedRect);
                }
                this.m_dt.m_nSelectedRect = null;
                this.repaint();
            } else {
                this.m_bIsMoving = false;
                this.m_bIsDragging = false;
                if (this.m_rotationPoints != null) {
                    if (this.m_dt.m_bViewEditTree && this.m_dt.m_Xmode == 0) {
                        int i = 0;
                        while (i < this.m_rotationPoints.length) {
                            if (this.m_rotationPoints[i].intersects(this.m_dt.m_nSelectedRect.x, this.m_dt.m_nSelectedRect.y)) {
                                this.m_dt.moveRotationPoint(i, (float)this.m_dt.m_sLabels.size() * (this.m_dt.m_treeDrawer.m_bRootAtTop ? (float)this.m_dt.m_nSelectedRect.width / (float)this.getWidth() : (float)this.m_dt.m_nSelectedRect.height / (float)this.getHeight()));
                                this.m_dt.m_nSelectedRect = null;
                                this.repaint();
                                return;
                            }
                            ++i;
                        }
                    } else if (this.m_dt.m_bViewClades && (this.m_dt.m_Xmode == 1 || this.m_dt.m_Xmode == 2)) {
                        double dF = (float)this.m_dt.m_sLabels.size() * (this.m_dt.m_treeDrawer.m_bRootAtTop ? (float)this.m_dt.m_nSelectedRect.width / (float)this.getWidth() : (float)this.m_dt.m_nSelectedRect.height / (float)this.getHeight());
                        Iterator<Integer> iterator = this.m_dt.m_cladeSelection.iterator();
                        while (iterator.hasNext()) {
                            int i;
                            int n = i = iterator.next().intValue();
                            this.m_dt.m_cladePosition[n] = (float)((double)this.m_dt.m_cladePosition[n] + dF);
                        }
                        this.m_dt.calcLines();
                        this.m_dt.makeDirty();
                        this.m_dt.m_nSelectedRect = null;
                        this.repaint();
                        return;
                    }
                    this.m_dt.m_nSelectedRect = null;
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.m_dt.m_nSelectedRect != null) {
            this.m_bIsDragging = true;
            this.m_dt.m_nSelectedRect.width = e.getPoint().x - this.m_dt.m_nSelectedRect.x;
            this.m_dt.m_nSelectedRect.height = e.getPoint().y - this.m_dt.m_nSelectedRect.y;
            this.repaint();
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.m_dt.m_bDrawGeo) {
            int i = 0;
            while (i < this.m_dt.m_bSelection.length) {
                if (this.m_dt.m_bGeoRectangle[i].contains(e.getPoint())) {
                    this.m_dt.m_jStatusBar.setText(this.m_dt.m_sLabels.elementAt(i));
                }
                ++i;
            }
        }
        Point p = e.getPoint();
        boolean found = false;
        if (this.m_dt.m_bLabelRectangle != null) {
            int i = 0;
            while (i < this.m_dt.m_bLabelRectangle.length) {
                if (this.m_dt.m_bLabelRectangle[i].contains(p)) {
                    int h;
                    int w;
                    this.m_dt.m_jStatusBar.setText(String.valueOf(this.m_dt.m_sLabels.elementAt(i)) + " ");
                    if (this.m_dt.m_LabelImages != null) {
                        w = 0;
                        h = 0;
                        BufferedImage old = this.m_selectedImage;
                        if (this.m_selectedImage != null) {
                            w = old.getWidth();
                            h = old.getHeight();
                        }
                        this.m_selectedImage = this.m_dt.m_LabelImages[i];
                        if (this.m_selectedImage != null) {
                            w = Math.max(w, this.m_selectedImage.getWidth());
                            h = Math.max(h, this.m_selectedImage.getHeight());
                        }
                        if (old != this.m_selectedImage) {
                            this.repaint(0, 0, w, h);
                        }
                    } else if (this.m_selectedImage != null) {
                        w = this.m_selectedImage.getWidth();
                        h = this.m_selectedImage.getHeight();
                        this.m_selectedImage = null;
                        this.repaint(0, 0, w, h);
                    }
                    found = true;
                }
                ++i;
            }
            if (!found) {
                this.m_dt.m_jStatusBar.setText("");
            }
        }
        String sText = this.m_dt.m_jStatusBar.getText();
        sText = sText.split("\t")[0];
        float fHeight = this.m_dt.screenPosToHeight(e.getX(), e.getY());
        if (!Float.isNaN(fHeight)) {
            sText = String.valueOf(sText) + "\theight=" + fHeight;
            this.m_dt.m_jStatusBar.setText(sText);
        }
    }

    class DrawThread
    extends Thread {
        public boolean m_bStop;
        int m_nFrom;
        int m_nTo;
        int m_nEvery;
        int m_iTreeTopology;
        TreeDrawer m_treeDrawer;

        public DrawThread(String str, int nFrom, int nTo, int nEvery, int iTreeTopology, TreeDrawer treeDrawer) {
            super(str);
            this.m_bStop = false;
            this.m_nFrom = 0;
            this.m_nTo = 1;
            this.m_nEvery = 1;
            this.m_iTreeTopology = -1;
            this.m_treeDrawer = treeDrawer;
            this.m_nFrom = nFrom;
            this.m_nTo = nTo;
            this.m_nEvery = nEvery;
            this.m_iTreeTopology = iTreeTopology;
        }

        public DrawThread(String str, int nFrom, int nTo, int nEvery, TreeDrawer treeDrawer) {
            super(str);
            this.m_bStop = false;
            this.m_nFrom = 0;
            this.m_nTo = 1;
            this.m_nEvery = 1;
            this.m_iTreeTopology = -1;
            this.m_nFrom = nFrom;
            this.m_nTo = nTo;
            this.m_nEvery = nEvery;
            TreeSetPanel.this.m_dt.m_treeDrawer = treeDrawer;
        }

        @Override
        public void run() {
            if (TreeSetPanel.this.m_image == null) {
                return;
            }
            Graphics2D g = TreeSetPanel.this.m_image.createGraphics();
            try {
                int i;
                g.setClip(0, 0, TreeSetPanel.this.m_image.getWidth(), TreeSetPanel.this.m_image.getHeight());
                TreeSetPanel.this.m_image.scale(g, TreeSetPanel.this.m_dt.m_fScale, TreeSetPanel.this.m_dt.m_fScale);
                float fScaleX = TreeSetPanel.this.m_dt.m_fScaleX;
                float fScaleY = TreeSetPanel.this.m_dt.m_fScaleY;
                if (TreeSetPanel.this.m_dt.m_bUseLogScale) {
                    if (this.m_treeDrawer.m_bRootAtTop) {
                        fScaleY *= TreeSetPanel.this.m_dt.m_fHeight / (float)Math.log((double)TreeSetPanel.this.m_dt.m_fHeight + 1.0);
                    } else {
                        fScaleX *= TreeSetPanel.this.m_dt.m_fHeight / (float)Math.log((double)TreeSetPanel.this.m_dt.m_fHeight + 1.0);
                    }
                }
                if (TreeSetPanel.this.m_dt.m_bViewAllTrees && this.m_nTo >= this.m_nEvery) {
                    int iStart = this.m_nTo - this.m_nEvery;
                    float fAlpha = Math.min(1.0f, 20.0f / (float)iStart * TreeSetPanel.this.m_dt.m_fTreeIntensity);
                    g.setComposite(AlphaComposite.getInstance(3, fAlpha));
                    BasicStroke stroke = new BasicStroke(TreeSetPanel.this.m_dt.m_nTreeWidth, 0, 2);
                    g.setStroke(stroke);
                    TreeSetPanel.this.m_dt.m_treeDrawer.setJitter(TreeSetPanel.this.m_dt.m_nJitter);
                    i = iStart;
                    while (i >= this.m_nFrom) {
                        if (this.m_bStop) {
                            return;
                        }
                        if (this.m_iTreeTopology < 0 || this.m_iTreeTopology == TreeSetPanel.this.m_dt.m_nTopologyByPopularity[i]) {
                            TreeSetPanel.this.m_dt.m_treeDrawer.draw(i, TreeSetPanel.this.m_dt.m_fLinesX, TreeSetPanel.this.m_dt.m_fLinesY, TreeSetPanel.this.m_dt.m_fLineWidth, TreeSetPanel.this.m_dt.m_fTopLineWidth, TreeSetPanel.this.m_dt.m_nLineColor, g, fScaleX, fScaleY);
                            if (i % 100 == 0) {
                                System.err.print('.');
                                TreeSetPanel.this.m_dt.m_jStatusBar.setText("Drawing tree " + i);
                            }
                        }
                        i -= this.m_nEvery;
                    }
                }
                if (TreeSetPanel.this.m_dt.m_bViewCTrees) {
                    TreeSetPanel.this.m_dt.m_jStatusBar.setText("Drawing consensus trees");
                    BasicStroke stroke = new BasicStroke(TreeSetPanel.this.m_dt.m_nCTreeWidth, 0, 2);
                    g.setStroke(stroke);
                    g.setComposite(AlphaComposite.getInstance(3, 1.0f));
                    g.setClip(0, 0, TreeSetPanel.this.getWidth(), TreeSetPanel.this.getHeight());
                    TreeSetPanel.this.m_dt.m_treeDrawer.setJitter(0);
                    int i2 = this.m_nFrom;
                    while (i2 < TreeSetPanel.this.m_dt.m_nTopologies) {
                        if (this.m_bStop) {
                            return;
                        }
                        if (this.m_iTreeTopology < 0 || this.m_iTreeTopology == i2) {
                            g.setComposite(AlphaComposite.getInstance(3, Math.min(1.0f, 0.5f * TreeSetPanel.this.m_dt.m_fCTreeIntensity * TreeSetPanel.this.m_dt.m_fTreeWeight[i2])));
                            TreeSetPanel.this.m_dt.m_treeDrawer.draw(i2, TreeSetPanel.this.m_dt.m_fCLinesX, TreeSetPanel.this.m_dt.m_fCLinesY, TreeSetPanel.this.m_dt.m_fCLineWidth, TreeSetPanel.this.m_dt.m_fTopCLineWidth, TreeSetPanel.this.m_dt.m_nCLineColor, g, fScaleX, fScaleY);
                            if (i2 % 100 == 0) {
                                System.err.print('x');
                                TreeSetPanel.this.m_dt.m_jStatusBar.setText("Drawing consensus tree " + i2);
                            }
                        }
                        i2 += this.m_nEvery;
                    }
                }
                if (TreeSetPanel.this.m_dt.m_viewMode == DensiTree.ViewMode.DRAW) {
                    TreeSetPanel.this.m_drawThread[this.m_nFrom] = null;
                    if (!TreeSetPanel.this.isDrawing()) {
                        if (TreeSetPanel.this.m_dt.m_bShowRootCanalTopology) {
                            TreeSetPanel.this.drawRootCanalTree(g);
                        }
                        double fEntropy = TreeSetPanel.this.calcImageEntropy();
                        TreeSetPanel.this.m_dt.m_jStatusBar.setText("Done Drawing trees ");
                        System.out.println("Entropy(x100): " + fEntropy + " Mean cumulative width: " + TreeSetPanel.this.m_dt.m_w);
                    }
                    TreeSetPanel.this.repaint();
                } else {
                    DecimalFormat df = new DecimalFormat("##.##");
                    double fSum = 0.0;
                    i = 0;
                    while (i <= TreeSetPanel.this.m_dt.m_iAnimateTree) {
                        fSum += (double)TreeSetPanel.this.m_dt.m_fTreeWeight[i];
                        ++i;
                    }
                    TreeSetPanel.this.m_dt.m_jStatusBar.setText("Consensus tree " + (TreeSetPanel.this.m_dt.m_iAnimateTree + 1) + " out of " + TreeSetPanel.this.m_dt.m_nTopologies + " covering " + df.format(TreeSetPanel.this.m_dt.m_fTreeWeight[TreeSetPanel.this.m_dt.m_iAnimateTree] * 100.0f) + "% of trees " + df.format(fSum * 100.0) + "% cumultive trees");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("DRAWING ERROR -- IGNORED");
            }
            TreeSetPanel.this.m_drawThread[this.m_nFrom] = null;
        }
    }
}

