/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import viz.DensiTree;
import viz.graphics.JFontChooser;
import viz.panel.RoundedButton;
import viz.util.Util;

public class LabelPanel
extends JPanel {
    public static final String HELP_LABEL_WIDTH = "Width of the label.";
    public static final String HELP_ROTATE = "Rotate label -- is only effective when root at top.";
    public static final String HELP_ALIGN = "Align labels with label for youngest tip. This is only useful when tips are not all from the same date.";
    public static final String HELP_HIDE = "Hide labels.";
    public static final String HELP_FONT = "Font used for labels.";
    public static final String HELP_COLOR = "Color used for labels.";
    public static final String HELP_SEARCH = "Search for labels. Labels matching the search string will be selected/highlighted.";
    public static final String HELP_LOAD = "Load images for all taxa.";
    public static final String HELP_IMAGE_SIZE = "Size of images used in labels.";
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    DensiTree m_dt;
    private JTextField textField_1;
    private JTextField textField_2;

    public LabelPanel(DensiTree dt) {
        this.m_dt = dt;
        GridBagLayout layout = new GridBagLayout();
        layout.columnWeights = new double[]{0.0, 1.0};
        this.setLayout(layout);
        JLabel lblWidth = new JLabel("Width");
        lblWidth.setToolTipText(Util.formatToolTipAsHtml(HELP_LABEL_WIDTH));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.anchor = 17;
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)lblWidth, gbc_panel);
        this.textField = new JTextField();
        this.textField.setToolTipText(Util.formatToolTipAsHtml(HELP_LABEL_WIDTH));
        this.textField.addActionListener(e -> {
            try {
                this.m_dt.m_nLabelWidth = Integer.parseInt(this.textField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_dt.fitToScreen();
        });
        this.textField.setText(String.valueOf(this.m_dt.m_nLabelWidth));
        GridBagConstraints gbc_width = new GridBagConstraints();
        gbc_width.anchor = 17;
        gbc_width.insets = new Insets(0, 0, 5, 0);
        gbc_width.gridx = 1;
        gbc_width.gridy = 0;
        this.add((Component)this.textField, gbc_width);
        this.textField.setColumns(5);
        JCheckBox chckbxRotate = new JCheckBox("Rotate");
        chckbxRotate.setToolTipText(Util.formatToolTipAsHtml(HELP_ROTATE));
        chckbxRotate.addActionListener(e -> {
            JCheckBox button = (JCheckBox)e.getSource();
            this.m_dt.m_bRotateTextWhenRootAtTop = button.isSelected();
            this.m_dt.fitToScreen();
        });
        JLabel lblIndent = new JLabel("Indent");
        GridBagConstraints gbc_lblIndent = new GridBagConstraints();
        gbc_lblIndent.anchor = 17;
        gbc_lblIndent.insets = new Insets(0, 0, 5, 5);
        gbc_lblIndent.gridx = 0;
        gbc_lblIndent.gridy = 1;
        this.add((Component)lblIndent, gbc_lblIndent);
        this.textField_2 = new JTextField(String.valueOf(this.m_dt.m_fLabelIndent));
        this.textField_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    LabelPanel.this.m_dt.m_fLabelIndent = Float.parseFloat(LabelPanel.this.textField.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LabelPanel.this.m_dt.fitToScreen();
            }
        });
        GridBagConstraints gbc_textField_2 = new GridBagConstraints();
        gbc_textField_2.anchor = 17;
        gbc_textField_2.insets = new Insets(0, 0, 5, 0);
        gbc_textField_2.gridx = 1;
        gbc_textField_2.gridy = 1;
        this.add((Component)this.textField_2, gbc_textField_2);
        this.textField_2.setColumns(5);
        GridBagConstraints gbc_chckbxRotate = new GridBagConstraints();
        gbc_chckbxRotate.anchor = 17;
        gbc_chckbxRotate.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxRotate.gridx = 1;
        gbc_chckbxRotate.gridy = 2;
        this.add((Component)chckbxRotate, gbc_chckbxRotate);
        RoundedButton btnColor = new RoundedButton("Color");
        btnColor.setToolTipText(Util.formatToolTipAsHtml(HELP_COLOR));
        btnColor.addActionListener(e -> {
            Color newColor = JColorChooser.showDialog(this.m_dt.m_Panel, this.getName(), this.m_dt.m_color[DensiTree.LABELCOLOR]);
            if (newColor != null) {
                this.m_dt.m_color[DensiTree.LABELCOLOR] = newColor;
                this.m_dt.makeDirty();
            }
            this.m_dt.repaint();
        });
        RoundedButton btnFont = new RoundedButton("Font");
        btnFont.setToolTipText(Util.formatToolTipAsHtml(HELP_FONT));
        btnFont.addActionListener(e -> {
            int result;
            JFontChooser fontChooser = new JFontChooser();
            if (this.m_dt.m_font != null) {
                fontChooser.setSelectedFont(this.m_dt.m_font);
            }
            if ((result = fontChooser.showDialog(null)) == 0) {
                this.m_dt.m_font = fontChooser.getSelectedFont();
                this.m_dt.makeDirty();
                this.m_dt.repaint();
            }
        });
        JCheckBox chckbxAlign = new JCheckBox("Align");
        chckbxAlign.setToolTipText(Util.formatToolTipAsHtml(HELP_ALIGN));
        chckbxAlign.setSelected(this.m_dt.m_bAlignLabels);
        chckbxAlign.addActionListener(e -> {
            this.m_dt.m_bAlignLabels = ((JCheckBox)e.getSource()).isSelected();
            this.m_dt.makeDirty();
        });
        GridBagConstraints gbc_chckbxAlign = new GridBagConstraints();
        gbc_chckbxAlign.anchor = 17;
        gbc_chckbxAlign.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxAlign.gridx = 1;
        gbc_chckbxAlign.gridy = 3;
        this.add((Component)chckbxAlign, gbc_chckbxAlign);
        JCheckBox chckbxHide = new JCheckBox("Hide");
        chckbxHide.setToolTipText(Util.formatToolTipAsHtml(HELP_HIDE));
        chckbxHide.addActionListener(e -> {
            this.m_dt.m_bHideLabels = ((JCheckBox)e.getSource()).isSelected();
            this.m_dt.makeDirty();
        });
        GridBagConstraints gbc_chckbxHide = new GridBagConstraints();
        gbc_chckbxHide.anchor = 17;
        gbc_chckbxHide.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxHide.gridx = 1;
        gbc_chckbxHide.gridy = 4;
        this.add((Component)chckbxHide, gbc_chckbxHide);
        GridBagConstraints gbc_btnFont = new GridBagConstraints();
        gbc_btnFont.insets = new Insets(0, 0, 5, 5);
        gbc_btnFont.gridx = 0;
        gbc_btnFont.gridy = 5;
        this.add((Component)btnFont, gbc_btnFont);
        GridBagConstraints gbc_btnColor = new GridBagConstraints();
        gbc_btnColor.insets = new Insets(0, 0, 5, 0);
        gbc_btnColor.gridx = 1;
        gbc_btnColor.gridy = 5;
        this.add((Component)btnColor, gbc_btnColor);
        JLabel lblSearch = new JLabel("Search");
        lblSearch.setToolTipText(Util.formatToolTipAsHtml(HELP_SEARCH));
        GridBagConstraints gbc_lblSearch = new GridBagConstraints();
        gbc_lblSearch.insets = new Insets(0, 0, 5, 5);
        gbc_lblSearch.anchor = 17;
        gbc_lblSearch.gridx = 0;
        gbc_lblSearch.gridy = 6;
        this.add((Component)lblSearch, gbc_lblSearch);
        this.textField_1 = new JTextField();
        this.textField_1.setToolTipText(Util.formatToolTipAsHtml(HELP_SEARCH));
        GridBagConstraints gbc_textField_1 = new GridBagConstraints();
        gbc_textField_1.insets = new Insets(0, 0, 5, 0);
        gbc_textField_1.fill = 2;
        gbc_textField_1.gridx = 1;
        gbc_textField_1.gridy = 6;
        this.add((Component)this.textField_1, gbc_textField_1);
        this.textField_1.setColumns(5);
        RoundedButton btnLoad = new RoundedButton("Load image map");
        btnLoad.setToolTipText(HELP_LOAD);
        btnLoad.addActionListener(e -> this.m_dt.loadImages());
        GridBagConstraints gbc_btnLoad = new GridBagConstraints();
        gbc_btnLoad.gridwidth = 2;
        gbc_btnLoad.insets = new Insets(0, 0, 0, 5);
        gbc_btnLoad.gridx = 0;
        gbc_btnLoad.gridy = 7;
        this.add((Component)btnLoad, gbc_btnLoad);
        this.textField_1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateSelection();
            }

            private void updateSelection() {
                try {
                    String sPattern = ".*" + LabelPanel.this.textField_1.getText() + ".*";
                    Pattern pattern = Pattern.compile(sPattern);
                    int i = 0;
                    while (i < LabelPanel.this.m_dt.m_sLabels.size()) {
                        Matcher m = pattern.matcher(LabelPanel.this.m_dt.m_sLabels.get(i));
                        LabelPanel.this.m_dt.m_bSelection[i] = m.find();
                        ++i;
                    }
                    LabelPanel.this.m_dt.m_Panel.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }
}

