/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "thumbnail_options.h"

ThumbnailOptions::ThumbnailOptions (bool init /* = true */) :
    mOptions (ThumbnailOptions::OptionNum),
    mNotify (ThumbnailOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ThumbnailOptions::initOptions ()
{
    unsigned short color[4];

    // always_on_top
    mOptions[ThumbnailOptions::AlwaysOnTop].setName ("always_on_top", CompOption::TypeBool);
    mOptions[ThumbnailOptions::AlwaysOnTop].value().set(true);

    // thumb_size
    mOptions[ThumbnailOptions::ThumbSize].setName ("thumb_size", CompOption::TypeInt);
    mOptions[ThumbnailOptions::ThumbSize].rest ().set (50, 1500);
    mOptions[ThumbnailOptions::ThumbSize].value().set((int) 200);

    // show_delay
    mOptions[ThumbnailOptions::ShowDelay].setName ("show_delay", CompOption::TypeInt);
    mOptions[ThumbnailOptions::ShowDelay].rest ().set (100, 10000);
    mOptions[ThumbnailOptions::ShowDelay].value().set((int) 100);

    // fade_speed
    mOptions[ThumbnailOptions::FadeSpeed].setName ("fade_speed", CompOption::TypeFloat);
    mOptions[ThumbnailOptions::FadeSpeed].rest ().set (0.0, 5.0, 0.1);
    mOptions[ThumbnailOptions::FadeSpeed].value().set((float) 0.5);

    // border
    mOptions[ThumbnailOptions::Border].setName ("border", CompOption::TypeInt);
    mOptions[ThumbnailOptions::Border].rest ().set (1, 32);
    mOptions[ThumbnailOptions::Border].value().set((int) 16);

    // thumb_color
    mOptions[ThumbnailOptions::ThumbColor].setName ("thumb_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0000));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0x0000));
    color[3] = MAX (0, MIN (0xffff, 0x7fff));
    mOptions[ThumbnailOptions::ThumbColor].value().set(color);

    // window_like
    mOptions[ThumbnailOptions::WindowLike].setName ("window_like", CompOption::TypeBool);
    mOptions[ThumbnailOptions::WindowLike].value().set(true);

    // mipmap
    mOptions[ThumbnailOptions::Mipmap].setName ("mipmap", CompOption::TypeBool);
    mOptions[ThumbnailOptions::Mipmap].value().set(false);

    // current_viewport
    mOptions[ThumbnailOptions::CurrentViewport].setName ("current_viewport", CompOption::TypeBool);
    mOptions[ThumbnailOptions::CurrentViewport].value().set(true);

    // title_enabled
    mOptions[ThumbnailOptions::TitleEnabled].setName ("title_enabled", CompOption::TypeBool);
    mOptions[ThumbnailOptions::TitleEnabled].value().set(true);

    // font_bold
    mOptions[ThumbnailOptions::FontBold].setName ("font_bold", CompOption::TypeBool);
    mOptions[ThumbnailOptions::FontBold].value().set(true);

    // text_distance
    mOptions[ThumbnailOptions::TextDistance].setName ("text_distance", CompOption::TypeInt);
    mOptions[ThumbnailOptions::TextDistance].rest ().set (0, 32);
    mOptions[ThumbnailOptions::TextDistance].value().set((int) 10);

    // font_size
    mOptions[ThumbnailOptions::FontSize].setName ("font_size", CompOption::TypeInt);
    mOptions[ThumbnailOptions::FontSize].rest ().set (6, 36);
    mOptions[ThumbnailOptions::FontSize].value().set((int) 12);

    // font_color
    mOptions[ThumbnailOptions::FontColor].setName ("font_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[ThumbnailOptions::FontColor].value().set(color);

    // font_background_color
    mOptions[ThumbnailOptions::FontBackgroundColor].setName ("font_background_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0000));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0x0000));
    color[3] = MAX (0, MIN (0xffff, 0x7fff));
    mOptions[ThumbnailOptions::FontBackgroundColor].value().set(color);

}

ThumbnailOptions::~ThumbnailOptions ()
{
}


CompOption::Vector &
ThumbnailOptions::getOptions ()
{
    return mOptions;
}

bool
ThumbnailOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ThumbnailOptions::AlwaysOnTop:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::AlwaysOnTop].empty ())
                    mNotify[ThumbnailOptions::AlwaysOnTop] (o, ThumbnailOptions::AlwaysOnTop);
                return true;
            }
            break;
        case ThumbnailOptions::ThumbSize:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::ThumbSize].empty ())
                    mNotify[ThumbnailOptions::ThumbSize] (o, ThumbnailOptions::ThumbSize);
                return true;
            }
            break;
        case ThumbnailOptions::ShowDelay:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::ShowDelay].empty ())
                    mNotify[ThumbnailOptions::ShowDelay] (o, ThumbnailOptions::ShowDelay);
                return true;
            }
            break;
        case ThumbnailOptions::FadeSpeed:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::FadeSpeed].empty ())
                    mNotify[ThumbnailOptions::FadeSpeed] (o, ThumbnailOptions::FadeSpeed);
                return true;
            }
            break;
        case ThumbnailOptions::Border:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::Border].empty ())
                    mNotify[ThumbnailOptions::Border] (o, ThumbnailOptions::Border);
                return true;
            }
            break;
        case ThumbnailOptions::ThumbColor:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::ThumbColor].empty ())
                    mNotify[ThumbnailOptions::ThumbColor] (o, ThumbnailOptions::ThumbColor);
                return true;
            }
            break;
        case ThumbnailOptions::WindowLike:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::WindowLike].empty ())
                    mNotify[ThumbnailOptions::WindowLike] (o, ThumbnailOptions::WindowLike);
                return true;
            }
            break;
        case ThumbnailOptions::Mipmap:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::Mipmap].empty ())
                    mNotify[ThumbnailOptions::Mipmap] (o, ThumbnailOptions::Mipmap);
                return true;
            }
            break;
        case ThumbnailOptions::CurrentViewport:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::CurrentViewport].empty ())
                    mNotify[ThumbnailOptions::CurrentViewport] (o, ThumbnailOptions::CurrentViewport);
                return true;
            }
            break;
        case ThumbnailOptions::TitleEnabled:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::TitleEnabled].empty ())
                    mNotify[ThumbnailOptions::TitleEnabled] (o, ThumbnailOptions::TitleEnabled);
                return true;
            }
            break;
        case ThumbnailOptions::FontBold:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::FontBold].empty ())
                    mNotify[ThumbnailOptions::FontBold] (o, ThumbnailOptions::FontBold);
                return true;
            }
            break;
        case ThumbnailOptions::TextDistance:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::TextDistance].empty ())
                    mNotify[ThumbnailOptions::TextDistance] (o, ThumbnailOptions::TextDistance);
                return true;
            }
            break;
        case ThumbnailOptions::FontSize:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::FontSize].empty ())
                    mNotify[ThumbnailOptions::FontSize] (o, ThumbnailOptions::FontSize);
                return true;
            }
            break;
        case ThumbnailOptions::FontColor:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::FontColor].empty ())
                    mNotify[ThumbnailOptions::FontColor] (o, ThumbnailOptions::FontColor);
                return true;
            }
            break;
        case ThumbnailOptions::FontBackgroundColor:
            if (o->set (value))
            {
                if (!mNotify[ThumbnailOptions::FontBackgroundColor].empty ())
                    mNotify[ThumbnailOptions::FontBackgroundColor] (o, ThumbnailOptions::FontBackgroundColor);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

