/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "wallpaper_options.h"

WallpaperOptions::WallpaperOptions (bool init /* = true */) :
    mOptions (WallpaperOptions::OptionNum),
    mNotify (WallpaperOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
WallpaperOptions::initOptions ()
{
    CompOption::Value::Vector list;
    CompOption::Value value;

    // bg_image
    mOptions[WallpaperOptions::BgImage].setName ("bg_image", CompOption::TypeList);
    value.set (CompOption::TypeString, CompOption::Value::Vector (0));
    mOptions[WallpaperOptions::BgImage].set (value);

    // bg_image_pos
    mOptions[WallpaperOptions::BgImagePos].setName ("bg_image_pos", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[WallpaperOptions::BgImagePos].set (value);
    mOptions[WallpaperOptions::BgImagePos].rest ().set (0, 4);

    // bg_fill_type
    mOptions[WallpaperOptions::BgFillType].setName ("bg_fill_type", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[WallpaperOptions::BgFillType].set (value);
    mOptions[WallpaperOptions::BgFillType].rest ().set (0, 2);

    // bg_color1
    mOptions[WallpaperOptions::BgColor1].setName ("bg_color1", CompOption::TypeList);
    value.set (CompOption::TypeColor, CompOption::Value::Vector (0));
    mOptions[WallpaperOptions::BgColor1].set (value);

    // bg_color2
    mOptions[WallpaperOptions::BgColor2].setName ("bg_color2", CompOption::TypeList);
    value.set (CompOption::TypeColor, CompOption::Value::Vector (0));
    mOptions[WallpaperOptions::BgColor2].set (value);

    // cycle_wallpapers
    mOptions[WallpaperOptions::CycleWallpapers].setName ("cycle_wallpapers", CompOption::TypeBool);
    mOptions[WallpaperOptions::CycleWallpapers].value().set(false);

    // cycle_timeout
    mOptions[WallpaperOptions::CycleTimeout].setName ("cycle_timeout", CompOption::TypeFloat);
    mOptions[WallpaperOptions::CycleTimeout].rest ().set (0.15, 1440.0, 0.1f);
    mOptions[WallpaperOptions::CycleTimeout].value().set((float) 10.0);

    // fade_duration
    mOptions[WallpaperOptions::FadeDuration].setName ("fade_duration", CompOption::TypeFloat);
    mOptions[WallpaperOptions::FadeDuration].rest ().set (0.05, 10.0, 0.1f);
    mOptions[WallpaperOptions::FadeDuration].value().set((float) 2.0);

    mBgImagePosMask = 0;
    foreach (CompOption::Value &val, mOptions[WallpaperOptions::BgImagePos].value ().list ())
        mBgImagePosMask |= (1 << val.i ());

    mBgFillTypeMask = 0;
    foreach (CompOption::Value &val, mOptions[WallpaperOptions::BgFillType].value ().list ())
        mBgFillTypeMask |= (1 << val.i ());

}

WallpaperOptions::~WallpaperOptions ()
{
}


CompOption::Vector &
WallpaperOptions::getOptions ()
{
    return mOptions;
}

bool
WallpaperOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case WallpaperOptions::BgImage:
            if (o->set (value))
            {
                if (!mNotify[WallpaperOptions::BgImage].empty ())
                    mNotify[WallpaperOptions::BgImage] (o, WallpaperOptions::BgImage);
                return true;
            }
            break;
        case WallpaperOptions::BgImagePos:
            if (o->set (value))
            {
                mBgImagePosMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mBgImagePosMask |= (1 << val.i ());
                if (!mNotify[WallpaperOptions::BgImagePos].empty ())
                    mNotify[WallpaperOptions::BgImagePos] (o, WallpaperOptions::BgImagePos);
                return true;
            }
            break;
        case WallpaperOptions::BgFillType:
            if (o->set (value))
            {
                mBgFillTypeMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mBgFillTypeMask |= (1 << val.i ());
                if (!mNotify[WallpaperOptions::BgFillType].empty ())
                    mNotify[WallpaperOptions::BgFillType] (o, WallpaperOptions::BgFillType);
                return true;
            }
            break;
        case WallpaperOptions::BgColor1:
            if (o->set (value))
            {
                if (!mNotify[WallpaperOptions::BgColor1].empty ())
                    mNotify[WallpaperOptions::BgColor1] (o, WallpaperOptions::BgColor1);
                return true;
            }
            break;
        case WallpaperOptions::BgColor2:
            if (o->set (value))
            {
                if (!mNotify[WallpaperOptions::BgColor2].empty ())
                    mNotify[WallpaperOptions::BgColor2] (o, WallpaperOptions::BgColor2);
                return true;
            }
            break;
        case WallpaperOptions::CycleWallpapers:
            if (o->set (value))
            {
                if (!mNotify[WallpaperOptions::CycleWallpapers].empty ())
                    mNotify[WallpaperOptions::CycleWallpapers] (o, WallpaperOptions::CycleWallpapers);
                return true;
            }
            break;
        case WallpaperOptions::CycleTimeout:
            if (o->set (value))
            {
                if (!mNotify[WallpaperOptions::CycleTimeout].empty ())
                    mNotify[WallpaperOptions::CycleTimeout] (o, WallpaperOptions::CycleTimeout);
                return true;
            }
            break;
        case WallpaperOptions::FadeDuration:
            if (o->set (value))
            {
                if (!mNotify[WallpaperOptions::FadeDuration].empty ())
                    mNotify[WallpaperOptions::FadeDuration] (o, WallpaperOptions::FadeDuration);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

