/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.utility.GUI;
import electric.xml.Element;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class FindReplaceDialog
extends JDialog
implements WindowSettingsSavable {
    JTextComponent textArea = null;
    private static WeakHashMap<Component, FindReplaceDialog> map = new WeakHashMap();
    private JRadioButton backwardsRadio;
    private JCheckBox caseSensitiveBox;
    private JButton closeButton;
    private ButtonGroup directionButtonGroup;
    private JPanel directionPanel;
    private JButton findButton;
    private JLabel findLabel;
    private JTextField findText;
    private JRadioButton forwardsRadio;
    private JButton jButton1;
    private JPanel optionsPanel;
    private JButton replaceAllButton;
    private JButton replaceFindButton;
    private JLabel replaceLabel;
    private JTextField replaceText;
    private JCheckBox wrapSearchBox;

    public static void showFindReplace(JTextComponent textComponent) {
        Component root = SwingUtilities.getRoot(textComponent);
        if (!map.containsKey(root)) {
            FindReplaceDialog dialog;
            if (root instanceof Frame) {
                dialog = new FindReplaceDialog((Frame)root);
            } else if (root instanceof Dialog) {
                dialog = new FindReplaceDialog((Dialog)root);
            } else {
                return;
            }
            map.put(root, dialog);
        }
        FindReplaceDialog findReplaceDialog = map.get(root);
        findReplaceDialog.setTextArea(textComponent);
        String selectedText = textComponent.getSelectedText();
        if (selectedText != null) {
            findReplaceDialog.setInititalSearchText(selectedText);
        }
        findReplaceDialog.setVisible(true);
    }

    public FindReplaceDialog(Frame parent) {
        super(parent);
        this.initComponents();
        GUI.centerOnScreen((Component)this);
        this.pack();
    }

    public FindReplaceDialog(Dialog parent) {
        super(parent);
        this.initComponents();
        GUI.centerOnScreen((Component)this);
        this.pack();
    }

    private void initComponents() {
        this.directionButtonGroup = new ButtonGroup();
        this.findLabel = new JLabel();
        this.replaceLabel = new JLabel();
        this.findText = new JTextField();
        this.replaceText = new JTextField();
        this.directionPanel = new JPanel();
        this.forwardsRadio = new JRadioButton();
        this.backwardsRadio = new JRadioButton();
        this.optionsPanel = new JPanel();
        this.wrapSearchBox = new JCheckBox();
        this.caseSensitiveBox = new JCheckBox();
        this.findButton = new JButton();
        this.replaceFindButton = new JButton();
        this.jButton1 = new JButton();
        this.replaceAllButton = new JButton();
        this.closeButton = new JButton();
        this.setTitle("Find and Replace");
        this.setName("Find and Replace");
        this.setResizable(false);
        this.findLabel.setText("Find:");
        this.replaceLabel.setText("Replace:");
        this.findText.setPreferredSize(new Dimension(200, 19));
        this.findText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.findTextActionPerformed(evt);
            }
        });
        this.replaceText.setPreferredSize(new Dimension(200, 19));
        this.directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        this.directionPanel.setLayout(new GridLayout(2, 0));
        this.directionButtonGroup.add(this.forwardsRadio);
        this.forwardsRadio.setSelected(true);
        this.forwardsRadio.setText("Forwards");
        this.directionPanel.add(this.forwardsRadio);
        this.directionButtonGroup.add(this.backwardsRadio);
        this.backwardsRadio.setText("Backwards");
        this.directionPanel.add(this.backwardsRadio);
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        this.optionsPanel.setLayout(new GridLayout(2, 0));
        this.wrapSearchBox.setSelected(true);
        this.wrapSearchBox.setText("Wrap Search");
        this.optionsPanel.add(this.wrapSearchBox);
        this.caseSensitiveBox.setText("Case Sensitive");
        this.optionsPanel.add(this.caseSensitiveBox);
        this.findButton.setText("Find");
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.findText(evt);
            }
        });
        this.replaceFindButton.setText("Replace and Find");
        this.replaceFindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.replaceAndFind(evt);
            }
        });
        this.jButton1.setText("Replace");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.replaceText(evt);
            }
        });
        this.replaceAllButton.setText("Replace All");
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.replaceAll(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplaceDialog.this.closeFindReplaceDialog(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsPanel, -1, 314, Short.MAX_VALUE).addComponent(this.directionPanel, -1, 314, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.findLabel, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findText, -1, 254, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.replaceLabel, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceText, -1, 254, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.findButton, GroupLayout.Alignment.LEADING, -1, 160, Short.MAX_VALUE).addComponent(this.jButton1, GroupLayout.Alignment.LEADING, -1, 160, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.replaceAllButton, -1, 148, Short.MAX_VALUE).addComponent(this.replaceFindButton, 0, 0, Short.MAX_VALUE)))).addGap(12, 12, 12)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.closeButton).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.findLabel, -2, 15, -2).addComponent(this.findText, -2, -1, -2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceLabel, -2, 15, -2).addComponent(this.replaceText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.findButton, -2, 25, -2).addComponent(this.replaceFindButton, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -2, 25, -2).addComponent(this.replaceAllButton, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton, -2, 25, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void findTextActionPerformed(ActionEvent evt) {
        this.findText(null);
    }

    private void closeFindReplaceDialog(ActionEvent evt) {
        this.setVisible(false);
    }

    private int findText(ActionEvent evt) {
        String searchText = this.findText.getText();
        if (this.textArea == null || searchText.length() == 0) {
            return -1;
        }
        String text = this.textArea.getText();
        if (!this.caseSensitiveBox.isSelected()) {
            searchText = searchText.toLowerCase();
            text = text.toLowerCase();
        }
        int startIndex = this.textArea.getCaretPosition();
        if (this.forwardsRadio.isSelected()) {
            int index;
            int end;
            int start = this.textArea.getSelectionStart();
            if (start != (end = this.textArea.getSelectionEnd())) {
                startIndex = end;
            }
            if ((index = text.indexOf(searchText, startIndex)) == -1) {
                if (this.wrapSearchBox.isSelected()) {
                    startIndex = 0;
                    index = text.indexOf(searchText);
                } else {
                    return -1;
                }
            }
            if (index >= startIndex) {
                this.textArea.select(index, index + searchText.length());
                return index;
            }
        } else if (this.backwardsRadio.isSelected()) {
            int index;
            int end;
            int start = this.textArea.getSelectionStart();
            if (start != (end = this.textArea.getSelectionEnd())) {
                startIndex = start;
            }
            if ((index = text.substring(0, startIndex).lastIndexOf(searchText)) == -1) {
                if (this.wrapSearchBox.isSelected()) {
                    startIndex = text.length();
                    index = text.lastIndexOf(searchText);
                } else {
                    return -1;
                }
            }
            if (index <= startIndex && index != -1) {
                this.textArea.select(index, index + searchText.length());
                return index;
            }
        }
        return -1;
    }

    private boolean replaceText(ActionEvent evt) {
        String searchText = this.findText.getText();
        if (this.textArea == null || searchText.length() == 0) {
            return false;
        }
        String selectedText = this.textArea.getSelectedText();
        if (selectedText == null) {
            return false;
        }
        int start = this.textArea.getSelectionStart();
        int end = this.textArea.getSelectionEnd();
        Document doc = this.textArea.getDocument();
        String replacementText = this.replaceText.getText();
        try {
            doc.remove(start, end - start);
            doc.insertString(start, replacementText, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.textArea.select(start, start + replacementText.length());
        return true;
    }

    private void replaceAll(ActionEvent evt) {
        int index;
        int startVal = this.findText(null);
        if (startVal != -1) {
            this.replaceText(null);
        }
        int start = 0;
        int charDiff = this.replaceText.getText().length() - this.findText.getText().length();
        while ((index = this.findText(null)) != -1 && index != start + startVal) {
            this.replaceText(null);
            if (index >= startVal) continue;
            start += charDiff;
        }
    }

    private void replaceAndFind(ActionEvent evt) {
        if (this.replaceText(null)) {
            this.findText(null);
        }
    }

    public void setTextArea(JTextComponent textArea) {
        this.textArea = textArea;
    }

    public void setInititalSearchText(String text) {
        this.findText.setText(text);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            JFrame frame = new JFrame();
            new FindReplaceDialog(frame).setVisible(true);
        });
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings(this);
    }
}

