/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class TableHilightDropListener
implements DropTargetListener {
    private Component oldGlassPane;
    private Point from;
    private Point to;
    JPanel glassPane = new JPanel(){

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.GREEN);
            if (TableHilightDropListener.this.from == null || TableHilightDropListener.this.to == null) {
                return;
            }
            int x1 = ((TableHilightDropListener)TableHilightDropListener.this).from.x;
            int x2 = ((TableHilightDropListener)TableHilightDropListener.this).to.x;
            int y1 = ((TableHilightDropListener)TableHilightDropListener.this).from.y;
            g.drawLine(x1 + 2, y1, x2 - 2, y1);
            g.drawLine(x1 + 2, y1 + 1, x2 - 2, y1 + 1);
            g.drawLine(x1, y1 - 2, x1, y1 + 3);
            g.drawLine(x1 + 1, y1 - 1, x1 + 1, y1 + 2);
            g.drawLine(x2, y1 - 2, x2, y1 + 3);
            g.drawLine(x2 - 1, y1 - 1, x2 - 1, y1 + 2);
        }
    };
    private int hotspot = 5;
    protected int listIndex = -1;
    protected Boolean before = null;

    private void updateLine(JTable table, Point pt) {
        int h = table.getRowHeight();
        int n = this.listIndex = pt != null ? pt.y / h : -1;
        if (this.listIndex > table.getRowCount()) {
            this.listIndex = table.getRowCount();
        }
        if (this.listIndex == -1) {
            this.to = null;
            this.from = null;
            this.before = null;
        } else {
            Rectangle bounds = new Rectangle(0, this.listIndex * h, table.getWidth(), h);
            if (pt.y <= bounds.y + this.hotspot) {
                this.from = bounds.getLocation();
                this.to = new Point(table.getWidth(), this.from.y);
                this.before = Boolean.TRUE;
            } else if (pt.y >= bounds.y + bounds.height - this.hotspot) {
                this.from = new Point(bounds.x, bounds.y + bounds.height);
                this.to = new Point(table.getWidth(), this.from.y);
                this.before = Boolean.FALSE;
            } else {
                this.to = null;
                this.from = null;
                this.before = null;
            }
            if (this.from != null && this.to != null) {
                this.from = SwingUtilities.convertPoint(table, this.from, this.glassPane);
                this.to = SwingUtilities.convertPoint(table, this.to, this.glassPane);
                table.clearSelection();
            }
        }
        this.glassPane.getRootPane().repaint();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        JTable table = (JTable)dtde.getDropTargetContext().getComponent();
        Point location = dtde.getLocation();
        JRootPane rootPane = table.getRootPane();
        this.oldGlassPane = rootPane.getGlassPane();
        rootPane.setGlassPane(this.glassPane);
        this.glassPane.setOpaque(false);
        this.glassPane.setVisible(true);
        this.updateLine(table, location);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        JTable table = (JTable)dtde.getDropTargetContext().getComponent();
        Point location = dtde.getLocation();
        this.updateLine(table, location);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private void resetGlassPane(DropTargetEvent dte) {
        JTable table = (JTable)dte.getDropTargetContext().getComponent();
        JRootPane rootPane = table.getRootPane();
        rootPane.setGlassPane(this.oldGlassPane);
        this.oldGlassPane.setVisible(false);
        rootPane.repaint();
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.resetGlassPane(dte);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.resetGlassPane(dtde);
    }
}

