/*
 * Decompiled with CFR 0.152.
 */
package blue.components.lines;

import blue.components.ColorCellEditor;
import blue.components.lines.ColorCellRenderer;
import blue.components.lines.Line;
import blue.components.lines.LineList;
import blue.components.lines.LineListTableModel;
import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;

public class LineListTable
extends JComponent {
    JTable table;
    LineListTableModel tableModel = this.getNewLineTableModel();
    private SelectionListener<Line> listener;
    private LineList lineList;

    public LineListTable() {
        this.setLayout(new BorderLayout());
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(Color.class, new ColorCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (this.listener != null && !e.getValueIsAdjusting()) {
                SelectionEvent event;
                int row = this.table.getSelectedRow();
                if (row == -1) {
                    event = new SelectionEvent(null, 2);
                } else {
                    Line line = (Line)this.lineList.get(row);
                    event = new SelectionEvent((Object)line, 0);
                }
                this.listener.selectionPerformed(event);
            }
        });
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.setDefaultEditor(Color.class, new ColorCellEditor());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        JButton addButton = new JButton("+");
        addButton.addActionListener(e -> this.addLine());
        JButton removeButton = new JButton("-");
        removeButton.addActionListener(e -> this.removeLine());
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)buttonPanel, "South");
    }

    protected LineListTableModel getNewLineTableModel() {
        return new LineListTableModel();
    }

    private void addLine() {
        int row = this.table.getSelectedRow();
        this.tableModel.addLine(row);
    }

    private void removeLine() {
        int row = this.table.getSelectedRow();
        this.tableModel.removeLine(row);
    }

    public void setLineList(LineList lineList) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.lineList = lineList;
        this.tableModel.setLineList(lineList);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.tableModel.addTableModelListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.tableModel.removeTableModelListener(listener);
    }

    public void addSelectionListener(SelectionListener<Line> listener) {
        this.listener = listener;
    }
}

