/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.BSBGroup;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.BSBObjectEntry;
import blue.orchestra.blueSynthBuilder.GridSettings;
import blue.orchestra.editor.blueSynthBuilder.EditModeOnly;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBEditSelection;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBGroupView;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBObjectEditorFactory;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBObjectViewHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.openide.util.Exceptions;

public class BSBEditPane
extends Pane
implements ListChangeListener<BSBGroup> {
    private static final Color GRID_COLOR = Color.rgb((int)38, (int)51, (int)76, (double)0.5).brighter();
    private BSBGraphicInterface bsbInterface;
    private BSBEditSelection selection;
    private ContextMenu popupMenu;
    private ContextMenu nonEditPopupMenu;
    private SetChangeListener<BSBObject> scl;
    private Rectangle marquee;
    int addX = 0;
    int addY = 0;
    double startMarqueeX = -1.0;
    double startMarqueeY = -1.0;
    Set<BSBObject> startSet = null;
    Set<BSBObject> selecting = new HashSet<BSBObject>();
    private Pane interfaceItemsPane;
    private Canvas gridCanvas;
    Pane mousePane = new Pane();
    private InvalidationListener gridListener;
    private BooleanProperty marqueeSelecting;
    final boolean allowEditing;
    ObservableList<BSBGroup> groupsList = FXCollections.observableArrayList();
    BSBGroup currentBSBGroup = null;
    ChangeListener<Boolean> editEnabledListener = (obs, old, newVal) -> {
        block4: {
            block3: {
                if (!newVal.booleanValue()) break block3;
                if (this.groupsList.size() <= 1) break block4;
                this.interfaceItemsPane.getChildren().clear();
                for (BSBObject bsbObj : this.currentBSBGroup.interfaceItemsProperty()) {
                    this.addBSBObject(bsbObj);
                }
                break block4;
            }
            if (this.groupsList.size() > 1) {
                this.interfaceItemsPane.getChildren().clear();
                for (BSBObject bsbObj : ((BSBGroup)this.groupsList.get(0)).interfaceItemsProperty()) {
                    this.addBSBObject(bsbObj);
                }
            }
        }
    };

    public BSBEditPane(BSBObjectEntry[] bsbObjectEntries) {
        this(bsbObjectEntries, true);
    }

    public BSBEditPane(BSBObjectEntry[] bsbObjectEntries, boolean allowEditing) {
        this.setFocusTraversable(true);
        this.allowEditing = allowEditing;
        this.gridCanvas = new Canvas();
        this.interfaceItemsPane = new Pane();
        this.gridListener = cl -> this.redrawGrid();
        this.gridCanvas.setManaged(false);
        this.gridCanvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.gridCanvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.widthProperty().addListener(this.gridListener);
        this.heightProperty().addListener(this.gridListener);
        this.getChildren().addAll((Object[])new Node[]{this.gridCanvas, this.interfaceItemsPane});
        this.selection = new BSBEditSelection((ObservableList<Node>)this.interfaceItemsPane.getChildren());
        this.setupPopupMenus(bsbObjectEntries);
        this.marquee = new Rectangle();
        this.marquee.setFill(null);
        this.marquee.setStroke((Paint)Color.WHITE);
        this.marqueeSelecting = new SimpleBooleanProperty(false);
        this.setOnMousePressed(me -> {
            if (!me.isConsumed() && this.bsbInterface != null) {
                if (this.bsbInterface.isEditEnabled() && allowEditing) {
                    if (me.isSecondaryButtonDown()) {
                        this.addX = (int)me.getX();
                        this.addY = (int)me.getY();
                        this.popupMenu.show((Node)this, me.getScreenX(), me.getScreenY());
                    } else if (me.isPrimaryButtonDown()) {
                        if (!me.isShiftDown()) {
                            this.selection.selection.clear();
                        }
                        this.startSet = new HashSet<BSBObject>((Collection<BSBObject>)this.selection.selection);
                        this.startMarqueeX = me.getX();
                        this.startMarqueeY = me.getY();
                        this.setMarqueeSelecting(true);
                        this.updateMarquee(this.startMarqueeX, this.startMarqueeY);
                        this.getChildren().add((Object)this.marquee);
                    }
                } else if (me.isSecondaryButtonDown()) {
                    this.nonEditPopupMenu.show((Node)this, me.getScreenX(), me.getScreenY());
                }
            }
        });
        this.setOnMouseDragged(me -> {
            if (this.startMarqueeX >= 0.0) {
                this.updateMarquee(me.getX(), me.getY());
            }
        });
        this.setOnMouseReleased(me -> {
            if (this.startMarqueeX >= 0.0) {
                this.startMarqueeX = -1.0;
                this.startMarqueeY = -1.0;
                this.getChildren().remove((Object)this.marquee);
            }
            this.setMarqueeSelecting(false);
            this.requestFocus();
        });
        this.scl = sce -> {
            if (sce.wasAdded()) {
                this.addBSBObject((BSBObject)sce.getElementAdded());
            } else {
                this.removeBSBObject((BSBObject)sce.getElementRemoved());
            }
        };
        this.installKeyEventHandler();
        this.groupsList.addListener((ListChangeListener)this);
    }

    private void setupPopupMenus(BSBObjectEntry[] bsbObjectEntries) {
        this.popupMenu = new ContextMenu();
        EventHandler al = e -> {
            MenuItem m = (MenuItem)e.getSource();
            Class clazz = (Class)m.getUserData();
            try {
                BSBObject bsbObj = (BSBObject)clazz.newInstance();
                bsbObj.setX(this.addX);
                bsbObj.setY(this.addY);
                this.currentBSBGroup.addBSBObject(bsbObj);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        for (BSBObjectEntry entry : bsbObjectEntries) {
            MenuItem m = new MenuItem("Add " + entry.label);
            m.setUserData((Object)entry.bsbObjectClass);
            m.setOnAction(al);
            this.popupMenu.getItems().add((Object)m);
        }
        MenuItem paste = new MenuItem("Paste");
        paste.setOnAction(ae -> this.paste(this.addX, this.addY));
        paste.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.selection.copyBufferProperty().size() == 0, (Observable[])new Observable[]{this.selection.copyBufferProperty()}));
        this.popupMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), paste});
        this.nonEditPopupMenu = new ContextMenu();
        MenuItem randomize = new MenuItem("Randomize");
        randomize.setOnAction(ae -> {
            if (this.bsbInterface != null) {
                this.bsbInterface.getRootGroup().randomize();
            }
        });
        this.nonEditPopupMenu.getItems().add((Object)randomize);
    }

    public BSBEditSelection getSelection() {
        return this.selection;
    }

    public ObservableList<BSBGroup> getGroupsList() {
        return this.groupsList;
    }

    private void setMarqueeSelecting(boolean val) {
        this.marqueeSelecting.set(val);
    }

    public boolean isMarqueeSelecting() {
        return this.marqueeSelecting.get();
    }

    public BooleanProperty marqueeSelectingProperty() {
        return this.marqueeSelecting;
    }

    public void editBSBGraphicInterface(BSBGraphicInterface bsbInterface) {
        GridSettings gridSettings;
        if (this.bsbInterface != null) {
            gridSettings = this.bsbInterface.getGridSettings();
            gridSettings.widthProperty().removeListener(this.gridListener);
            gridSettings.heightProperty().removeListener(this.gridListener);
            gridSettings.gridStyleProperty().removeListener(this.gridListener);
            this.bsbInterface.editEnabledProperty().removeListener(this.editEnabledListener);
        }
        this.gridCanvas.visibleProperty().unbind();
        this.bsbInterface = bsbInterface;
        this.selection.initialize(this.groupsList, bsbInterface.getGridSettings());
        if (bsbInterface != null) {
            gridSettings = bsbInterface.getGridSettings();
            gridSettings.widthProperty().addListener(this.gridListener);
            gridSettings.heightProperty().addListener(this.gridListener);
            gridSettings.gridStyleProperty().addListener(this.gridListener);
            if (this.allowEditing) {
                this.gridCanvas.visibleProperty().bind((ObservableValue)bsbInterface.editEnabledProperty());
                bsbInterface.editEnabledProperty().addListener(this.editEnabledListener);
            } else {
                this.gridCanvas.setVisible(false);
            }
            this.groupsList.setAll((Object[])new BSBGroup[]{bsbInterface.getRootGroup()});
        } else {
            this.groupsList.clear();
        }
    }

    protected void addBSBObject(BSBObject bsbObj) {
        try {
            Region objectView = BSBObjectEditorFactory.getView(bsbObj);
            BooleanProperty editEnabledProperty = this.allowEditing ? this.bsbInterface.editEnabledProperty() : null;
            BSBObjectViewHolder viewHolder = new BSBObjectViewHolder(editEnabledProperty, this.selection, this.groupsList, objectView);
            if (objectView instanceof EditModeOnly) {
                if (this.allowEditing) {
                    viewHolder.visibleProperty().bind((ObservableValue)this.bsbInterface.editEnabledProperty());
                } else {
                    viewHolder.setVisible(false);
                }
            }
            if (bsbObj instanceof BSBGroup) {
                BSBGroupView bsbGroupView = (BSBGroupView)objectView;
                bsbGroupView.initialize(editEnabledProperty, this.selection, this.groupsList);
            }
            this.interfaceItemsPane.getChildren().add((Object)viewHolder);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    protected void removeBSBObject(BSBObject bsbObj) {
        Node found = null;
        for (Node n : this.interfaceItemsPane.getChildren()) {
            if (n.getUserData() != bsbObj) continue;
            found = n;
            break;
        }
        if (found != null) {
            this.interfaceItemsPane.getChildren().remove(found);
            found.visibleProperty().unbind();
        }
    }

    protected void paste(int x, int y) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        GridSettings gridSettings = this.bsbInterface.getGridSettings();
        if (gridSettings.isSnapEnabled()) {
            x -= x % gridSettings.getWidth();
            y -= y % gridSettings.getHeight();
        }
        for (BSBObject bsbObj : this.selection.copyBufferProperty()) {
            minX = Math.min(minX, bsbObj.getX());
            minY = Math.min(minY, bsbObj.getY());
        }
        this.selection.selection.clear();
        for (BSBObject bsbObj : this.selection.copyBufferProperty()) {
            BSBObject copy = (BSBObject)bsbObj.deepCopy();
            copy.setX(x + copy.getX() - minX);
            copy.setY(y + copy.getY() - minY);
            this.currentBSBGroup.addBSBObject(copy);
            this.selection.selection.add((Object)copy);
        }
    }

    protected void updateMarquee(double newMouseX, double newMouseY) {
        double bottom;
        double top;
        double right;
        double left;
        if (newMouseX < this.startMarqueeX) {
            left = newMouseX;
            right = this.startMarqueeX;
        } else {
            left = this.startMarqueeX;
            right = newMouseX;
        }
        if (newMouseY < this.startMarqueeY) {
            top = newMouseY;
            bottom = this.startMarqueeY;
        } else {
            bottom = newMouseY;
            top = this.startMarqueeY;
        }
        top = Math.max(0.0, top);
        left = Math.max(0.0, left);
        double width = right - left;
        double height = bottom - top;
        this.marquee.setX(left);
        this.marquee.setY(top);
        this.marquee.setWidth(width);
        this.marquee.setHeight(height);
        this.selecting.clear();
        for (Node n : this.interfaceItemsPane.getChildren()) {
            BSBObject bsbObj;
            Object obj;
            Bounds b = n.getBoundsInParent();
            if (n == this.marquee || !this.marquee.intersects(b) || !((obj = n.getUserData()) instanceof BSBObject) || !this.currentBSBGroup.contains(bsbObj = (BSBObject)obj)) continue;
            this.selecting.add((BSBObject)obj);
        }
        this.selecting.addAll(this.startSet);
        this.selection.selection.addAll(this.selecting);
        this.selection.selection.retainAll(this.selecting);
    }

    private double snap(double v) {
        return (double)((int)v) + 0.5;
    }

    private void redrawGrid() {
        int totalWidth = (int)this.getWidth();
        int totalHeight = (int)this.getHeight();
        GraphicsContext gc = this.gridCanvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        if (this.bsbInterface == null) {
            return;
        }
        gc.setFill((Paint)GRID_COLOR);
        gc.setStroke((Paint)GRID_COLOR);
        GridSettings grid = this.bsbInterface.getGridSettings();
        int w = grid.getWidth();
        int h = grid.getHeight();
        if (w < 1 || h < 1) {
            return;
        }
        switch (grid.getGridStyle()) {
            case DOT: {
                for (int x = 0; x < totalWidth; x += w) {
                    for (int y = 0; y < totalHeight; y += h) {
                        gc.strokeRect(this.snap(x), this.snap(y), 1.0, 1.0);
                    }
                }
                break;
            }
            case LINE: {
                for (int x = 0; x < totalWidth; x += w) {
                    gc.strokeLine(this.snap(x), 0.0, this.snap(x), this.snap(totalHeight));
                }
                for (int y = 0; y < totalHeight; y += h) {
                    gc.strokeLine(0.0, this.snap(y), (double)totalWidth, this.snap(y));
                }
                break;
            }
        }
    }

    private Optional<Integer> sizeOfGridSnap() {
        if (this.bsbInterface == null || !this.bsbInterface.getGridSettings().isSnapEnabled()) {
            return Optional.empty();
        }
        return Optional.of(this.bsbInterface.getGridSettings().getHeight());
    }

    private void pasteShortcut() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (BSBObject bsbObj : this.selection.copyBufferProperty()) {
            minX = Math.min(minX, bsbObj.getX());
            minY = Math.min(minY, bsbObj.getY());
        }
        int x = minX;
        int y = minY;
        GridSettings gridSettings = this.bsbInterface.getGridSettings();
        if (gridSettings.isSnapEnabled()) {
            x += gridSettings.getWidth();
            y += gridSettings.getHeight();
        } else {
            x += 10;
            y += 10;
        }
        this.selection.selection.clear();
        for (BSBObject bsbObj : this.selection.copyBufferProperty()) {
            BSBObject copy = (BSBObject)bsbObj.deepCopy();
            copy.setX(x + copy.getX() - minX);
            copy.setY(y + copy.getY() - minY);
            this.currentBSBGroup.addBSBObject(copy);
            this.selection.selection.add((Object)copy);
        }
    }

    private void installKeyEventHandler() {
        EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getSource() != BSBEditPane.this || BSBEditPane.this.bsbInterface == null || !BSBEditPane.this.bsbInterface.isEditEnabled() || !BSBEditPane.this.allowEditing) {
                    return;
                }
                if (event.isControlDown() || event.isMetaDown()) {
                    switch (event.getCode()) {
                        case C: {
                            BSBEditPane.this.selection.copy();
                            event.consume();
                            break;
                        }
                        case V: {
                            BSBEditPane.this.pasteShortcut();
                            event.consume();
                            break;
                        }
                        case X: {
                            BSBEditPane.this.selection.cut();
                            event.consume();
                        }
                    }
                } else if (event.isShiftDown()) {
                    switch (event.getCode()) {
                        case UP: {
                            BSBEditPane.this.selection.nudgeVertical(-BSBEditPane.this.sizeOfGridSnap().orElse(10).intValue());
                            event.consume();
                            break;
                        }
                        case DOWN: {
                            BSBEditPane.this.selection.nudgeVertical(BSBEditPane.this.sizeOfGridSnap().orElse(10));
                            event.consume();
                            break;
                        }
                        case LEFT: {
                            BSBEditPane.this.selection.nudgeHorizontal(-BSBEditPane.this.sizeOfGridSnap().orElse(10).intValue());
                            event.consume();
                            break;
                        }
                        case RIGHT: {
                            BSBEditPane.this.selection.nudgeHorizontal(BSBEditPane.this.sizeOfGridSnap().orElse(10));
                            event.consume();
                        }
                    }
                } else {
                    switch (event.getCode()) {
                        case DELETE: 
                        case BACK_SPACE: {
                            BSBEditPane.this.selection.remove();
                            event.consume();
                            break;
                        }
                        case UP: {
                            BSBEditPane.this.selection.nudgeVertical(-BSBEditPane.this.sizeOfGridSnap().orElse(1).intValue());
                            event.consume();
                            break;
                        }
                        case DOWN: {
                            BSBEditPane.this.selection.nudgeVertical(BSBEditPane.this.sizeOfGridSnap().orElse(1));
                            event.consume();
                            break;
                        }
                        case LEFT: {
                            BSBEditPane.this.selection.nudgeHorizontal(-BSBEditPane.this.sizeOfGridSnap().orElse(1).intValue());
                            event.consume();
                            break;
                        }
                        case RIGHT: {
                            BSBEditPane.this.selection.nudgeHorizontal(BSBEditPane.this.sizeOfGridSnap().orElse(1));
                            event.consume();
                        }
                    }
                }
            }
        };
        this.setOnKeyPressed((EventHandler)handler);
    }

    public void onChanged(ListChangeListener.Change<? extends BSBGroup> c) {
        if (this.currentBSBGroup != null) {
            this.currentBSBGroup.interfaceItemsProperty().removeListener(this.scl);
        }
        this.interfaceItemsPane.getChildren().clear();
        if (this.groupsList.size() > 0) {
            this.currentBSBGroup = (BSBGroup)this.groupsList.get(this.groupsList.size() - 1);
            for (BSBObject bsbObj : this.currentBSBGroup.interfaceItemsProperty()) {
                this.addBSBObject(bsbObj);
            }
            this.currentBSBGroup.interfaceItemsProperty().addListener(this.scl);
        } else {
            this.currentBSBGroup = null;
        }
    }
}

