/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.jfx.BlueFX;
import blue.orchestra.blueSynthBuilder.BSBXYController;
import blue.orchestra.blueSynthBuilder.ClampedValue;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;

public class BSBXYControllerView
extends BorderPane
implements ResizeableView {
    private final BSBXYController bsbXYController;
    private final Pane pane = new Pane();
    Rectangle yLine = new Rectangle();
    Rectangle xLine = new Rectangle();
    Rectangle rect = new Rectangle(3.0, 3.0);
    Label label = new Label();

    public BSBXYControllerView(BSBXYController bsbXYController) {
        this.setUserData(bsbXYController);
        this.bsbXYController = bsbXYController;
        this.pane.setStyle("-fx-background-color: black");
        this.label.setFont(new Font(10.0));
        this.label.setTextFill((Paint)Color.WHITE);
        this.setCenter((Node)this.pane);
        this.yLine.setX(0.0);
        this.yLine.setHeight(1.0);
        this.yLine.setFill((Paint)Color.WHITE);
        this.xLine.setY(0.0);
        this.xLine.setWidth(1.0);
        this.xLine.setFill((Paint)Color.WHITE);
        this.rect.setFill((Paint)Color.color((double)0.0, (double)1.0, (double)0.0));
        this.pane.getChildren().addAll((Object[])new Node[]{this.xLine, this.yLine, this.rect});
        this.pane.setOnMousePressed(me -> {
            bsbXYController.xValueProperty().setNormalizedValue(me.getX() / this.pane.getWidth());
            bsbXYController.yValueProperty().setNormalizedValue(1.0 - me.getY() / this.pane.getHeight());
        });
        this.pane.setOnMouseDragged(me -> {
            if (me.getSource() == this.pane) {
                bsbXYController.xValueProperty().setNormalizedValue(me.getX() / this.pane.getWidth());
                bsbXYController.yValueProperty().setNormalizedValue(1.0 - me.getY() / this.pane.getHeight());
            }
        });
        ChangeListener labelListener = (obs, old, newVal) -> {
            Runnable r = () -> this.updateLabel();
            BlueFX.runOnFXThread((Runnable)r);
        };
        ChangeListener yListener = (obs, old, newVal) -> {
            Runnable r = () -> this.updateUIforY();
            BlueFX.runOnFXThread((Runnable)r);
        };
        ChangeListener xListener = (obs, old, newVal) -> {
            Runnable r = () -> this.updateUIforX();
            BlueFX.runOnFXThread((Runnable)r);
        };
        ChangeListener displayVisibleListener = (obs, old, newVal) -> {
            Runnable r = () -> this.updateLabelVisible((boolean)newVal);
            BlueFX.runOnFXThread((Runnable)r);
        };
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                this.pane.prefWidthProperty().unbind();
                this.pane.prefHeightProperty().unbind();
                this.label.prefWidthProperty().unbind();
                this.yLine.widthProperty().unbind();
                this.xLine.heightProperty().unbind();
                this.label.visibleProperty().unbind();
                this.unbindClampedValue(bsbXYController.xValueProperty(), (ChangeListener<? super Number>)labelListener);
                this.unbindClampedValue(bsbXYController.xValueProperty(), (ChangeListener<? super Number>)xListener);
                this.unbindClampedValue(bsbXYController.yValueProperty(), (ChangeListener<? super Number>)labelListener);
                this.unbindClampedValue(bsbXYController.yValueProperty(), (ChangeListener<? super Number>)yListener);
                bsbXYController.valueDisplayEnabledProperty().removeListener(displayVisibleListener);
                bsbXYController.heightProperty().removeListener(yListener);
                bsbXYController.heightProperty().removeListener(labelListener);
                bsbXYController.widthProperty().removeListener(xListener);
                bsbXYController.widthProperty().removeListener(labelListener);
            } else {
                this.pane.prefWidthProperty().bind((ObservableValue)bsbXYController.widthProperty());
                this.pane.prefHeightProperty().bind((ObservableValue)bsbXYController.heightProperty());
                this.label.prefWidthProperty().bind((ObservableValue)this.pane.prefWidthProperty());
                this.yLine.widthProperty().bind((ObservableValue)this.pane.widthProperty());
                this.xLine.heightProperty().bind((ObservableValue)this.pane.heightProperty());
                this.updateLabel();
                this.updateUIforX();
                this.updateUIforY();
                this.updateLabelVisible(bsbXYController.isValueDisplayEnabled());
                this.bindClampedValue(bsbXYController.xValueProperty(), (ChangeListener<? super Number>)labelListener);
                this.bindClampedValue(bsbXYController.xValueProperty(), (ChangeListener<? super Number>)xListener);
                this.bindClampedValue(bsbXYController.yValueProperty(), (ChangeListener<? super Number>)labelListener);
                this.bindClampedValue(bsbXYController.yValueProperty(), (ChangeListener<? super Number>)yListener);
                bsbXYController.heightProperty().addListener(yListener);
                bsbXYController.heightProperty().addListener(labelListener);
                bsbXYController.widthProperty().addListener(xListener);
                bsbXYController.widthProperty().addListener(labelListener);
                bsbXYController.valueDisplayEnabledProperty().addListener(displayVisibleListener);
            }
        });
    }

    private void bindClampedValue(ClampedValue v, ChangeListener<? super Number> listener) {
        v.valueProperty().addListener(listener);
        v.minProperty().addListener(listener);
        v.maxProperty().addListener(listener);
    }

    private void unbindClampedValue(ClampedValue v, ChangeListener<? super Number> listener) {
        v.valueProperty().removeListener(listener);
        v.minProperty().removeListener(listener);
        v.maxProperty().removeListener(listener);
    }

    private void updateUIforX() {
        double percent = this.bsbXYController.xValueProperty().getNormalizedValue();
        this.xLine.setX(this.pane.getPrefWidth() * percent);
        this.rect.setX((double)((int)(percent * this.pane.getPrefWidth())) - 1.0);
    }

    private void updateUIforY() {
        double percent = this.bsbXYController.yValueProperty().getNormalizedValue();
        this.yLine.setY(Math.floor(this.pane.getPrefHeight() * (1.0 - percent)));
        this.rect.setY((double)((int)((1.0 - percent) * this.pane.getPrefHeight())) - 1.0);
    }

    private void updateLabel() {
        this.label.setText(String.format("x: %.4g y: %.4g", this.bsbXYController.getXValue(), this.bsbXYController.getYValue()));
    }

    private void updateLabelVisible(boolean visible) {
        if (visible) {
            this.setBottom((Node)this.label);
        } else {
            this.setBottom(null);
        }
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return true;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return true;
    }

    @Override
    public int getWidgetMinimumWidth() {
        return 20;
    }

    @Override
    public int getWidgetMinimumHeight() {
        int base = this.bsbXYController.isValueDisplayEnabled() ? (int)this.label.getHeight() : 0;
        return base + 20;
    }

    @Override
    public int getWidgetWidth() {
        return this.bsbXYController.getWidth();
    }

    @Override
    public void setWidgetWidth(int width) {
        this.bsbXYController.setWidth(Math.max(20, width));
    }

    @Override
    public int getWidgetHeight() {
        int base = this.bsbXYController.isValueDisplayEnabled() ? (int)this.label.getHeight() : 0;
        return this.bsbXYController.getHeight() + base;
    }

    @Override
    public void setWidgetHeight(int height) {
        int base = this.bsbXYController.isValueDisplayEnabled() ? (int)this.label.getHeight() : 0;
        this.bsbXYController.setHeight(height - base);
    }

    @Override
    public void setWidgetX(int x) {
        this.bsbXYController.setX(x);
    }

    @Override
    public int getWidgetX() {
        return this.bsbXYController.getX();
    }

    @Override
    public void setWidgetY(int y) {
        this.bsbXYController.setY(y);
    }

    @Override
    public int getWidgetY() {
        return this.bsbXYController.getY();
    }
}

