/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx.editors;

import blue.components.lines.LineList;
import blue.orchestra.blueSynthBuilder.BSBDropdownItemList;
import blue.orchestra.editor.blueSynthBuilder.jfx.editors.BSBDropdownItemListEditor;
import blue.orchestra.editor.blueSynthBuilder.jfx.editors.LineListEditor;
import blue.orchestra.editor.blueSynthBuilder.jfx.editors.NumberPropertyEditor;
import blue.orchestra.editor.blueSynthBuilder.jfx.editors.StringPropertyEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javafx.scene.Node;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.DefaultPropertyEditorFactory;
import org.controlsfx.property.editor.Editors;
import org.controlsfx.property.editor.PropertyEditor;

public class BSBPropertyEditorFactory
extends DefaultPropertyEditorFactory {
    private static Class<?>[] numericTypes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigInteger.class, BigDecimal.class};

    public PropertyEditor<?> call(final PropertySheet.Item item) {
        Optional ed;
        Class type = item.getType();
        if (item.getPropertyEditorClass().isPresent() && (ed = Editors.createCustomEditor((PropertySheet.Item)item)).isPresent()) {
            return (PropertyEditor)ed.get();
        }
        if (type == String.class) {
            return new PropertyEditor<String>(){
                StringPropertyEditor tf;
                {
                    this.tf = new StringPropertyEditor(item);
                }

                public Node getEditor() {
                    return this.tf;
                }

                public String getValue() {
                    return this.tf.getText();
                }

                public void setValue(String value) {
                    this.tf.setText(value);
                }
            };
        }
        if (BSBPropertyEditorFactory.isNumber(type)) {
            return new PropertyEditor<Number>(){
                NumberPropertyEditor tf;
                {
                    this.tf = new NumberPropertyEditor(item);
                }

                public Node getEditor() {
                    return this.tf;
                }

                public Number getValue() {
                    return this.tf.getValueAsNumber();
                }

                public void setValue(Number value) {
                    this.tf.setText(value.toString());
                }
            };
        }
        if (type == BSBDropdownItemList.class) {
            return new PropertyEditor<BSBDropdownItemList>(){
                BSBDropdownItemListEditor tf = new BSBDropdownItemListEditor();

                public Node getEditor() {
                    return this.tf;
                }

                public BSBDropdownItemList getValue() {
                    return this.tf.getBSBDropdownItemList();
                }

                public void setValue(BSBDropdownItemList value) {
                    this.tf.setBSBDropdownItemList(value);
                }
            };
        }
        if (type == LineList.class) {
            return new PropertyEditor<LineList>(){
                LineListEditor tf = new LineListEditor();

                public Node getEditor() {
                    return this.tf;
                }

                public LineList getValue() {
                    return this.tf.getLineList();
                }

                public void setValue(LineList value) {
                    this.tf.setLineList(value);
                }
            };
        }
        return super.call(item);
    }

    private static boolean isNumber(Class<?> type) {
        if (type == null) {
            return false;
        }
        for (Class<?> cls : numericTypes) {
            if (type != cls) continue;
            return true;
        }
        return false;
    }
}

