/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx.editors;

import blue.components.lines.LineList;
import blue.orchestra.editor.blueSynthBuilder.LineListEditorDialog;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import org.openide.util.Exceptions;

public class LineListEditor
extends BorderPane {
    private LineList list;

    public LineListEditor() {
        Button b = new Button("...");
        this.setRight((Node)b);
        b.setOnAction(e -> {
            final LineList newList = new LineList(this.list);
            final CountDownLatch latch = new CountDownLatch(1);
            final boolean[] retVal = new boolean[1];
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        LineListEditorDialog dlg = new LineListEditorDialog();
                        dlg.setModal(true);
                        dlg.setLineList(newList);
                        retVal[0] = dlg.ask();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (retVal[0]) {
                this.list.clear();
                this.list.addAll((Collection)newList);
            }
        });
    }

    public void setLineList(LineList list) {
        this.list = list;
    }

    public LineList getLineList() {
        return this.list;
    }
}

