/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.score.ScoreObjectEvent;
import blue.score.ScoreObjectListener;
import blue.soundObject.JMask;
import blue.soundObject.editor.jmask.JMaskEditorLayout;
import blue.soundObject.editor.jmask.ParameterEditListener;
import blue.soundObject.editor.jmask.ParameterEditor;
import blue.soundObject.jmask.Field;
import blue.soundObject.jmask.Generator;
import blue.soundObject.jmask.Parameter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class EditorListPanel
extends JComponent
implements ParameterEditListener,
ListDataListener,
Scrollable,
ScoreObjectListener {
    JMask jMask = null;
    Field field = null;

    public EditorListPanel() {
        this.setLayout(new JMaskEditorLayout());
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                EditorListPanel.this.setSize(EditorListPanel.this.getPreferredSize());
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                EditorListPanel.this.setSize(EditorListPanel.this.getPreferredSize());
            }
        });
    }

    public void setJMask(JMask jMask) {
        this.cleanUp();
        this.field = jMask.getField();
        for (int i = 0; i < this.field.getSize(); ++i) {
            Parameter p = this.field.getParameter(i);
            ParameterEditor pEditor = new ParameterEditor();
            pEditor.setParameter(p, i + 1);
            this.add(pEditor);
            pEditor.setDuration(jMask.getSubjectiveDuration());
            pEditor.addParameterEditListener(this);
        }
        this.field.addListDataListener((ListDataListener)this);
        jMask.addScoreObjectListener((ScoreObjectListener)this);
        this.jMask = jMask;
        this.revalidate();
    }

    @Override
    public void parameterEdit(int editType, int parameterNum, Generator generator) {
        int index = parameterNum - 1;
        switch (editType) {
            case 0: {
                this.field.addParameterBefore(index, generator);
                break;
            }
            case 1: {
                this.field.addParameterAfter(index, generator);
                break;
            }
            case 2: {
                this.field.removeParameter(index);
                break;
            }
            case 3: {
                this.field.changeParameter(index, generator);
                break;
            }
            case 4: {
                this.field.pushUp(index);
                break;
            }
            case 5: {
                this.field.pushDown(index);
                break;
            }
            default: {
                System.err.println("Error with Parameter Edit in EditorListPanel");
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        int index = e.getIndex0();
        Parameter param = this.field.getParameter(index);
        ParameterEditor pEditor = new ParameterEditor();
        pEditor.setParameter(param, index + 1);
        pEditor.addParameterEditListener(this);
        this.add((Component)pEditor, index);
        pEditor.setDuration(this.jMask.getSubjectiveDuration());
        this.renumberParameterPanels();
        this.revalidate();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        int index = e.getIndex0();
        ParameterEditor pEditor = (ParameterEditor)this.getComponent(index);
        pEditor.removeParameterEditListener(this);
        this.remove(index);
        this.renumberParameterPanels();
        this.revalidate();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        for (int index = e.getIndex0(); index <= e.getIndex1(); ++index) {
            ParameterEditor pEditor = (ParameterEditor)this.getComponent(index);
            pEditor.removeParameterEditListener(this);
            this.remove(index);
            Parameter param = this.field.getParameter(index);
            pEditor = new ParameterEditor();
            pEditor.setParameter(param, index + 1);
            pEditor.addParameterEditListener(this);
            this.add((Component)pEditor, index);
            pEditor.setDuration(this.jMask.getSubjectiveDuration());
        }
        this.renumberParameterPanels();
        this.revalidate();
    }

    private void cleanUp() {
        if (this.field != null) {
            this.field.removeListDataListener((ListDataListener)this);
            for (int i = 0; i < this.getComponentCount(); ++i) {
                ParameterEditor pEditor = (ParameterEditor)this.getComponent(i);
                pEditor.removeParameterEditListener(this);
            }
        }
        if (this.jMask != null) {
            this.jMask.removeScoreObjectListener((ScoreObjectListener)this);
        }
        this.field = null;
        this.jMask = null;
        this.removeAll();
    }

    private void renumberParameterPanels() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ParameterEditor pEditor = (ParameterEditor)this.getComponent(i);
            pEditor.setParameterNumber(i + 1);
        }
    }

    public void scoreObjectChanged(ScoreObjectEvent event) {
        if (event.getPropertyChanged() == 2) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                ParameterEditor pEditor = (ParameterEditor)this.getComponent(i);
                pEditor.setDuration(this.jMask.getSubjectiveDuration());
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(0, 0);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

