/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.Mask;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MaskEditor
extends JPanel
implements DurationSettable {
    private Mask mask = null;
    private ButtonGroup highButtonGroup;
    private JSpinner highSpinner;
    private TableEditor highTableEditor;
    private JComboBox highTypeComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private ButtonGroup lowButtonGroup;
    private JSpinner lowSpinner;
    private TableEditor lowTableEditor;
    private JComboBox lowTypeComboBox;
    private JSpinner mapSpinner;

    public MaskEditor(Mask mask) {
        this.initComponents();
        this.highTableEditor.setTable(mask.getHighTable());
        this.lowTableEditor.setTable(mask.getLowTable());
        this.highSpinner.setModel(new SpinnerNumberModel(mask.getHigh(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        this.lowSpinner.setModel(new SpinnerNumberModel(mask.getLow(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        this.mapSpinner.setModel(new SpinnerNumberModel(mask.getMapValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.01));
        this.highTypeComboBox.setSelectedIndex(mask.isHighTableEnabled() ? 1 : 0);
        this.lowTypeComboBox.setSelectedIndex(mask.isLowTableEnabled() ? 1 : 0);
        this.mask = mask;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.highSpinner.setVisible(!this.mask.isHighTableEnabled());
        this.highTableEditor.setVisible(this.mask.isHighTableEnabled());
        this.lowSpinner.setVisible(!this.mask.isLowTableEnabled());
        this.lowTableEditor.setVisible(this.mask.isLowTableEnabled());
    }

    private void initComponents() {
        this.highButtonGroup = new ButtonGroup();
        this.lowButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.highSpinner = new JSpinner();
        this.highTableEditor = new TableEditor();
        this.lowSpinner = new JSpinner();
        this.lowTableEditor = new TableEditor();
        this.jLabel2 = new JLabel();
        this.mapSpinner = new JSpinner();
        this.highTypeComboBox = new JComboBox();
        this.lowTypeComboBox = new JComboBox();
        this.jLabel1.setText("Mask");
        this.highSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MaskEditor.this.highSpinnerStateChanged(evt);
            }
        });
        this.lowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MaskEditor.this.lowSpinnerStateChanged(evt);
            }
        });
        this.jLabel2.setText("Map Value");
        this.mapSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MaskEditor.this.mapSpinnerStateChanged(evt);
            }
        });
        this.highTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"High Value (Constant)", "High Value (Table)"}));
        this.highTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaskEditor.this.highTypeComboBoxActionPerformed(evt);
            }
        });
        this.lowTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Low Value (Constant)", "Low Value (Table)"}));
        this.lowTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaskEditor.this.lowTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lowTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lowSpinner, -2, 84, -2)).addGroup(layout.createSequentialGroup().addComponent(this.highTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highSpinner, -2, 84, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mapSpinner, -2, 84, -2)).addComponent(this.highTableEditor, -2, 578, Short.MAX_VALUE).addComponent(this.lowTableEditor, -2, 578, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.highTypeComboBox, this.lowTypeComboBox);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mapSpinner, -2, -1, -2).addComponent(this.jLabel2, -2, 13, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.highSpinner, -2, -1, -2).addComponent(this.highTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highTableEditor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lowTypeComboBox, -2, -1, -2).addComponent(this.lowSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lowTableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void highSpinnerStateChanged(ChangeEvent evt) {
        if (this.mask != null) {
            this.mask.setHigh(((Double)this.highSpinner.getValue()).doubleValue());
        }
    }

    private void lowSpinnerStateChanged(ChangeEvent evt) {
        if (this.mask != null) {
            this.mask.setLow(((Double)this.lowSpinner.getValue()).doubleValue());
        }
    }

    private void mapSpinnerStateChanged(ChangeEvent evt) {
        if (this.mask != null) {
            this.mask.setMapValue(((Double)this.mapSpinner.getValue()).doubleValue());
        }
    }

    private void highTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.mask != null) {
            this.mask.setHighTableEnabled(this.highTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void lowTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.mask != null) {
            this.mask.setLowTableEnabled(this.lowTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    @Override
    public void setDuration(double duration) {
        this.highTableEditor.setDuration(duration);
        this.lowTableEditor.setDuration(duration);
    }
}

