/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.BlueSystem;
import blue.soundObject.PianoRoll;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TimelinePropertiesPanel
extends JComponent {
    JCheckBox snapEnabledBox = new JCheckBox(BlueSystem.getString((String)"scoreGUI.snapEnabled"));
    JTextField snapValue = new JTextField();
    JTextField timeUnit = new JTextField();
    JRadioButton timeDisplayTime = new JRadioButton(BlueSystem.getString((String)"scoreGUI.timeline.time"));
    JRadioButton timeDisplayNumber = new JRadioButton(BlueSystem.getString((String)"scoreGUI.timeline.number"));
    boolean isUpdating = false;
    private PianoRoll pianoRoll;

    public TimelinePropertiesPanel() {
        this.snapEnabledBox.addActionListener(e -> {
            if (this.pianoRoll != null) {
                this.pianoRoll.setSnapEnabled(this.snapEnabledBox.isSelected());
            }
        });
        this.snapValue.addActionListener(e -> {
            if (this.pianoRoll == null || this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            try {
                double val = Double.parseDouble(this.snapValue.getText());
                if (val < 0.0) {
                    return;
                }
                this.pianoRoll.setSnapValue(val);
            }
            catch (NumberFormatException nfe) {
                this.snapValue.setText(Double.toString(this.pianoRoll.getSnapValue()));
            }
            this.isUpdating = false;
        });
        ActionListener timeActionListener = e -> {
            if (!this.isUpdating) {
                if (e.getSource() == this.timeDisplayTime) {
                    this.pianoRoll.setTimeDisplay(0);
                } else if (e.getSource() == this.timeDisplayNumber) {
                    this.pianoRoll.setTimeDisplay(1);
                }
            }
        };
        this.timeDisplayTime.addActionListener(timeActionListener);
        this.timeDisplayNumber.addActionListener(timeActionListener);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.timeDisplayTime);
        bg.add(this.timeDisplayNumber);
        this.timeUnit.addActionListener(e -> {
            try {
                int val = Integer.parseInt(this.timeUnit.getText());
                if (val < 1) {
                    this.timeUnit.setText(Integer.toString(this.pianoRoll.getTimeUnit()));
                    return;
                }
                this.pianoRoll.setTimeUnit(val);
            }
            catch (NumberFormatException nfe) {
                this.timeUnit.setText(Integer.toString(this.pianoRoll.getTimeUnit()));
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        JPanel snapPanel = new JPanel();
        snapPanel.setBorder(BorderFactory.createTitledBorder(BlueSystem.getString((String)"scoreGUI.snap")));
        snapPanel.setLayout(new GridLayout(2, 1));
        snapPanel.setMaximumSize(new Dimension(150, 150));
        snapPanel.add(this.snapEnabledBox);
        snapPanel.add(this.snapValue);
        JPanel timeDisplayPanel = new JPanel();
        timeDisplayPanel.setBorder(BorderFactory.createTitledBorder(BlueSystem.getString((String)"scoreGUI.timeline.timeDisplay")));
        timeDisplayPanel.setLayout(new GridLayout(3, 1));
        timeDisplayPanel.setMaximumSize(new Dimension(150, 200));
        timeDisplayPanel.add(this.timeDisplayTime);
        timeDisplayPanel.add(this.timeDisplayNumber);
        timeDisplayPanel.add(this.timeUnit);
        this.add(snapPanel);
        this.add(timeDisplayPanel);
        this.add(Box.createVerticalGlue());
    }

    public void setPianoRoll(PianoRoll pianoRoll) {
        this.isUpdating = true;
        this.pianoRoll = pianoRoll;
        this.snapEnabledBox.setSelected(pianoRoll.isSnapEnabled());
        this.snapValue.setText(Double.toString(pianoRoll.getSnapValue()));
        this.timeUnit.setText(Integer.toString(pianoRoll.getTimeUnit()));
        if (pianoRoll.getTimeDisplay() == 0) {
            this.timeDisplayTime.setSelected(true);
        } else {
            this.timeDisplayNumber.setSelected(true);
        }
        this.isUpdating = false;
    }
}

