/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.tracker;

import blue.BlueSystem;
import blue.soundObject.TrackerObject;
import blue.soundObject.editor.tracker.TrackEditor;
import blue.soundObject.editor.tracker.TracksHeader;
import blue.soundObject.tracker.Column;
import blue.soundObject.tracker.Track;
import blue.soundObject.tracker.TrackList;
import blue.soundObject.tracker.TrackerNote;
import blue.ui.components.IconFactory;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import skt.swing.SwingUtil;

public class TracksEditor
extends JPanel {
    TracksHeader header = new TracksHeader();
    JTable table;
    private final TrackerNamePanel namePanel = new TrackerNamePanel();
    private TrackList trackList;
    private final TrackEditor trackEditor = new TrackEditor();
    private final TableModelListener trackListListener;
    private Track selectedTrack = null;
    private final JScrollPane trackEditorScrollPane;
    private final List<TrackerNote> noteCopyBuffer = new ArrayList<TrackerNote>();
    private Action[] keyboardNoteActions = null;
    int keyboardOctave = 0;

    public TracksEditor() {
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane();
        this.add((Component)jsp, "Center");
        this.table = new JTable();
        this.header.setPreferredSize(new Dimension(25, 2000));
        jsp.setRowHeaderView(this.header);
        this.setupTable();
        jsp.setViewportView(this.table);
        final JViewport namePort = new JViewport();
        namePort.setView(this.namePanel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setMinimumSize(new Dimension(20, 20));
        topPanel.setPreferredSize(new Dimension(20, 20));
        topPanel.add(namePort);
        jsp.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                int x = e.getComponent().getX();
                namePort.setLocation(x, 0);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                int w = e.getComponent().getWidth();
                namePort.setSize(w, 20);
            }
        });
        jsp.getViewport().addChangeListener(e -> namePort.setViewPosition(new Point(jsp.getViewport().getViewPosition().x, 0)));
        this.add((Component)topPanel, "North");
        this.namePanel.addChangeListener(e -> {
            int index = this.namePanel.getSelectedIndex();
            if (index > -1) {
                Track track;
                this.selectedTrack = track = this.trackList.getTrack(index);
                this.trackEditor.setTrack(track);
            } else {
                this.trackEditor.setTrack(null);
                this.selectedTrack = null;
            }
        });
        this.trackEditorScrollPane = new JScrollPane(this.trackEditor);
        this.trackEditorScrollPane.setHorizontalScrollBarPolicy(31);
        this.trackEditorScrollPane.setPreferredSize(new Dimension(360, 30));
        this.trackEditorScrollPane.setVisible(false);
        this.add((Component)this.trackEditorScrollPane, "East");
        JToggleButton snapButton = new JToggleButton();
        snapButton.setIcon(IconFactory.getLeftArrowIcon());
        snapButton.setSelectedIcon(IconFactory.getRightArrowIcon());
        snapButton.setFocusable(false);
        jsp.setCorner("UPPER_RIGHT_CORNER", snapButton);
        jsp.setVerticalScrollBarPolicy(22);
        snapButton.addActionListener(e -> {
            this.trackEditorScrollPane.setVisible(!this.trackEditorScrollPane.isVisible());
            this.revalidate();
        });
        this.trackListListener = e -> {
            if (this.trackList == null) {
                return;
            }
            int selectedIndex = this.namePanel.getSelectedIndex();
            this.namePanel.updateLabels();
            if (this.trackList.contains(this.selectedTrack)) {
                this.namePanel.setSelected(selectedIndex, false);
            } else {
                this.trackEditor.setTrack(null);
            }
            this.setColumnWidths();
        };
        final PasteAction pAction = new PasteAction();
        final JPopupMenu popup = new JPopupMenu();
        popup.add(new CutAction());
        popup.add(new CopyAction());
        popup.add(pAction);
        popup.addSeparator();
        popup.add(new DeleteAction());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                pAction.setEnabled(TracksEditor.this.noteCopyBuffer.size() > 0);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(TracksEditor.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    private void setupTable() {
        this.table.setShowGrid(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultRenderer(String.class, new TrackerCellRenderer());
        this.table.setDefaultEditor(String.class, new TrackColumnEditor());
        this.table.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TracksEditor.this.namePanel.updateSize();
            }
        });
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                if (TracksEditor.this.trackList != null) {
                    TracksEditor.this.namePanel.updateLabelSizes();
                }
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(e -> {
            int h = this.table.getRowHeight();
            int y1 = this.table.getSelectedRow() * h;
            int selectionH = this.table.getSelectedRowCount() * h;
            this.table.repaint(0, y1, this.table.getWidth(), selectionH);
        });
        SwingUtil.installActions((JComponent)this.table, (Action[])new Action[]{new IncrementAction(), new DecrementAction(), new TieAction(), new SpaceBarAction(), new NoteOffAction(), new CutAction(), new CopyAction(), new PasteAction(), new InsertAction(), new DeleteAction(), new BackSpaceAction()});
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        TracksEditor tracksEditor = new TracksEditor();
        TrackList testData = new TrackList();
        testData.addTrack(new Track());
        testData.addTrack(new Track());
        testData.addTrack(new Track());
        tracksEditor.setTrackList(testData);
        GUI.showComponentAsStandalone((Component)tracksEditor, (String)"Tracks Editor", (boolean)true);
    }

    public void setTrackerObject(TrackerObject tracker) {
        this.setTrackList(tracker.getTracks());
        this.header.setTracker(tracker);
    }

    public void setKeyboardOctave(int octave) {
        this.keyboardOctave = octave;
    }

    public void useKeyboardNoteShortcuts(boolean val) {
        if (this.keyboardNoteActions == null) {
            this.keyboardNoteActions = new Action[]{new KeyboardNoteAction(90, 0), new KeyboardNoteAction(83, 1), new KeyboardNoteAction(88, 2), new KeyboardNoteAction(68, 3), new KeyboardNoteAction(67, 4), new KeyboardNoteAction(86, 5), new KeyboardNoteAction(71, 6), new KeyboardNoteAction(66, 7), new KeyboardNoteAction(72, 8), new KeyboardNoteAction(78, 9), new KeyboardNoteAction(74, 10), new KeyboardNoteAction(77, 11), new KeyboardNoteAction(81, 12), new KeyboardNoteAction(50, 13), new KeyboardNoteAction(87, 14), new KeyboardNoteAction(51, 15), new KeyboardNoteAction(69, 16), new KeyboardNoteAction(82, 17), new KeyboardNoteAction(53, 18), new KeyboardNoteAction(84, 19), new KeyboardNoteAction(54, 20), new KeyboardNoteAction(89, 21), new KeyboardNoteAction(55, 22), new KeyboardNoteAction(85, 23), new KeyboardNoteAction(73, 24), new KeyboardNoteAction(57, 25), new KeyboardNoteAction(79, 26), new KeyboardNoteAction(48, 27), new KeyboardNoteAction(80, 28)};
        }
        if (val) {
            SwingUtil.installActions((JComponent)this.table, (Action[])this.keyboardNoteActions);
        } else {
            ActionMap actionMap = this.table.getActionMap();
            InputMap inputMap = this.table.getInputMap(0);
            for (int i = 0; i < this.keyboardNoteActions.length; ++i) {
                String name = (String)this.keyboardNoteActions[i].getValue("Name");
                actionMap.remove(name);
                inputMap.remove((KeyStroke)this.keyboardNoteActions[i].getValue("AcceleratorKey"));
            }
        }
    }

    private void setTrackList(TrackList list) {
        if (this.trackList != null) {
            this.trackList.removeTableModelListener(this.trackListListener);
            this.trackList = null;
        }
        this.selectedTrack = null;
        this.trackEditor.setTrack(null);
        this.setColumnWidths();
        this.namePanel.updateLabels();
        this.trackList = list;
        this.table.setModel((TableModel)list);
        this.setColumnWidths();
        if (this.trackList != null) {
            this.trackList.addTableModelListener(this.trackListListener);
        }
    }

    private void setColumnWidths() {
        TableColumnModel cModel = this.table.getColumnModel();
        if (this.trackList == null) {
            return;
        }
        for (int i = 0; i < cModel.getColumnCount(); ++i) {
            Column c = this.trackList.getTrackColumn(i);
            int size = c == null ? 20 : 50;
            cModel.getColumn(i).setMaxWidth(size);
            cModel.getColumn(i).setMinWidth(size);
        }
    }

    class KeyboardNoteAction
    extends AbstractAction {
        private final int value;

        public KeyboardNoteAction(int key, int value) {
            super("keyboard-action-" + key);
            this.putValue("ShortDescription", "keyboard-action-" + key);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key, 0));
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TracksEditor.this.table.getSelectedRowCount() > 1) {
                return;
            }
            int selectedCol = TracksEditor.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (selectedCol < 0) {
                return;
            }
            Column c = TracksEditor.this.trackList.getTrackColumn(selectedCol);
            int row = TracksEditor.this.table.getSelectedRow();
            if (c == null) {
                return;
            }
            String value = null;
            switch (c.getType()) {
                case 0: {
                    int val = (8 + TracksEditor.this.keyboardOctave) * 12 + this.value;
                    int oct = val / 12;
                    int pch = val % 12;
                    String pchVal = Integer.toString(pch);
                    if (pch < 10) {
                        pchVal = "0" + pchVal;
                    }
                    value = oct + "." + pchVal;
                    break;
                }
                case 1: {
                    int val = (8 + TracksEditor.this.keyboardOctave) * 12 + this.value;
                    int oct = val / 12;
                    int pch = val % 12;
                    value = oct + "." + pch;
                    break;
                }
                case 2: {
                    value = Integer.toString(60 + TracksEditor.this.keyboardOctave * 12 + this.value);
                }
            }
            if (value == null) {
                return;
            }
            if (row < TracksEditor.this.table.getRowCount() - 2) {
                TracksEditor.this.table.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
            TracksEditor.this.trackList.setValueAt((Object)value, row, selectedCol);
            TracksEditor.this.trackList.fireRowChanged(row);
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
            this.putValue("ShortDescription", "Delete");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedCol = TracksEditor.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (selectedCol < 0) {
                return;
            }
            Track selectedTrack = TracksEditor.this.trackList.getTrackForColumn(selectedCol);
            if (selectedTrack == null) {
                return;
            }
            int start = TracksEditor.this.table.getSelectedRow();
            for (int i = 0; i < TracksEditor.this.table.getSelectedRowCount(); ++i) {
                TrackerNote note = selectedTrack.getTrackerNote(start + i);
                note.clear();
            }
            if (start < TracksEditor.this.table.getRowCount() - 2) {
                TracksEditor.this.table.getSelectionModel().setSelectionInterval(start + 1, start + 1);
            }
            TracksEditor.this.table.repaint();
        }
    }

    class BackSpaceAction
    extends AbstractAction {
        public BackSpaceAction() {
            super("BackSpace");
            this.putValue("ShortDescription", "BackSpace");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 64));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedCol = TracksEditor.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (selectedCol < 0) {
                return;
            }
            Track selectedTrack = TracksEditor.this.trackList.getTrackForColumn(selectedCol);
            if (selectedTrack == null) {
                return;
            }
            int start = TracksEditor.this.table.getSelectedRow();
            for (int i = 0; i < TracksEditor.this.table.getSelectedRowCount(); ++i) {
                selectedTrack.removeNote(start);
            }
            TracksEditor.this.table.repaint();
        }
    }

    class InsertAction
    extends AbstractAction {
        public InsertAction() {
            super("Insert");
            this.putValue("ShortDescription", "Insert");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(155, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedCol = TracksEditor.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (selectedCol < 0) {
                return;
            }
            Track selectedTrack = TracksEditor.this.trackList.getTrackForColumn(selectedCol);
            if (selectedTrack == null) {
                return;
            }
            int start = TracksEditor.this.table.getSelectedRow();
            if (start < TracksEditor.this.table.getRowCount() - 1) {
                selectedTrack.insertNote(start);
            }
            TracksEditor.this.table.repaint();
        }
    }

    class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
            this.putValue("ShortDescription", "Paste");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, BlueSystem.getMenuShortcutKey()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedCol = TracksEditor.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int selectedRow = TracksEditor.this.table.getSelectionModel().getLeadSelectionIndex();
            Track selectedTrack = TracksEditor.this.trackList.getTrackForColumn(selectedCol);
            if (selectedTrack == null || TracksEditor.this.noteCopyBuffer.size() == 0) {
                return;
            }
            if (selectedRow + TracksEditor.this.noteCopyBuffer.size() > selectedTrack.getNumSteps()) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot(TracksEditor.this), "Not enough steps to paste", "Error", 0);
                return;
            }
            TrackerNote firstNote = (TrackerNote)TracksEditor.this.noteCopyBuffer.get(0);
            if (selectedTrack.getNumColumns() != firstNote.getNumFields()) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot(TracksEditor.this), "Column does not have the same number of fields as copy buffer notes.", "Error", 0);
                return;
            }
            for (int i = 0; i < TracksEditor.this.noteCopyBuffer.size(); ++i) {
                TrackerNote bufferNote = (TrackerNote)TracksEditor.this.noteCopyBuffer.get(i);
                TrackerNote temp = selectedTrack.getTrackerNote(i + selectedRow);
                temp.copyValues(bufferNote);
            }
            TracksEditor.this.table.repaint();
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
            this.putValue("ShortDescription", "Copy");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, BlueSystem.getMenuShortcutKey()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedCol = TracksEditor.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (selectedCol < 0) {
                return;
            }
            Track selectedTrack = TracksEditor.this.trackList.getTrackForColumn(selectedCol);
            if (selectedTrack == null) {
                return;
            }
            TracksEditor.this.noteCopyBuffer.clear();
            int start = TracksEditor.this.table.getSelectedRow();
            for (int i = 0; i < TracksEditor.this.table.getSelectedRowCount(); ++i) {
                TrackerNote note = selectedTrack.getTrackerNote(start + i);
                TracksEditor.this.noteCopyBuffer.add(new TrackerNote(note));
            }
        }
    }

    class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
            this.putValue("ShortDescription", "Cut");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, BlueSystem.getMenuShortcutKey()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedCol = TracksEditor.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (selectedCol < 0) {
                return;
            }
            Track selectedTrack = TracksEditor.this.trackList.getTrackForColumn(selectedCol);
            if (selectedTrack == null) {
                return;
            }
            TracksEditor.this.noteCopyBuffer.clear();
            int start = TracksEditor.this.table.getSelectedRow();
            for (int i = 0; i < TracksEditor.this.table.getSelectedRowCount(); ++i) {
                TrackerNote note = selectedTrack.getTrackerNote(start + i);
                TracksEditor.this.noteCopyBuffer.add(new TrackerNote(note));
                note.clear();
            }
            TracksEditor.this.table.repaint();
        }
    }

    class NoteOffAction
    extends AbstractAction {
        public NoteOffAction() {
            super("note-off-action");
            this.putValue("ShortDescription", "Note-Off Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(32, 192));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int col = TracksEditor.this.table.getSelectedColumn();
            int row = TracksEditor.this.table.getSelectedRow();
            Track track = TracksEditor.this.trackList.getTrackForColumn(col);
            TrackerNote currentNote = track.getTrackerNote(row);
            boolean isOff = currentNote.isOff();
            currentNote.clear();
            currentNote.setOff(!isOff);
            TracksEditor.this.trackList.fireRowChanged(row);
        }
    }

    class SpaceBarAction
    extends AbstractAction {
        public SpaceBarAction() {
            super("spacebar-action");
            this.putValue("ShortDescription", "Spacebar Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(32, 128));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int col = TracksEditor.this.table.getSelectedColumn();
            int row = TracksEditor.this.table.getSelectedRow();
            Track track = TracksEditor.this.trackList.getTrackForColumn(col);
            TrackerNote currentNote = track.getTrackerNote(row);
            if (currentNote.isOff() || currentNote.isActive()) {
                currentNote.clear();
                TracksEditor.this.trackList.fireRowChanged(row);
                return;
            }
            TrackerNote previousNote = null;
            for (int i = row - 1; i >= 0; --i) {
                TrackerNote temp = track.getTrackerNote(i);
                if (!temp.isActive()) continue;
                previousNote = temp;
                break;
            }
            if (previousNote != null) {
                currentNote.copyValues(previousNote);
                TracksEditor.this.trackList.fireRowChanged(row);
            }
        }
    }

    class TieAction
    extends AbstractAction {
        public TieAction() {
            super("set-tied");
            this.putValue("ShortDescription", "Toggle Tied-Note");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int col = TracksEditor.this.table.getSelectedColumn();
            int row = TracksEditor.this.table.getSelectedRow();
            Track track = TracksEditor.this.trackList.getTrackForColumn(col);
            TrackerNote currentNote = track.getTrackerNote(row);
            if (currentNote.isActive() && !currentNote.isOff()) {
                currentNote.setTied(!currentNote.isTied());
                TracksEditor.this.trackList.fireRowChanged(row);
            }
        }
    }

    class DecrementAction
    extends AbstractAction {
        public DecrementAction() {
            super("decrement-column-value");
            this.putValue("ShortDescription", "Decrement Value");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, BlueSystem.getMenuShortcutKey()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int col = TracksEditor.this.table.getSelectedColumn();
            int row = TracksEditor.this.table.getSelectedRow();
            String val = (String)TracksEditor.this.table.getValueAt(row, col);
            if (val == null || val.equals("") || val.equals("-") || val.equals("OFF")) {
                return;
            }
            Column c = TracksEditor.this.trackList.getTrackColumn(col);
            String newVal = c.getDecrementValue(val);
            TracksEditor.this.table.setValueAt(newVal, row, col);
            TracksEditor.this.trackList.fireRowChanged(row);
        }
    }

    class IncrementAction
    extends AbstractAction {
        public IncrementAction() {
            super("increment-column-value");
            this.putValue("ShortDescription", "Increment Value");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, BlueSystem.getMenuShortcutKey()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int col = TracksEditor.this.table.getSelectedColumn();
            int row = TracksEditor.this.table.getSelectedRow();
            String val = (String)TracksEditor.this.table.getValueAt(row, col);
            if (val == null || val.equals("") || val.equals("-") || val.equals("OFF")) {
                return;
            }
            Column c = TracksEditor.this.trackList.getTrackColumn(col);
            String newVal = c.getIncrementValue(val);
            TracksEditor.this.table.setValueAt(newVal, row, col);
            TracksEditor.this.trackList.fireRowChanged(row);
        }
    }

    class TrackColumnEditor
    extends DefaultCellEditor {
        private int row;
        private int column;
        JTextField textField;
        Border normalBorder;
        Border errorBorder;
        String originalValue;

        public TrackColumnEditor() {
            super(new JTextField());
            this.row = -1;
            this.column = -1;
            this.errorBorder = BorderFactory.createLineBorder(Color.RED);
            this.originalValue = null;
            this.textField = (JTextField)this.editorComponent;
            this.normalBorder = this.textField.getBorder();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.column = column;
            this.textField.setBorder(this.normalBorder);
            this.originalValue = (String)table.getValueAt(row, column);
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean stopCellEditing() {
            if (this.row < 0 || this.column < 0 || TracksEditor.this.trackList == null) {
                return super.stopCellEditing();
            }
            Column c = TracksEditor.this.trackList.getTrackColumn(this.column);
            if ("off".equals(this.originalValue.toLowerCase())) {
                return super.stopCellEditing();
            }
            if (!c.isValid(this.textField.getText())) {
                this.textField.setBorder(this.errorBorder);
                return false;
            }
            return super.stopCellEditing();
        }
    }

    class TrackerNamePanel
    extends JComponent {
        List<ChangeListener> listeners = null;
        ChangeEvent ce = null;
        JPopupMenu popup = new JPopupMenu();
        PropertyChangeListener nameListener;

        public TrackerNamePanel() {
            this.setLayout(null);
            this.setMinimumSize(new Dimension(20, 20));
            this.setPreferredSize(new Dimension(20, 20));
            AbstractAction duplicateTrackAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TrackerNamePanel.this.getSelectedIndex() >= 0) {
                        TrackerNamePanel.this.duplicateTrack();
                    }
                }
            };
            duplicateTrackAction.putValue("Name", "Duplicate");
            AbstractAction clearTrackAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TrackerNamePanel.this.getSelectedIndex() >= 0) {
                        TrackerNamePanel.this.clearTrack();
                    }
                }
            };
            clearTrackAction.putValue("Name", "Clear");
            AbstractAction removeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TrackerNamePanel.this.getSelectedIndex() >= 0) {
                        TrackerNamePanel.this.removeTrack();
                    }
                }
            };
            removeAction.putValue("Name", BlueSystem.getString((String)"common.remove"));
            this.popup.add(duplicateTrackAction);
            this.popup.add(clearTrackAction);
            this.popup.add(removeAction);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Component c = TrackerNamePanel.this.getComponentAt(e.getX(), e.getY());
                    if (e.isPopupTrigger()) {
                        if (c != null && c.getBackground() == Color.GREEN) {
                            TrackerNamePanel.this.popup.show((Component)e.getSource(), e.getX(), e.getY());
                        }
                    } else {
                        TrackerNamePanel.this.setSelected(c, true);
                    }
                }
            });
            this.nameListener = evt -> {
                if (!(evt.getSource() instanceof Track) || !evt.getPropertyName().equals("name")) {
                    return;
                }
                Track t = (Track)evt.getSource();
                this.updateLabel(t);
            };
        }

        private void removeTrack() {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int index = this.getSelectedIndex();
            if (index >= 0 && index < TracksEditor.this.trackList.size()) {
                TracksEditor.this.trackList.removeTrack(index);
            }
        }

        private void duplicateTrack() {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int index = this.getSelectedIndex();
            if (index >= 0 && index < TracksEditor.this.trackList.size()) {
                TracksEditor.this.trackList.duplicateTrack(index);
            }
        }

        private void clearTrack() {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int index = this.getSelectedIndex();
            if (index >= 0 && index < TracksEditor.this.trackList.size()) {
                TracksEditor.this.trackList.clearTrack(index);
            }
        }

        private void updateLabel(Track t) {
            if (TracksEditor.this.trackList == null) {
                return;
            }
            int index = TracksEditor.this.trackList.getIndexOfTrack(t);
            if (index < 0 || index > this.getComponentCount() - 1) {
                return;
            }
            JLabel label = (JLabel)this.getComponent(index);
            label.setText(t.getName());
        }

        public int getSelectedIndex() {
            Component[] components = this.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i].getBackground() != Color.GREEN) continue;
                return i;
            }
            return -1;
        }

        public void setSelected(final int index, final boolean fireEvent) {
            SwingUtilities.invokeLater(new Runnable(){
                final int count;
                {
                    this.count = TrackerNamePanel.this.getComponentCount();
                }

                @Override
                public void run() {
                    if (index < this.count) {
                        TrackerNamePanel.this.setSelected(TrackerNamePanel.this.getComponent(index), fireEvent);
                    }
                }
            });
        }

        public void setSelected(Component c, boolean fireEvent) {
            if (c != null) {
                Component[] components = this.getComponents();
                SwingUtilities.invokeLater(() -> {
                    for (int i = 0; i < components.length; ++i) {
                        if (components[i] == c) {
                            components[i].setBackground(Color.GREEN);
                            continue;
                        }
                        components[i].setBackground(null);
                    }
                    if (fireEvent) {
                        this.fireChangeEvent();
                    }
                });
            }
        }

        public void updateSize() {
            this.setSize(TracksEditor.this.table.getWidth(), 20);
        }

        public void updateLabels() {
            if (TracksEditor.this.trackList != null) {
                for (int i = 0; i < TracksEditor.this.trackList.size(); ++i) {
                    Track track = TracksEditor.this.trackList.getTrack(i);
                    track.removePropertyChangeListener(this.nameListener);
                }
            }
            SwingUtilities.invokeLater(() -> {
                this.removeAll();
                if (TracksEditor.this.trackList == null) {
                    return;
                }
                TableColumnModel columnModel = TracksEditor.this.table.getColumnModel();
                int count = columnModel.getColumnCount();
                if (count == 0) {
                    return;
                }
                int offset = 0;
                int offsetX = 0;
                for (int i = 0; i < TracksEditor.this.trackList.size(); ++i) {
                    Track track = TracksEditor.this.trackList.getTrack(i);
                    track.addPropertyChangeListener(this.nameListener);
                    int size = track.getNumColumns();
                    int x1 = offsetX;
                    for (int j = 0; j < size; ++j) {
                        offsetX += columnModel.getColumn(offset).getWidth();
                        ++offset;
                    }
                    JLabel label = new JLabel();
                    label.setBorder(new BevelBorder(0));
                    label.setHorizontalAlignment(0);
                    label.setText(track.getName());
                    this.add(label);
                    label.setLocation(x1, 0);
                    label.setSize(offsetX - x1, 20);
                }
                this.setMinimumSize(new Dimension(offsetX, 20));
                this.setPreferredSize(new Dimension(offsetX, 20));
            });
        }

        public void updateLabelSizes() {
            SwingUtilities.invokeLater(() -> {
                if (TracksEditor.this.trackList == null || this.getComponentCount() == 0) {
                    return;
                }
                TableColumnModel columnModel = TracksEditor.this.table.getColumnModel();
                int count = columnModel.getColumnCount();
                if (count == 0) {
                    return;
                }
                int offset = 0;
                int offsetX = 0;
                for (int i = 0; i < TracksEditor.this.trackList.size(); ++i) {
                    Track track = TracksEditor.this.trackList.getTrack(i);
                    int size = track.getNumColumns();
                    int x1 = offsetX;
                    for (int j = 0; j < size; ++j) {
                        offsetX += columnModel.getColumn(offset).getWidth();
                        ++offset;
                    }
                    JLabel label = (JLabel)this.getComponent(i);
                    label.setLocation(x1, 0);
                    label.setSize(offsetX - x1, 20);
                }
                this.setMinimumSize(new Dimension(offsetX, 20));
                this.setPreferredSize(new Dimension(offsetX, 20));
            });
        }

        public void addChangeListener(ChangeListener cl) {
            if (this.listeners == null) {
                this.listeners = Collections.synchronizedList(new ArrayList());
            }
            this.listeners.add(cl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireChangeEvent() {
            if (this.listeners == null) {
                return;
            }
            if (this.ce == null) {
                new ChangeEvent(this);
            }
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                for (ChangeListener cl : this.listeners) {
                    cl.stateChanged(this.ce);
                }
            }
        }
    }

    class TrackerCellRenderer
    extends DefaultTableCellRenderer {
        TrackerCellRenderer() {
        }

        public boolean isColumnInSelectedTrack(int col) {
            int selectedCol = TracksEditor.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int counter = col;
            Track selectedTrack = TracksEditor.this.trackList.getTrackForColumn(selectedCol);
            Track found = null;
            for (int i = 0; i < TracksEditor.this.trackList.size(); ++i) {
                Track track = TracksEditor.this.trackList.getTrack(i);
                if (counter >= track.getNumColumns()) {
                    counter -= track.getNumColumns();
                    continue;
                }
                found = track;
                break;
            }
            return selectedTrack == found;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TrackList model = (TrackList)table.getModel();
            int index = model.getTrackIndexForColumn(column);
            if (row % 4 == 0) {
                this.setBackground(Color.DARK_GRAY);
            } else if (index % 2 != 0) {
                this.setBackground(Color.DARK_GRAY.darker().darker());
            } else {
                this.setBackground(null);
            }
            int selectedCol = table.getSelectedColumn();
            boolean inSelectedTrack = this.isColumnInSelectedTrack(column);
            inSelectedTrack = inSelectedTrack && table.isRowSelected(row);
            Component c = super.getTableCellRendererComponent(table, value, inSelectedTrack, hasFocus, row, column);
            Column trCol = TracksEditor.this.trackList.getTrackColumn(column);
            ((JLabel)c).setHorizontalAlignment(trCol == null ? 0 : 2);
            int counter = column;
            for (int i = 0; i < model.size(); ++i) {
                Track track = model.getTrack(i);
                if (counter >= track.getNumColumns()) {
                    counter -= track.getNumColumns();
                    continue;
                }
                if (counter == 0 || value != null && !value.equals("")) break;
                super.setValue("---");
                break;
            }
            return c;
        }
    }
}

