/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare.instruments;

import blue.BlueSystem;
import blue.orchestra.Instrument;
import blue.tools.blueShare.BlueShareRemoteCaller;
import blue.tools.blueShare.NamePasswordPanel;
import blue.tools.blueShare.instruments.BlueShareInstrumentCategory;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.xmlrpc.XmlRpcException;

public class InstrumentExportPane
extends JComponent {
    private static final String SELECT_INSTR_TEXT = "Select an Instrument to export";
    NamePasswordPanel namePasswordPanel = new NamePasswordPanel();
    JPanel jPanel2 = new JPanel();
    JSplitPane topSplitPane = new JSplitPane();
    JScrollPane descriptionScrollPane = new JScrollPane();
    JTextArea descriptionText = new JTextArea();
    JButton submitButton = new JButton();
    JPanel instrumentListPanel = new JPanel();
    JTree instrumentLibraryTree = new JTree();
    JScrollPane instrumentListScrollPane = new JScrollPane();
    JLabel iLabel = new JLabel();
    JSplitPane mainSplitPane = new JSplitPane();
    JPanel categoryPanel = new JPanel();
    JLabel cateogriesLabel = new JLabel();
    JScrollPane categoryScrollPane = new JScrollPane();
    JTree categoryTree = new JTree();

    public InstrumentExportPane() {
        this.instrumentLibraryTree.setModel((TreeModel)BlueSystem.getUserInstrumentLibrary());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.descriptionText.setText(SELECT_INSTR_TEXT);
        this.descriptionText.setEnabled(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.instrumentListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.categoryPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cateogriesLabel.setText(BlueSystem.getString((String)"common.categories"));
        this.categoryPanel.setLayout(new BorderLayout());
        this.add((Component)this.namePasswordPanel, "North");
        this.add((Component)this.mainSplitPane, "Center");
        this.add((Component)this.jPanel2, "South");
        this.descriptionText.setText(BlueSystem.getString((String)"blueShare.enterDescription"));
        this.descriptionText.setLineWrap(true);
        this.descriptionScrollPane.setBorder(new TitledBorder(null, BlueSystem.getString((String)"blueShare.instrDescription")));
        this.submitButton.setText(BlueSystem.getString((String)"common.submit"));
        this.instrumentListPanel.setLayout(new BorderLayout());
        this.iLabel.setText(BlueSystem.getString((String)"blueShare.instrumentsFromCurrentProject"));
        this.topSplitPane.add((Component)this.instrumentListPanel, "left");
        this.instrumentListPanel.add((Component)this.instrumentListScrollPane, "Center");
        this.instrumentListPanel.add((Component)this.iLabel, "North");
        this.instrumentListScrollPane.getViewport().add((Component)this.instrumentLibraryTree, null);
        this.descriptionScrollPane.getViewport().add((Component)this.descriptionText, null);
        this.jPanel2.add((Component)this.submitButton, null);
        this.topSplitPane.setDividerLocation(300);
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.add((Component)this.topSplitPane, "top");
        this.mainSplitPane.add((Component)this.descriptionScrollPane, "bottom");
        this.topSplitPane.add((Component)this.categoryPanel, "right");
        this.categoryPanel.add((Component)this.cateogriesLabel, "North");
        this.categoryPanel.add((Component)this.categoryScrollPane, "Center");
        this.categoryScrollPane.getViewport().add((Component)this.categoryTree, null);
        this.mainSplitPane.setDividerLocation(200);
        this.submitButton.addActionListener(e -> this.submitInstrument());
        this.instrumentLibraryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = InstrumentExportPane.this.instrumentLibraryTree.getSelectionPath();
                if (path == null) {
                    InstrumentExportPane.this.descriptionText.setText(InstrumentExportPane.SELECT_INSTR_TEXT);
                    InstrumentExportPane.this.descriptionText.setEnabled(false);
                    return;
                }
                Object userObj = path.getLastPathComponent();
                if (!(userObj instanceof Instrument)) {
                    InstrumentExportPane.this.descriptionText.setText(InstrumentExportPane.SELECT_INSTR_TEXT);
                    InstrumentExportPane.this.descriptionText.setEnabled(false);
                    return;
                }
                Instrument instr = (Instrument)userObj;
                InstrumentExportPane.this.descriptionText.setText(instr.getComment());
                InstrumentExportPane.this.descriptionText.setEnabled(true);
            }
        });
    }

    public void setCategories(BlueShareInstrumentCategory[] categories) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(BlueSystem.getString((String)"common.categories"));
        this.addSubCategories(root, categories);
        this.categoryTree.setModel(new DefaultTreeModel(root));
    }

    private void addSubCategories(DefaultMutableTreeNode parent, BlueShareInstrumentCategory[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode(categories[i]);
            parent.add(temp);
            this.addSubCategories(temp, categories[i].getSubCategories());
        }
    }

    private void submitInstrument() {
        try {
            TreePath path = this.instrumentLibraryTree.getSelectionPath();
            if (path == null) {
                return;
            }
            Object userObj = path.getLastPathComponent();
            if (!(userObj instanceof Instrument)) {
                return;
            }
            Instrument instrument = (Instrument)userObj;
            DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)this.categoryTree.getSelectionPath().getLastPathComponent();
            BlueShareInstrumentCategory category = (BlueShareInstrumentCategory)tempNode.getUserObject();
            String username = this.namePasswordPanel.getUsername();
            String password = this.namePasswordPanel.getPassword();
            int categoryId = category.getCategoryId();
            String name = instrument.getName();
            String instrumentType = instrument.getClass().getName();
            String description = this.descriptionText.getText();
            String instrumentText = instrument.saveAsXML().toString();
            System.out.println(instrument.saveAsXML().getTextString());
            BlueShareRemoteCaller.submitInstrument(username, password, categoryId, name, instrumentType, description, instrumentText);
        }
        catch (IOException | XmlRpcException e) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"blueShare.errorSubmittingInstrument") + "\n\n" + e.getLocalizedMessage(), BlueSystem.getString((String)"common.error"), 0);
            e.printStackTrace();
            return;
        }
        JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"blueShare.successfullyReceived"), BlueSystem.getString((String)"common.success"), -1);
    }

    public static void main(String[] args) {
        InstrumentExportPane instrumentExportPane1 = new InstrumentExportPane();
        GUI.showComponentAsStandalone((Component)instrumentExportPane1, (String)"Instrument Export Pane Test", (boolean)true);
    }
}

