/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare.soundObjects;

import blue.BlueSystem;
import blue.tools.blueShare.BlueShareRemoteCaller;
import blue.tools.blueShare.NamePasswordPanel;
import blue.tools.blueShare.soundObjects.SoundObjectManagementTableModel;
import blue.tools.blueShare.soundObjects.SoundObjectOption;
import blue.utility.GUI;
import electric.xml.ParseException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.xmlrpc.XmlRpcException;

public class SoundObjectManagementPane
extends JComponent {
    NamePasswordPanel namePasswordPanel = new NamePasswordPanel();
    CardLayout cardLayout = new CardLayout();
    JTable soundObjectTable = new JTable();
    SoundObjectManagementTableModel iTableModel = new SoundObjectManagementTableModel();
    JButton fetchSoundObjectsButton = new JButton("Fetch SoundObjects");
    JButton removeSoundObjectButton = new JButton("Remove SoundObject");
    JButton updateSoundObjectButton = new JButton(BlueSystem.getString((String)"blueShare.update"));
    JPanel cardPanel;

    public SoundObjectManagementPane() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.namePasswordPanel, "North");
        this.soundObjectTable.setModel(this.iTableModel);
        this.cardPanel = new JPanel(this.cardLayout);
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.soundObjectTable);
        this.cardPanel.add((Component)new JLabel("No SoundObjects for user."), "none");
        this.cardPanel.add((Component)jsp, "soundObjects");
        this.add((Component)this.cardPanel, "Center");
        this.fetchSoundObjectsButton.addActionListener(e -> this.fetchSoundObjects());
        this.removeSoundObjectButton.addActionListener(e -> this.removeSoundObject());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.fetchSoundObjectsButton);
        buttonPanel.add(this.removeSoundObjectButton);
        this.add((Component)buttonPanel, "South");
        this.cardLayout.show(this.cardPanel, "soundObjects");
    }

    protected void removeSoundObject() {
        SoundObjectOption iOption = this.iTableModel.getSoundObjectOption(this.soundObjectTable.getSelectedRow());
        if (iOption == null) {
            return;
        }
        int retVal = JOptionPane.showConfirmDialog(null, "Are you sure you would like to remove this SoundObject from BlueShare?");
        if (retVal != 0) {
            return;
        }
        String username = this.namePasswordPanel.getUsername();
        String password = this.namePasswordPanel.getPassword();
        try {
            boolean bl = BlueShareRemoteCaller.removeSoundObject(username, password, iOption.getSoundObjectId());
        }
        catch (IOException | XmlRpcException xre) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + xre.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setSoundObjectOptions(null);
            return;
        }
        JOptionPane.showMessageDialog(null, "SoundObject was successfully removed.", "Success", -1);
        this.fetchSoundObjects();
    }

    protected void updateSoundObject() {
        SoundObjectOption iOption = this.iTableModel.getSoundObjectOption(this.soundObjectTable.getSelectedRow());
        if (iOption == null) {
            return;
        }
        JOptionPane.showMessageDialog(null, "Diagram and figure out best implementation");
    }

    protected void fetchSoundObjects() {
        String username = this.namePasswordPanel.getUsername();
        String password = this.namePasswordPanel.getPassword();
        try {
            SoundObjectOption[] iOptions = BlueShareRemoteCaller.getSoundObjectOptionsForUser(username, password);
            this.iTableModel.setSoundObjectOptions(iOptions);
            if (iOptions.length == 0) {
                this.cardLayout.show(this.cardPanel, "none");
            } else {
                this.cardLayout.show(this.cardPanel, "soundObjects");
            }
        }
        catch (ParseException pe) {
            String error = BlueSystem.getString((String)"blueShare.selectServer.couldNotReadResponse");
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setSoundObjectOptions(null);
            return;
        }
        catch (XmlRpcException xre) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + xre.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setSoundObjectOptions(null);
            return;
        }
        catch (IOException ioe) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + ioe.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setSoundObjectOptions(null);
            return;
        }
    }

    public static void main(String[] args) {
        GUI.showComponentAsStandalone((Component)new SoundObjectManagementPane(), (String)"SoundObjectManagementPane", (boolean)true);
    }
}

