/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core;

import blue.BlueData;
import blue.BlueSystem;
import blue.projects.BlueProjectManager;
import blue.projects.actions.OpenProjectAction;
import blue.score.ScoreGenerationException;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionGroups;
import org.netbeans.spi.sendopts.OptionProcessor;

public class CompileProcessor
extends OptionProcessor {
    private Option c = Option.requiredArgument((char)'c', (String)"compile");
    private Option o = Option.requiredArgument((char)'o', (String)"output");

    protected Set<Option> getOptions() {
        HashSet<Option> options = new HashSet<Option>();
        Option.shortDescription((Option)this.o, (String)"Bundle.properties", (String)"option.compile.description");
        Option.shortDescription((Option)this.o, (String)"Bundle.properties", (String)"option.output.description");
        options.add(OptionGroups.allOf((Option[])new Option[]{this.c, this.o}));
        return options;
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        String compileFileName = null;
        String outFileName = null;
        if (optionValues.containsKey(this.c)) {
            compileFileName = optionValues.get(this.c)[0];
        }
        if (optionValues.containsKey(this.o)) {
            outFileName = optionValues.get(this.o)[0];
        }
        if (compileFileName == null && outFileName == null) {
            return;
        }
        if (compileFileName == null && outFileName != null) {
            throw new CommandException(1, ".blue project not given as argument");
        }
        File in = new File(compileFileName);
        if (!in.exists() || !in.isFile()) {
            throw new CommandException(1, "Could not open .blue file: " + in.getAbsolutePath());
        }
        if (outFileName == null) {
            outFileName = compileFileName.substring(0, compileFileName.indexOf(".blue")) + ".csd";
        }
        OpenProjectAction.open((File)in);
        PrintWriter out = null;
        try {
            BlueData tempData = BlueProjectManager.getInstance().getCurrentBlueData();
            out = new PrintWriter(new BufferedWriter(new FileWriter(outFileName)));
            CsdRenderResult renderResult = CSDRenderService.getDefault().generateCSD(tempData, 0.0, -1.0, false, false);
            out.print(renderResult.getCsdText());
            out.close();
            throw new CommandException(0, compileFileName + " " + BlueSystem.getString((String)"blue.compiledTo") + " " + outFileName);
        }
        catch (ScoreGenerationException | IOException | CommandException e) {
            if (out != null) {
                out.close();
            }
            if (e instanceof CommandException) {
                throw (CommandException)e;
            }
            throw new CommandException(1, BlueSystem.getString((String)"message.errorLabel") + " " + BlueSystem.getString((String)"blue.csdCompileError") + e.getMessage());
        }
    }
}

