/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core;

import blue.projects.actions.OpenProjectAction;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;

public class OpenFileProcessor
extends OptionProcessor {
    private static final Logger log = Logger.getLogger(OpenFileProcessor.class.getName());
    private Option c = Option.defaultArguments();

    protected Set<Option> getOptions() {
        HashSet<Option> options = new HashSet<Option>();
        options.add(this.c);
        return options;
    }

    protected void process(Env env, Map<Option, String[]> values) throws CommandException {
        String[] vals = values.get(this.c);
        if (vals != null) {
            for (String fName : vals) {
                File file = new File(fName);
                if (!file.isAbsolute()) {
                    file = new File(env.getCurrentDirectory(), fName);
                }
                if (!file.exists()) {
                    try {
                        file = new File(new URI(fName));
                    }
                    catch (URISyntaxException ex) {
                        file = null;
                    }
                }
                if (file == null || !file.exists()) {
                    log.warning("Can not open file: does not exist: " + fName);
                    continue;
                }
                if (!file.getName().endsWith(".blue")) {
                    log.warning("Can not open non-Blue file: " + fName);
                    continue;
                }
                log.info("Opening Blue project: " + fName);
                OpenProjectAction.open((File)file);
            }
        }
    }
}

