/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.blueLive;

import blue.BlueData;
import blue.event.PlayModeListener;
import blue.midi.MidiInputManager;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.core.render.RealtimeRenderManager;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class BlueLiveToolBar
extends JToolBar {
    BlueData data = null;
    JToggleButton runButton = new JToggleButton("blueLive");
    JButton refreshButton = new JButton("Recompile");
    JButton allNotesOffButton = new JButton("All Notes Off");
    JToggleButton midiButton = new JToggleButton("MIDI Input");
    private static BlueLiveToolBar instance = null;
    boolean restartInProgress = false;

    public static BlueLiveToolBar getInstance() {
        if (instance == null) {
            instance = new BlueLiveToolBar();
        }
        return instance;
    }

    private BlueLiveToolBar() {
        this.setFloatable(false);
        PlayModeListener playModeListener = playMode -> {
            if (playMode == 0) {
                this.runButton.setSelected(false);
            } else if (playMode == 1) {
                this.runButton.setSelected(true);
            }
        };
        RealtimeRenderManager.getInstance().addBlueLivePlayModeListener(playModeListener);
        this.runButton.addActionListener(e -> this.runButtonActionPerformed());
        this.refreshButton.addActionListener(e -> this.refreshButtonActionPerformed());
        this.allNotesOffButton.addActionListener(this::allNotesOffButtonActionPerformed);
        this.midiButton.addActionListener(e -> this.midiButtonActionPerformed());
        this.add(this.runButton);
        this.add(this.refreshButton);
        this.add(this.allNotesOffButton);
        this.add(this.midiButton);
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.runButton.setFocusable(false);
        this.refreshButton.setFocusable(false);
        this.allNotesOffButton.setFocusable(false);
        this.midiButton.setFocusable(false);
        this.reinitialize();
    }

    private void reinitialize() {
        this.data = null;
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        Object currentData = null;
        if (project != null) {
            this.data = project.getData();
        }
    }

    protected void runButtonActionPerformed() {
        RealtimeRenderManager manager = RealtimeRenderManager.getInstance();
        if (manager.isBlueLiveRendering()) {
            manager.stopBlueLiveRendering();
        } else {
            manager.renderForBlueLive(this.data);
        }
    }

    protected void refreshButtonActionPerformed() {
        if (this.data == null) {
            return;
        }
        RealtimeRenderManager.getInstance().renderForBlueLive(this.data);
    }

    protected void finishRefresh() {
    }

    public void midiButtonActionPerformed() {
        boolean selected = this.midiButton.isSelected();
        if (selected) {
            MidiInputManager.getInstance().start();
        } else {
            MidiInputManager.getInstance().stop();
        }
    }

    protected void allNotesOffButtonActionPerformed(ActionEvent evt) {
        this.sendEvents("i \"blueAllNotesOff\" 0 1");
    }

    public void sendEvents(String scoText) {
        RealtimeRenderManager.getInstance().passToStdin(scoText);
    }

    public boolean isRunning() {
        return RealtimeRenderManager.getInstance().isBlueLiveRendering();
    }

    public void stopRendering() {
        RealtimeRenderManager manager = RealtimeRenderManager.getInstance();
        if (manager.isBlueLiveRendering()) {
            manager.stopBlueLiveRendering();
            if (this.runButton.isSelected()) {
                this.runButton.setSelected(false);
            }
        }
    }
}

