/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.blueLive;

import blue.blueLive.LiveObject;
import blue.blueLive.LiveObjectSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class LiveObjectRenderer
extends JLabel
implements TableCellRenderer {
    private LiveObjectSet set;
    Border highlightedBorder = BorderFactory.createLineBorder(Color.WHITE);
    private static Object HIGHGLIGHTED = new Object();
    private static Color HIGHLIGHT_PAINT = new Color(255, 255, 255, 128);

    public LiveObjectRenderer() {
        this.setOpaque(true);
    }

    public void setLiveObjectSet(LiveObjectSet set) {
        this.set = set;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        LiveObject lObj = (LiveObject)value;
        if (lObj != null && lObj.isEnabled()) {
            this.setForeground(Color.BLACK);
            if (isSelected) {
                this.setBackground(Color.ORANGE.brighter());
            } else {
                this.setBackground(Color.ORANGE);
            }
        } else if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (lObj != null) {
            this.setText(lObj.getSoundObject().getName());
        } else {
            this.setText("");
        }
        if (this.set != null && this.set.contains((Object)lObj)) {
            this.putClientProperty(HIGHGLIGHTED, Boolean.TRUE);
        } else {
            this.putClientProperty(HIGHGLIGHTED, Boolean.FALSE);
        }
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Boolean b = (Boolean)this.getClientProperty(HIGHGLIGHTED);
        if (b.booleanValue()) {
            g.setColor(HIGHLIGHT_PAINT);
            Rectangle r = g.getClipBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }
}

