/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.midi;

import blue.midi.MidiInputManager;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;

public class VirtualKeyboardController
implements Initializable {
    @FXML
    private VBox root;
    @FXML
    private Spinner<Integer> channelSpinner;
    @FXML
    private Spinner<Integer> velocitySpinner;
    @FXML
    private Spinner<Integer> octaveSpinner;
    private static final int KEY_OFFSET = 21;
    private AtomicBoolean[] keyStates = new AtomicBoolean[88];
    private AtomicBoolean[] changedKeyStates = new AtomicBoolean[88];
    private int[] whiteKeys = new int[7];
    private int lastMidiKey = -1;
    private int octave = 5;
    private int channel = 0;
    private int velocity = 127;
    private MidiInputManager midiEngine = MidiInputManager.getInstance();

    public void initialize(URL url, ResourceBundle rb) {
        this.channelSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 16, 1));
        this.velocitySpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 127, 127));
        this.octaveSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 7, 5));
    }

    @FXML
    private void allNotesOff(ActionEvent event) {
        System.out.println("all notes off");
    }

    @FXML
    private void handleKeyPressed(KeyEvent event) {
        System.out.println("Event Press: " + event.getCode());
    }

    @FXML
    private void handleKeyReleased(KeyEvent event) {
    }
}

