/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.mixer.Effect;
import blue.ui.core.mixer.EffectEditor;
import blue.ui.utilities.SimpleDocumentListener;
import com.l2fprod.common.swing.BaseDialog;
import electric.xml.Element;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddEffectEditorDialog
extends BaseDialog
implements WindowSettingsSavable {
    private Effect effect = null;
    private Effect copy = null;
    JTextField nameText = new JTextField();
    EffectEditor effectEditor = new EffectEditor();

    public AddEffectEditorDialog(Frame parent) {
        super(parent, "Edit Effect", true);
        this.getBanner().setVisible(false);
        this.setDefaultCloseOperation(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.effectEditor, "Center");
        contentPane.add(this.getNamePanel(), "North");
        this.nameText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (AddEffectEditorDialog.this.copy != null) {
                    AddEffectEditorDialog.this.copy.setName(AddEffectEditorDialog.this.nameText.getText());
                } else if (AddEffectEditorDialog.this.effect != null) {
                    AddEffectEditorDialog.this.effect.setName(AddEffectEditorDialog.this.nameText.getText());
                }
            }
        });
        this.pack();
        this.centerOnScreen();
        WindowSettingManager.getInstance().registerWindow("AddEffectEditorDialog", (Window)((Object)this));
    }

    private Component getNamePanel() {
        JPanel panel = new JPanel();
        JLabel label = new JLabel("Name:");
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameText).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.nameText))));
        return panel;
    }

    public void setEffect(Effect effect) {
        if (effect == null) {
            this.setTitle("Add Effect");
            this.effect = new Effect();
            this.copy = null;
            this.nameText.setText(this.effect.getName());
            this.effectEditor.setEffect(this.effect);
        } else {
            this.setTitle("Edit Effect");
            this.effect = effect;
            this.copy = new Effect(effect);
            this.nameText.setText(this.copy.getName());
            this.effectEditor.setEffect(this.copy);
        }
    }

    public void commitEdit() {
        this.effect.setCode(this.copy.getCode());
        this.effect.setComments(this.copy.getComments());
        this.effect.setGraphicInterface(this.copy.getGraphicInterface());
        this.effect.setName(this.copy.getName());
        this.effect.setNumIns(this.copy.getNumIns());
        this.effect.setNumOuts(this.copy.getNumOuts());
    }

    public Effect getEffect() {
        return this.effect;
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, (Window)((Object)this));
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings((Window)((Object)this));
    }
}

