/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Effect;
import blue.ui.core.mixer.EffectCategory;
import blue.ui.core.mixer.EffectsLibrary;
import blue.ui.core.mixer.TransferableEffect;
import blue.utility.ListUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class EffectTreeDropTarget
implements DropTargetListener {
    DropTarget target;
    JTree targetTree;

    public EffectTreeDropTarget(JTree tree) {
        this.targetTree = tree;
        this.target = new DropTarget(this.targetTree, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (!dtde.isDataFlavorSupported(TransferableEffect.EFFECT_FLAVOR) && !dtde.isDataFlavorSupported(TransferableEffect.EFFECT_CAT_FLAVOR)) {
            dtde.rejectDrag();
            return;
        }
        Point p = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath path = tree.getClosestPathForLocation(p.x, p.y);
        if (path.getLastPathComponent() instanceof EffectCategory) {
            dtde.acceptDrag(dtde.getDropAction());
        } else if (dtde.isDataFlavorSupported(TransferableEffect.EFFECT_FLAVOR)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.dragEnter(dtde);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point pt = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath parentpath = tree.getClosestPathForLocation(pt.x, pt.y);
        Object node = parentpath.getLastPathComponent();
        EffectsLibrary eLibrary = EffectsLibrary.getInstance();
        if (dtde.isDataFlavorSupported(TransferableEffect.EFFECT_CAT_FLAVOR)) {
            if (!(node instanceof EffectCategory)) {
                dtde.rejectDrop();
                return;
            }
            if (dtde.getDropAction() == 2) {
                dtde.acceptDrop(dtde.getDropAction());
                Transferable tr = dtde.getTransferable();
                try {
                    Object transferNode = tr.getTransferData(TransferableEffect.EFFECT_CAT_FLAVOR);
                    EffectCategory effectCategory = (EffectCategory)transferNode;
                    EffectCategory parentNode = (EffectCategory)node;
                    eLibrary.addCategory(parentNode, effectCategory);
                    dtde.dropComplete(true);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    dtde.dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        } else if (dtde.isDataFlavorSupported(TransferableEffect.EFFECT_FLAVOR)) {
            dtde.acceptDrop(dtde.getDropAction());
            try {
                Transferable tr = dtde.getTransferable();
                Object transferNode = tr.getTransferData(TransferableEffect.EFFECT_FLAVOR);
                Effect effect = (Effect)transferNode;
                effect.clearParameters();
                if (node instanceof EffectCategory) {
                    EffectCategory parentNode = (EffectCategory)node;
                    eLibrary.addEffect(parentNode, effect);
                } else if (node instanceof Effect) {
                    EffectCategory parentNode = (EffectCategory)parentpath.getPathComponent(parentpath.getPathCount() - 2);
                    int index = ListUtil.indexOfByRef((List)parentNode.getEffects(), (Object)node);
                    int closestRow = tree.getClosestRowForLocation(pt.x, pt.y);
                    Rectangle bounds = tree.getRowBounds(closestRow);
                    if (pt.y > bounds.y + bounds.height) {
                        eLibrary.addEffect(parentNode, effect);
                    } else {
                        eLibrary.addEffect(parentNode, index, effect);
                    }
                }
                dtde.dropComplete(true);
            }
            catch (UnsupportedFlavorException | IOException e) {
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }
}

