/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.Arrangement;
import blue.BlueData;
import blue.actions.BlueAction;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.orchestra.BlueSynthBuilder;
import blue.orchestra.Instrument;
import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.BSBSubChannelDropdown;
import blue.projects.BlueProjectManager;
import blue.ui.core.mixer.ChannelListLayout;
import blue.ui.core.mixer.ChannelPanel;
import blue.ui.core.mixer.SubChannelOutComboBoxModel;
import blue.ui.utilities.UiUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;

public class SubChannelListPanel
extends JComponent
implements Scrollable,
PropertyChangeListener {
    private ChannelList subChannels = null;
    private JPopupMenu addPopup = new JPopupMenu();
    private JPopupMenu removePopup = new JPopupMenu();
    private ChannelPanel selectedChannelPanel = null;
    private MouseListener removePanelListener;
    private ArrayList models = new ArrayList();
    private Vector listeners = new Vector();

    public SubChannelListPanel() {
        this.setLayout(new ChannelListLayout(90));
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Dimension preferredLayoutSize = SubChannelListPanel.this.getLayout().preferredLayoutSize(SubChannelListPanel.this);
                SubChannelListPanel.this.setPreferredSize(preferredLayoutSize);
                SubChannelListPanel.this.setSize(preferredLayoutSize);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Dimension preferredLayoutSize = SubChannelListPanel.this.getLayout().preferredLayoutSize(SubChannelListPanel.this);
                SubChannelListPanel.this.setPreferredSize(preferredLayoutSize);
                SubChannelListPanel.this.setSize(preferredLayoutSize);
            }
        });
        BlueAction addSubChannel = new BlueAction("mixer.addSubChannel"){

            public void actionPerformed(ActionEvent e) {
                SubChannelListPanel.this.addSubChannnel();
            }
        };
        this.addPopup.add((Action)addSubChannel);
        BlueAction removeSubChannel = new BlueAction("mixer.removeSubChannel"){

            public void actionPerformed(ActionEvent e) {
                SubChannelListPanel.this.removeSubChannnel();
            }
        };
        this.removePopup.add((Action)removeSubChannel);
        this.removePanelListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e) && e.getSource() instanceof ChannelPanel) {
                    SubChannelListPanel.this.selectedChannelPanel = (ChannelPanel)e.getSource();
                    SubChannelListPanel.this.removePopup.show(SubChannelListPanel.this.selectedChannelPanel, e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    SubChannelListPanel.this.addPopup.show(SubChannelListPanel.this, e.getX(), e.getY());
                }
            }
        });
        this.setMinimumSize(new Dimension(50, 0));
    }

    public void setChannelList(ChannelList channels) {
        if (this.subChannels != null) {
            // empty if block
        }
        this.subChannels = channels;
        this.clearChannels();
        this.rebuildChannelsUI(channels);
    }

    private void clearChannels() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ChannelPanel cPanel = (ChannelPanel)this.getComponent(i);
            cPanel.clear();
            cPanel.getChannel().removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.models.clear();
        this.removeAll();
    }

    private void rebuildChannelsUI(ChannelList channels) {
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.get(i);
            ChannelPanel cPanel = this.createChannelPanel(channel);
            this.add(cPanel);
        }
    }

    private ChannelPanel createChannelPanel(Channel channel) {
        ChannelPanel cPanel = new ChannelPanel();
        SubChannelOutComboBoxModel model = new SubChannelOutComboBoxModel();
        this.models.add(model);
        channel.addPropertyChangeListener((PropertyChangeListener)this);
        model.setData(this.subChannels, channel);
        model.setSelectedItem(channel.getOutChannel());
        cPanel.setChannelOutModel(model);
        cPanel.setSubChannel(true);
        cPanel.setChannel(channel);
        cPanel.addMouseListener(this.removePanelListener);
        return cPanel;
    }

    private void addSubChannnel() {
        Channel channel = new Channel();
        int index = this.subChannels.size() + 1;
        boolean valid = false;
        while (!valid) {
            String name = "SubChannel" + index;
            if (this.subChannels.indexByName((Object)name) < 0) {
                channel.setName(name);
                valid = true;
                continue;
            }
            ++index;
        }
        this.subChannels.add((Object)channel);
        ChannelPanel cPanel = this.createChannelPanel(channel);
        this.add(cPanel);
        this.revalidate();
    }

    private void removeSubChannnel() {
        if (this.selectedChannelPanel == null) {
            return;
        }
        Channel channel = this.selectedChannelPanel.getChannel();
        channel.removePropertyChangeListener((PropertyChangeListener)this);
        this.subChannels.remove((Object)channel);
        this.models.remove(this.selectedChannelPanel.getChannelOutModel());
        this.selectedChannelPanel.clear();
        this.remove(this.selectedChannelPanel);
        this.selectedChannelPanel = null;
        String removedChannel = channel.getName();
        this.reconcileSubChannelRemoveInBlueArrangement(removedChannel);
        this.revalidate();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.add(pcl);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent pce) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("name")) {
            String oldName = (String)pce.getOldValue();
            String newName = (String)pce.getNewValue();
            for (SubChannelOutComboBoxModel model : this.models) {
                model.reconcile(oldName, newName);
            }
            this.firePropertyChangeEvent(pce);
            this.reconcileNameChangeInBlueArrangement(oldName, newName);
        }
    }

    private void reconcileNameChangeInBlueArrangement(String oldName, String newName) {
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        if (data == null) {
            return;
        }
        Arrangement arr = data.getArrangement();
        for (int i = 0; i < arr.size(); ++i) {
            Instrument instr = arr.getInstrument(i);
            if (!(instr instanceof BlueSynthBuilder)) continue;
            BlueSynthBuilder bsb = (BlueSynthBuilder)instr;
            BSBGraphicInterface bsbInterface = bsb.getGraphicInterface();
            for (BSBObject bsbObj : bsbInterface.getAllSet()) {
                BSBSubChannelDropdown bsbSubDrop;
                if (!(bsbObj instanceof BSBSubChannelDropdown) || !(bsbSubDrop = (BSBSubChannelDropdown)bsbObj).getChannelOutput().equals(oldName)) continue;
                bsbSubDrop.setChannelOutput(newName);
            }
        }
    }

    private void reconcileSubChannelRemoveInBlueArrangement(String removedChannel) {
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        if (data == null) {
            return;
        }
        Arrangement arr = data.getArrangement();
        for (int i = 0; i < arr.size(); ++i) {
            Instrument instr = arr.getInstrument(i);
            if (!(instr instanceof BlueSynthBuilder)) continue;
            BlueSynthBuilder bsb = (BlueSynthBuilder)instr;
            BSBGraphicInterface bsbInterface = bsb.getGraphicInterface();
            for (BSBObject bsbObj : bsbInterface.getAllSet()) {
                BSBSubChannelDropdown bsbSubDrop;
                if (!(bsbObj instanceof BSBSubChannelDropdown) || !(bsbSubDrop = (BSBSubChannelDropdown)bsbObj).getChannelOutput().equals(removedChannel)) continue;
                bsbSubDrop.setChannelOutput("Master");
            }
        }
    }
}

