/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra;

import blue.orchestra.Instrument;
import blue.orchestra.editor.InstrumentEditor;
import blue.ui.nbutilities.lazyplugin.ClassAssociationProcessor;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class InstrumentEditPanel
extends JComponent {
    JPanel editPanel = new JPanel();
    HashMap<Class, LazyPlugin<InstrumentEditor>> instrEditorMap = new HashMap();
    HashMap<Class, InstrumentEditor> instrEditorCache = new HashMap();
    CardLayout cardLayout = new CardLayout();
    Instrument currentInstrument = null;
    JTextArea commentPane = new JTextArea();
    Border libraryBorder = new LineBorder(Color.GREEN);
    JLabel libraryEditLabel = new JLabel("Editing Library Instrument");

    public InstrumentEditPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("Instrument Editor", this.editPanel);
        tabs.add("Comments", new JScrollPane(this.commentPane));
        this.commentPane.setWrapStyleWord(true);
        this.commentPane.setLineWrap(true);
        this.editPanel.setLayout(this.cardLayout);
        this.libraryEditLabel.setOpaque(true);
        this.libraryEditLabel.setHorizontalAlignment(0);
        this.libraryEditLabel.setBackground(Color.GREEN);
        this.libraryEditLabel.setForeground(Color.BLACK);
        this.libraryEditLabel.setFont(new Font("dialog", 0, 10));
        this.add((Component)this.libraryEditLabel, "North");
        this.add((Component)tabs, "Center");
        this.editPanel.add((Component)new JPanel(), "none");
        this.commentPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateComment();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateComment();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateComment();
            }

            private void updateComment() {
                if (InstrumentEditPanel.this.currentInstrument != null) {
                    InstrumentEditPanel.this.currentInstrument.setComment(InstrumentEditPanel.this.commentPane.getText());
                }
            }
        });
        this.setEditingLibraryObject(false);
        List plugins = LazyPluginFactory.loadPlugins((String)"blue/instrumentEditors", InstrumentEditor.class, (LazyPluginFactory.MetaDataProcessor)new ClassAssociationProcessor("instrumentType"));
        for (LazyPlugin plugin : plugins) {
            this.instrEditorMap.put((Class)plugin.getMetaData("association"), (LazyPlugin<InstrumentEditor>)plugin);
        }
    }

    public void setEditingLibraryObject(boolean isLibaryObject) {
        if (isLibaryObject) {
            this.setBorder(this.libraryBorder);
        } else {
            this.setBorder(null);
        }
        this.libraryEditLabel.setVisible(isLibaryObject);
    }

    public void editInstrument(Instrument instr) {
        if (this.currentInstrument == instr) {
            return;
        }
        this.currentInstrument = instr;
        if (instr == null) {
            this.commentPane.setText("");
            this.cardLayout.show(this.editPanel, "none");
            this.commentPane.setEnabled(false);
            return;
        }
        this.commentPane.setEnabled(true);
        this.commentPane.setText(instr.getComment());
        Class<?> instrClass = instr.getClass();
        InstrumentEditor instrEditor = this.instrEditorCache.get(instrClass);
        if (instrEditor == null) {
            for (Class c : this.instrEditorMap.keySet()) {
                if (!c.isAssignableFrom(instrClass)) continue;
                LazyPlugin<InstrumentEditor> plugin = this.instrEditorMap.get(c);
                instrEditor = (InstrumentEditor)plugin.getInstance();
                this.instrEditorCache.put(instrClass, instrEditor);
                this.editPanel.add((Component)instrEditor, instrEditor.getClass().getName());
                break;
            }
        }
        this.cardLayout.show(this.editPanel, instrEditor.getClass().getName());
        instrEditor.editInstrument(instr);
    }
}

