/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra;

import blue.BlueSystem;
import blue.InstrumentLibrary;
import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import blue.orchestra.Instrument;
import blue.ui.core.orchestra.InstrumentTreeDragSource;
import blue.ui.core.orchestra.InstrumentTreeDropTarget;
import blue.ui.core.orchestra.UserInstrumentTreePopup;
import blue.ui.utilities.UiUtilities;
import blue.utility.ObjectUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class UserInstrumentLibrary
extends JComponent {
    private static MessageFormat toolTipFormat = new MessageFormat("<html><b>Instrument Type:</b> {0}</html>");
    private static final UserInstrumentTreePopup popup = new UserInstrumentTreePopup();
    public InstrumentLibrary iLibrary = null;
    JTree libraryTree = new JTree();
    ArrayList listeners = new ArrayList();

    public UserInstrumentLibrary() {
        this.setLayout(new BorderLayout());
        JLabel label = new JLabel("User Instrument Library");
        this.add((Component)label, "North");
        label.setMinimumSize(new Dimension(0, 0));
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(3, 3, 3, 3)));
        JScrollPane libraryScroll = new JScrollPane(this.libraryTree);
        libraryScroll.setBorder(null);
        libraryScroll.setMinimumSize(new Dimension(0, 0));
        this.add((Component)libraryScroll, "Center");
        this.libraryTree.setEditable(true);
        ToolTipManager.sharedInstance().registerComponent(this.libraryTree);
        this.libraryTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof Instrument) {
                    Object[] args = new Object[]{ObjectUtilities.getShortClassName((Object)value)};
                    String tip = toolTipFormat.format(args);
                    this.setToolTipText(tip);
                } else {
                    this.setToolTipText(null);
                }
                return this;
            }
        });
        new InstrumentTreeDragSource(this.libraryTree, 3);
        new InstrumentTreeDropTarget(this.libraryTree);
        this.libraryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = UserInstrumentLibrary.this.libraryTree.getSelectionPath();
                if (path == null) {
                    return;
                }
                Object userObject = path.getLastPathComponent();
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    Point p = e.getPoint();
                    p = SwingUtilities.convertPoint(UserInstrumentLibrary.this.libraryTree, p, UserInstrumentLibrary.this);
                    UserInstrumentLibrary.this.showPopup(userObject, (int)p.getX(), (int)p.getY());
                } else {
                    SelectionEvent se = new SelectionEvent(userObject, 0);
                    UserInstrumentLibrary.this.fireSelected(se);
                }
            }
        });
        InputMap inputMap = this.libraryTree.getInputMap(0);
        ActionMap actionMap = this.libraryTree.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(88, BlueSystem.getMenuShortcutKey()), "cutNode");
        inputMap.put(KeyStroke.getKeyStroke(67, BlueSystem.getMenuShortcutKey()), "copyNode");
        inputMap.put(KeyStroke.getKeyStroke(86, BlueSystem.getMenuShortcutKey()), "pasteNode");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteNode");
        actionMap.put("cutNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInstrumentLibrary.this.cutNode();
            }
        });
        actionMap.put("copyNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInstrumentLibrary.this.copyNode();
            }
        });
        actionMap.put("pasteNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInstrumentLibrary.this.pasteNode();
            }
        });
        actionMap.put("deleteNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInstrumentLibrary.this.deleteNode();
            }
        });
        this.libraryTree.getSelectionModel().setSelectionMode(1);
        this.iLibrary = BlueSystem.getUserInstrumentLibrary();
        this.libraryTree.setModel((TreeModel)this.iLibrary);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSelected(SelectionEvent se) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            SelectionListener listener = (SelectionListener)this.listeners.get(i);
            listener.selectionPerformed(se);
        }
    }

    protected void cutNode() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object userObj = path.getLastPathComponent();
        popup.setInstrumentGUI(this);
        popup.setUserObj(userObj);
        popup.cutNode();
    }

    protected void copyNode() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object userObj = path.getLastPathComponent();
        popup.setInstrumentGUI(this);
        popup.setUserObj(userObj);
        popup.copyNode();
    }

    protected void pasteNode() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object userObj = path.getLastPathComponent();
        popup.setInstrumentGUI(this);
        popup.setUserObj(userObj);
        popup.pasteNode();
    }

    protected void deleteNode() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object userObj = path.getLastPathComponent();
        popup.setInstrumentGUI(this);
        popup.setUserObj(userObj);
        popup.deleteNode();
    }

    private void showPopup(Object userObj, int x, int y) {
        popup.show(this, userObj, x, y);
    }

    public void removeInstrument(Instrument instr) {
        this.iLibrary.removeInstrument(instr);
    }

    public Instrument getSelectedInstrument() {
        TreePath selectionPath = this.libraryTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        Object obj = selectionPath.getLastPathComponent();
        if (obj instanceof Instrument) {
            return (Instrument)obj;
        }
        return null;
    }

    public void deselect() {
        this.libraryTree.clearSelection();
    }
}

