/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor;

import blue.BlueSystem;
import blue.gui.InfoDialog;
import blue.orchestra.Instrument;
import blue.orchestra.JavaScriptInstrument;
import blue.orchestra.editor.InstrumentEditor;
import blue.ui.core.udo.EmbeddedOpcodeListPanel;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import blue.undo.TabWatchingUndoableEditGenerator;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class JavaScriptInstrumentEditor
extends InstrumentEditor {
    private static HashMap tokenMarkerTypes = new HashMap();
    protected MimeTypeEditorComponent codeEditor = new MimeTypeEditorComponent("text/javascript");
    protected MimeTypeEditorComponent globalOrcEditor = new MimeTypeEditorComponent("text/x-csound-orc");
    protected MimeTypeEditorComponent globalScoEditor = new MimeTypeEditorComponent("text/x-csound-sco");
    JavaScriptInstrument instr;
    EmbeddedOpcodeListPanel udoPanel = new EmbeddedOpcodeListPanel();
    UndoManager undo = new UndoRedo.Manager();
    private JLabel editorLabel;
    private JTabbedPane tabs;
    private JButton testButton;

    public JavaScriptInstrumentEditor() {
        this.initComponents();
        this.tabs.add("Instrument Text", (Component)this.codeEditor);
        this.tabs.add(BlueSystem.getString((String)"instrument.udo"), this.udoPanel);
        this.tabs.add("Global Orc", (Component)this.globalOrcEditor);
        this.tabs.add("Global Sco", (Component)this.globalScoEditor);
        this.tabs.setSelectedIndex(0);
        this.globalOrcEditor.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (JavaScriptInstrumentEditor.this.instr != null) {
                    JavaScriptInstrumentEditor.this.instr.setGlobalOrc(JavaScriptInstrumentEditor.this.globalOrcEditor.getText());
                }
            }
        });
        this.globalScoEditor.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (JavaScriptInstrumentEditor.this.instr != null) {
                    JavaScriptInstrumentEditor.this.instr.setGlobalSco(JavaScriptInstrumentEditor.this.globalScoEditor.getText());
                }
            }
        });
        this.codeEditor.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (JavaScriptInstrumentEditor.this.instr != null) {
                    JavaScriptInstrumentEditor.this.instr.setText(JavaScriptInstrumentEditor.this.codeEditor.getText());
                }
            }
        });
        new TabWatchingUndoableEditGenerator(this.tabs, this.undo);
        this.codeEditor.getDocument().addUndoableEditListener(this.undo);
        this.globalOrcEditor.getDocument().addUndoableEditListener(this.undo);
        this.globalScoEditor.getDocument().addUndoableEditListener(this.undo);
        this.codeEditor.setUndoManager(this.undo);
        this.globalOrcEditor.setUndoManager(this.undo);
        this.globalScoEditor.setUndoManager(this.undo);
        this.undo.setLimit(1000);
    }

    public final void editInstrument(Instrument instr) {
        if (instr == null) {
            this.instr = null;
            this.editorLabel.setText(BlueSystem.getString((String)"instrument.noEditorAvailable"));
            this.codeEditor.setText("Null Instrument");
            this.codeEditor.getJEditorPane().setEnabled(false);
            return;
        }
        if (!(instr instanceof JavaScriptInstrument)) {
            this.instr = null;
            this.editorLabel.setText(BlueSystem.getString((String)"instrument.noEditorAvailable"));
            this.codeEditor.setText("[ERROR] GenericEditor::editInstrument - not instance of GenericEditable");
            this.codeEditor.getJEditorPane().setEnabled(false);
            return;
        }
        this.instr = (JavaScriptInstrument)instr;
        this.codeEditor.setText(this.instr.getText());
        this.codeEditor.getJEditorPane().setEnabled(true);
        this.codeEditor.getJEditorPane().setCaretPosition(0);
        this.globalOrcEditor.setText(this.instr.getGlobalOrc());
        this.globalOrcEditor.getJEditorPane().setEnabled(true);
        this.globalOrcEditor.getJEditorPane().setCaretPosition(0);
        this.globalScoEditor.setText(this.instr.getGlobalSco());
        this.globalScoEditor.getJEditorPane().setEnabled(true);
        this.globalScoEditor.getJEditorPane().setCaretPosition(0);
        this.udoPanel.editOpcodeList(this.instr.getOpcodeList());
        this.undo.discardAllEdits();
    }

    private void initComponents() {
        this.editorLabel = new JLabel();
        this.testButton = new JButton();
        this.tabs = new JTabbedPane();
        this.editorLabel.setText("JavaScript Instrument");
        this.testButton.setText(BlueSystem.getString((String)"common.test"));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptInstrumentEditor.this.testButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabs, GroupLayout.Alignment.LEADING, -1, 430, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.editorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 225, Short.MAX_VALUE).addComponent(this.testButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testButton).addComponent(this.editorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabs, -1, 245, Short.MAX_VALUE).addContainerGap()));
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        if (this.instr == null) {
            return;
        }
        String instrumentText = this.instr.generateInstrument();
        InfoDialog.showInformationDialog(SwingUtilities.getRoot((Component)((Object)this)), instrumentText, BlueSystem.getString((String)"instrument.generatedInstrument"));
    }
}

