/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.gui.LabelledRangeBar;
import blue.gui.LabelledRangeLabelFilter;
import blue.orchestra.BlueX7;
import blue.orchestra.blueX7.AlgorithmCommonData;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.openide.util.ImageUtilities;

public class AlgorithmCommonPanel
extends JComponent {
    ImageIcon[] algoIcon = new ImageIcon[32];
    JLabel algorithmPicture;
    LabelledRangeBar keyTranspose = new LabelledRangeBar("Key Transpose ", 0, 48);
    LabelledRangeBar algorithm = new LabelledRangeBar("Algorithm ", 1, 32);
    LabelledRangeBar feedback = new LabelledRangeBar("Feedback ", 0, 7);
    JCheckBox[] operatorEnabled = new JCheckBox[6];
    BlueX7 blueX7;
    boolean isUpdatingData = false;

    public AlgorithmCommonPanel() {
        for (int i = 0; i < 32; ++i) {
            String num = Integer.toString(i + 1);
            if (i < 9) {
                num = "0" + num;
            }
            this.algoIcon[i] = new ImageIcon(ImageUtilities.loadImage((String)("blue/ui/core/images/blueX7/algo" + num + ".gif")));
        }
        this.algorithmPicture = new JLabel(this.algoIcon[0]);
        this.algorithm.addChangeListener(e -> this.algorithmPicture.setIcon(this.algoIcon[this.algorithm.getValue() - 1]));
        this.algorithmPicture.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        LabelledRangeLabelFilter transposeFilter = new LabelledRangeLabelFilter(){
            String[] KeyTransposeName = new String[]{"C1", "C#1", "D1", "D#1", "E1", "F1", "F#1", "G1", "G#1", "A1", "A#1", "B1", "C2", "C#2", "D2", "D#2", "E2", "F2", "F#2", "G2", "G#2", "A2", "A#2", "B2", "C3", "C#3", "D3", "D#3", "E3", "F3", "F#3", "G3", "G#3", "A3", "A#3", "B3", "C4", "C#4", "D4", "D#4", "E4", "F4", "F#4", "G4", "G#4", "A4", "A#4", "B4", "C5"};

            @Override
            public String filter(int val) {
                if (val < this.KeyTransposeName.length) {
                    return this.KeyTransposeName[val];
                }
                return "xxx";
            }
        };
        this.keyTranspose.setFilter(transposeFilter);
        this.keyTranspose.setValue(12);
        JPanel operatorBank = new JPanel(new FlowLayout(0));
        operatorBank.setAlignmentY(0.0f);
        for (int i = 0; i < 6; ++i) {
            this.operatorEnabled[i] = new JCheckBox(Integer.toString(i + 1));
            operatorBank.add(this.operatorEnabled[i]);
        }
        JPanel algorithmEditPanelTop = new JPanel(new GridLayout(5, 1));
        algorithmEditPanelTop.add(this.keyTranspose);
        algorithmEditPanelTop.add(this.algorithm);
        algorithmEditPanelTop.add(this.feedback);
        algorithmEditPanelTop.add(new JLabel("Operator on/off"));
        algorithmEditPanelTop.add(operatorBank);
        this.setBorder(BorderFactory.createTitledBorder("Common"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.algorithmPicture, "West");
        this.add((Component)algorithmEditPanelTop, "Center");
        ChangeListener cl = e -> this.checkData();
        this.keyTranspose.addChangeListener(cl);
        this.algorithm.addChangeListener(cl);
        this.feedback.addChangeListener(cl);
        ActionListener al = ae -> this.checkData();
        for (int i = 0; i < this.operatorEnabled.length; ++i) {
            this.operatorEnabled[i].addActionListener(al);
        }
    }

    private void checkData() {
        if (this.isUpdatingData) {
            return;
        }
        if (this.blueX7 == null) {
            return;
        }
        this.blueX7.algorithmCommon.keyTranspose = this.keyTranspose.getValue();
        this.blueX7.algorithmCommon.algorithm = this.algorithm.getValue();
        this.blueX7.algorithmCommon.feedback = this.feedback.getValue();
        for (int i = 0; i < this.operatorEnabled.length; ++i) {
            this.blueX7.algorithmCommon.operators[i] = this.operatorEnabled[i].isSelected();
        }
    }

    public void editBlueX7(BlueX7 blueX7) {
        this.isUpdatingData = true;
        this.blueX7 = blueX7;
        if (blueX7 == null) {
            return;
        }
        AlgorithmCommonData common = blueX7.algorithmCommon;
        this.keyTranspose.setValue(common.keyTranspose);
        this.algorithm.setValue(common.algorithm);
        this.feedback.setValue(common.feedback);
        for (int i = 0; i < this.operatorEnabled.length; ++i) {
            this.operatorEnabled[i].setSelected(common.operators[i]);
        }
        this.isUpdatingData = false;
    }

    public static void main(String[] args) {
        AlgorithmCommonPanel algorithmCommonPanel1 = new AlgorithmCommonPanel();
        GUI.showComponentAsStandalone((Component)algorithmCommonPanel1, (String)"AlgorithmCommonPanel Test", (boolean)true);
    }
}

