/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.gui.LabelledRangeBar;
import blue.gui.LabelledRangeLabelFilter;
import blue.orchestra.blueX7.Operator;
import blue.utility.GUI;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class KeyboardLevelScalingPanel
extends JComponent {
    LabelledRangeBar breakpoint = new LabelledRangeBar("Breakpoint ", 0, 99);
    JComboBox curveLeft;
    JComboBox curveRight;
    LabelledRangeBar depthLeft = new LabelledRangeBar("Depth Left ", 0, 99);
    LabelledRangeBar depthRight = new LabelledRangeBar("Depth Right ", 0, 99);
    LabelledRangeBar keybardRateScaling = new LabelledRangeBar("Keyboard Rate Scaling ", 0, 7);
    Operator op;
    boolean isUpdatingData = false;

    public KeyboardLevelScalingPanel() {
        LabelledRangeLabelFilter filter = new LabelledRangeLabelFilter(){
            String[] KbdBreakPointName = new String[]{"A-1", "A#-1", "B-1", "C0", "C#0", "D0", "D#0", "E0", "F0", "F#0", "G0", "G#0", "A0", "A#0", "B0", "C1", "C#1", "D1", "D#1", "E1", "F1", "F#1", "G1", "G#1", "A1", "A#1", "B1", "C2", "C#2", "D2", "D#2", "E2", "F2", "F#2", "G2", "G#2", "A2", "A#2", "B2", "C3", "C#3", "D3", "D#3", "E3", "F3", "F#3", "G3", "G#3", "A3", "A#3", "B3", "C4", "C#4", "D4", "D#4", "E4", "F4", "F#4", "G4", "G#4", "A4", "A#4", "B4", "C5", "C#5", "D5", "D#5", "E5", "F5", "F#5", "G5", "G#5", "A5", "A#5", "B5", "C6", "C#6", "D6", "D#6", "E6", "F6", "F#6", "G6", "G#6", "A6", "A#6", "B6", "C7", "C#7", "D7", "D#7", "E7", "F7", "F#7", "G7", "G#7", "A7", "A#7", "B7", "C8"};

            @Override
            public String filter(int val) {
                if (val < this.KbdBreakPointName.length) {
                    return this.KbdBreakPointName[val];
                }
                return "xxx";
            }
        };
        this.breakpoint.setFilter(filter);
        Vector<String> items = new Vector<String>(4);
        items.add("-Lin");
        items.add("-Exp");
        items.add("+Exp");
        items.add("+Lin");
        this.curveLeft = new JComboBox(items);
        this.curveRight = new JComboBox(items);
        JPanel curvePanel = new JPanel();
        curvePanel.add(new JLabel("Curve Left "));
        curvePanel.add(this.curveLeft);
        curvePanel.add(new JLabel(" Curve Right "));
        curvePanel.add(this.curveRight);
        this.setLayout(new GridLayout(6, 1));
        this.add(new JLabel("[ Keyboard Level Scaling ]"));
        this.add(this.breakpoint);
        this.add(curvePanel);
        this.add(this.depthLeft);
        this.add(this.depthRight);
        this.add(this.keybardRateScaling);
        ChangeListener cl = e -> this.checkData();
        this.breakpoint.addChangeListener(cl);
        this.depthLeft.addChangeListener(cl);
        this.depthRight.addChangeListener(cl);
        this.keybardRateScaling.addChangeListener(cl);
        ActionListener al = ae -> this.checkData();
        this.curveLeft.addActionListener(al);
        this.curveRight.addActionListener(al);
    }

    public void checkData() {
        if (this.isUpdatingData) {
            return;
        }
        if (this.op == null) {
            return;
        }
        this.op.breakpoint = this.breakpoint.getValue();
        this.op.curveLeft = this.curveLeft.getSelectedIndex();
        this.op.curveRight = this.curveRight.getSelectedIndex();
        this.op.depthLeft = this.depthLeft.getValue();
        this.op.depthRight = this.depthRight.getValue();
        this.op.keyboardRateScaling = this.keybardRateScaling.getValue();
    }

    public void editOperator(Operator op) {
        this.isUpdatingData = true;
        this.op = op;
        if (op == null) {
            this.isUpdatingData = false;
            return;
        }
        this.breakpoint.setValue(op.breakpoint);
        this.curveLeft.setSelectedIndex(op.curveLeft);
        this.curveRight.setSelectedIndex(op.curveRight);
        this.depthLeft.setValue(op.depthLeft);
        this.depthRight.setValue(op.depthRight);
        this.keybardRateScaling.setValue(op.keyboardRateScaling);
        this.isUpdatingData = false;
    }

    public static void main(String[] args) {
        KeyboardLevelScalingPanel keyboardLevelScalingPanel1 = new KeyboardLevelScalingPanel();
        GUI.showComponentAsStandalone((Component)keyboardLevelScalingPanel1, (String)"KeyboardLevelScalingPanel Test", (boolean)true);
    }
}

