/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.gui.LabelledRangeBar;
import blue.orchestra.BlueX7;
import blue.orchestra.blueX7.LFOData;
import blue.utility.GUI;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class LFOPanel
extends JComponent {
    LabelledRangeBar speed = new LabelledRangeBar("Speed ", 0, 99);
    LabelledRangeBar delay = new LabelledRangeBar("Delay ", 0, 99);
    LabelledRangeBar pmd = new LabelledRangeBar("PMD ", 0, 99);
    LabelledRangeBar amd = new LabelledRangeBar("AMD ", 0, 99);
    JComboBox wave;
    JComboBox sync;
    BlueX7 blueX7;
    boolean isUpdatingData = false;

    public LFOPanel() {
        this.setBorder(BorderFactory.createTitledBorder("LFO"));
        this.setLayout(new GridLayout(5, 1));
        this.add(this.speed);
        this.add(this.delay);
        this.add(this.pmd);
        this.add(this.amd);
        Vector<String> items = new Vector<String>();
        items.add("Triangle");
        items.add("Saw Down");
        items.add("Saw Up");
        items.add("Square");
        items.add("Sine");
        items.add("S/Hold");
        this.wave = new JComboBox(items);
        items = new Vector();
        items.add("Off");
        items.add("On");
        this.sync = new JComboBox(items);
        JPanel temp = new JPanel();
        temp.add(new JLabel("Wave "));
        temp.add(this.wave);
        temp.add(new JLabel("Sync "));
        temp.add(this.sync);
        this.add(temp);
        ChangeListener cl = e -> this.checkData();
        this.speed.addChangeListener(cl);
        this.delay.addChangeListener(cl);
        this.amd.addChangeListener(cl);
        this.pmd.addChangeListener(cl);
        ActionListener al = ae -> this.checkData();
        this.wave.addActionListener(al);
        this.sync.addActionListener(al);
    }

    public void checkData() {
        if (this.isUpdatingData) {
            return;
        }
        if (this.blueX7 == null) {
            return;
        }
        this.blueX7.lfo.speed = this.speed.getValue();
        this.blueX7.lfo.delay = this.delay.getValue();
        this.blueX7.lfo.AMD = this.amd.getValue();
        this.blueX7.lfo.PMD = this.pmd.getValue();
        this.blueX7.lfo.wave = this.wave.getSelectedIndex();
        this.blueX7.lfo.sync = this.sync.getSelectedIndex();
    }

    public void editBlueX7(BlueX7 blueX7) {
        this.isUpdatingData = true;
        this.blueX7 = blueX7;
        if (blueX7 == null) {
            return;
        }
        LFOData lfo = blueX7.lfo;
        this.speed.setValue(lfo.speed);
        this.delay.setValue(lfo.delay);
        this.amd.setValue(lfo.AMD);
        this.pmd.setValue(lfo.PMD);
        this.wave.setSelectedIndex(lfo.wave);
        this.sync.setSelectedIndex(lfo.sync);
        this.isUpdatingData = false;
    }

    public static void main(String[] args) {
        LFOPanel LFOPanel1 = new LFOPanel();
        GUI.showComponentAsStandalone((Component)LFOPanel1, (String)"LFO Panel Test", (boolean)true);
    }
}

