/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.gui.LabelledRangeBar;
import blue.orchestra.blueX7.Operator;
import blue.utility.GUI;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;

public class OperatorEditPanel
extends JComponent {
    LabelledRangeBar outputLevel = new LabelledRangeBar("Output Level ", 0, 99);
    LabelledRangeBar velocitySensitivity = new LabelledRangeBar("Velocity Sensitivity ", 0, 7);
    Operator op;
    boolean isUpdatingData = false;

    public OperatorEditPanel() {
        this.setLayout(new GridLayout(3, 1));
        this.add(new JLabel("[ Operator ]"));
        this.add(this.outputLevel);
        this.add(this.velocitySensitivity);
        ChangeListener cl = e -> this.checkData();
        this.outputLevel.addChangeListener(cl);
        this.velocitySensitivity.addChangeListener(cl);
    }

    public void checkData() {
        if (this.isUpdatingData) {
            return;
        }
        if (this.op == null) {
            return;
        }
        this.op.outputLevel = this.outputLevel.getValue();
        this.op.velocitySensitivity = this.velocitySensitivity.getValue();
    }

    public void editOperator(Operator op) {
        this.isUpdatingData = true;
        this.op = op;
        if (op == null) {
            return;
        }
        this.outputLevel.setValue(op.outputLevel);
        this.velocitySensitivity.setValue(op.velocitySensitivity);
        this.isUpdatingData = false;
    }

    public static void main(String[] args) {
        OperatorEditPanel operatorEditPanel1 = new OperatorEditPanel();
        GUI.showComponentAsStandalone((Component)operatorEditPanel1, (String)"Operator Edit Panel Test", (boolean)true);
    }
}

