/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.render;

import blue.Arrangement;
import blue.BlueConstants;
import blue.BlueData;
import blue.CompileData;
import blue.GlobalOrcSco;
import blue.InstrumentAssignment;
import blue.ProjectProperties;
import blue.Tables;
import blue.automation.Automatable;
import blue.automation.Parameter;
import blue.automation.ParameterNameManager;
import blue.components.lines.Line;
import blue.components.lines.LinePoint;
import blue.components.lines.SoundObjectParameterLine;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.Mixer;
import blue.noteProcessor.TempoMapper;
import blue.orchestra.GenericInstrument;
import blue.orchestra.Instrument;
import blue.orchestra.blueSynthBuilder.StringChannel;
import blue.orchestra.blueSynthBuilder.StringChannelNameManager;
import blue.score.ScoreGenerationException;
import blue.score.tempo.Tempo;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import blue.settings.PlaybackSettings;
import blue.soundObject.GenericScore;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.udo.OpcodeList;
import blue.ui.core.project.ProjectPluginManager;
import blue.ui.core.render.CommandProcessor;
import blue.ui.core.render.ParameterHelper;
import blue.utility.NumberUtilities;
import blue.utility.ScoreUtilities;
import blue.utility.TextUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class CSDRender
extends CSDRenderService {
    private final MessageFormat PARAM_VAR_NAME = new MessageFormat("gk_blue_auto{0}");

    protected synchronized CsdRenderResult generateCSDForBlueLiveImpl(BlueData data, boolean usingAPI) {
        ProjectPluginManager.getInstance().preRender(data);
        StringChannelNameManager scnm = new StringChannelNameManager();
        ArrayList<StringChannel> stringChannels = this.getStringChannels(data.getArrangement(), scnm);
        ParameterHelper.clearCompilationVarNames(data);
        double totalDur = 36000.0;
        Tables tables = new Tables(data.getTableSet());
        ArrayList<Parameter> originalParameters = null;
        if (usingAPI) {
            originalParameters = ParameterHelper.getAllParameters(data.getArrangement(), data.getMixer());
            this.assignParameterNames(originalParameters, new ParameterNameManager());
        }
        Arrangement arrangement = new Arrangement(data.getArrangement());
        arrangement.clearUnusedInstrAssignments();
        String[] instrIds = arrangement.getInstrumentIds();
        boolean hasInstruments = arrangement.size() > 0;
        GlobalOrcSco globalOrcSco = new GlobalOrcSco(data.getGlobalOrcSco());
        OpcodeList udos = new OpcodeList(data.getOpcodeList());
        arrangement.generateUserDefinedOpcodes(udos);
        this.appendFtgenTableNumbers(globalOrcSco.getGlobalOrc(), tables);
        arrangement.generateFTables(tables);
        CompileData compileData = new CompileData(arrangement, tables);
        boolean mixerEnabled = data.getMixer().isEnabled();
        Mixer mixer = null;
        if (mixerEnabled) {
            mixer = new Mixer(data.getMixer());
            this.assignChannelIds(compileData, mixer);
        }
        boolean generateMixer = mixerEnabled && (hasInstruments || mixer.hasSubChannelDependencies());
        int nchnls = this.getNchnls(data, true);
        ArrayList alwaysOnInstruments = new ArrayList();
        arrangement.preGenerateOrchestra(compileData, mixer, nchnls, alwaysOnInstruments);
        String globalSco = globalOrcSco.getGlobalSco() + "\n";
        globalSco = globalSco + arrangement.generateGlobalSco(compileData) + "\n";
        globalSco = this.preprocessSco(globalSco, totalDur, 0.0, 0.0, null);
        NoteList generatedNotes = null;
        for (Instrument instrument : alwaysOnInstruments) {
            int instrId = arrangement.addInstrumentAtEnd(instrument);
            globalSco = globalSco + "i" + instrId + " 0 " + totalDur + "\n";
        }
        if (usingAPI) {
            generatedNotes = new NoteList();
            this.handleParametersForBlueLive(originalParameters, stringChannels, globalOrcSco, generatedNotes, arrangement, usingAPI);
        }
        if (generateMixer) {
            this.clearUnusedMixerChannels(mixer, arrangement);
            globalOrcSco.appendGlobalOrc(mixer.getInitStatements(compileData, nchnls));
            int instrId = arrangement.addInstrumentAtEnd((Instrument)mixer.getMixerInstrument(compileData, udos, nchnls));
            globalSco = globalSco + "i" + instrId + " 0 " + totalDur;
        }
        arrangement.addInstrument("blueAllNotesOff", this.createAllNotesOffInstrument(instrIds));
        String ftables = tables.getTables();
        StrBuilder score = new StrBuilder();
        score.append("<CsoundSynthesizer>\n\n");
        this.appendCsInstruments(compileData, data, udos, arrangement, globalOrcSco, score, mixer, true);
        this.appendCsScore(globalSco, ftables, generatedNotes, totalDur, score);
        score.append("</CsoundSynthesizer>");
        TempoMapper tempoMapper = null;
        CsdRenderResult renderResult = new CsdRenderResult(score.toString(), tempoMapper, originalParameters, stringChannels);
        return renderResult;
    }

    protected CsdRenderResult generateCSDImpl(BlueData data, double startTime, double endTime, boolean isRealTime, boolean _usingAPI) {
        String tempGlobalOrc;
        double globalDur;
        NoteList generatedNotes;
        ProjectPluginManager.getInstance().preRender(data);
        StringChannelNameManager scnm = new StringChannelNameManager();
        ParameterNameManager pnm = new ParameterNameManager();
        ArrayList<StringChannel> stringChannels = this.getStringChannels(data.getArrangement(), scnm);
        ParameterHelper.clearCompilationVarNames(data);
        boolean usingAPI = isRealTime && _usingAPI;
        double renderStartTime = data.getRenderStartTime();
        Tables tables = new Tables(data.getTableSet());
        ArrayList<Parameter> originalParameters = ParameterHelper.getAllParameters(data.getArrangement(), data.getMixer());
        this.assignParameterNames(originalParameters, pnm);
        Arrangement arrangement = new Arrangement(data.getArrangement());
        arrangement.clearUnusedInstrAssignments();
        boolean hasInstruments = arrangement.size() > 0;
        CompileData compileData = new CompileData(arrangement, tables, stringChannels, originalParameters, scnm, pnm);
        Mixer mixer = null;
        boolean mixerEnabled = data.getMixer().isEnabled();
        if (mixerEnabled) {
            mixer = new Mixer(data.getMixer());
            this.assignChannelIds(compileData, mixer);
        }
        try {
            generatedNotes = data.getScore().generateForCSD(compileData, startTime, endTime);
        }
        catch (ScoreGenerationException ex) {
            throw new RuntimeException(ex);
        }
        compileData.setHandleParametersAndChannels(false);
        GlobalOrcSco globalOrcSco = new GlobalOrcSco(data.getGlobalOrcSco());
        OpcodeList udos = new OpcodeList(data.getOpcodeList());
        arrangement.generateUserDefinedOpcodes(udos);
        this.appendFtgenTableNumbers(globalOrcSco.getGlobalOrc(), tables);
        arrangement.generateFTables(tables);
        String ftables = tables.getTables();
        if (endTime > 0.0 && endTime > startTime) {
            Instrument instr = this.createRenderEndInstrument();
            int instrId = arrangement.addInstrument(instr);
            double endStartTime = endTime - startTime;
            try {
                Note renderEndNote = Note.createNote((String)("i" + instrId + " " + endStartTime + " 0.1"));
                generatedNotes.add((Object)renderEndNote);
            }
            catch (NoteParseException renderEndNote) {
                // empty catch block
            }
        }
        Tempo tempo = data.getScore().getTempo();
        TempoMapper tempoMapper = null;
        if (tempo.isEnabled()) {
            tempoMapper = this.getTempoMapper(tempo);
            globalOrcSco.appendGlobalSco(this.getTempoScore(tempo, renderStartTime, endTime));
        } else {
            tempoMapper = this.getTempoMapper(globalOrcSco.getGlobalSco());
        }
        double totalDur = ScoreUtilities.getTotalDuration((NoteList)generatedNotes);
        double processingStart = renderStartTime;
        System.out.println("<TOTAL_DUR> = " + totalDur);
        System.out.println("<RENDER_START> = " + renderStartTime);
        System.out.println("<PROCESSING_START> = " + processingStart);
        int nchnls = this.getNchnls(data, isRealTime);
        ArrayList alwaysOnInstruments = new ArrayList();
        arrangement.preGenerateOrchestra(compileData, mixer, nchnls, alwaysOnInstruments);
        String globalSco = globalOrcSco.getGlobalSco() + "\n";
        globalSco = globalSco + arrangement.generateGlobalSco(compileData) + "\n";
        globalSco = this.preprocessSco(globalSco, totalDur, renderStartTime, processingStart, tempoMapper);
        try {
            globalDur = this.getGlobalDuration(globalSco);
        }
        catch (SoundObjectException ex) {
            throw new RuntimeException(ex);
        }
        if (globalDur < totalDur) {
            globalDur = totalDur;
        }
        System.out.println("Global Duration = " + globalDur);
        if (mixerEnabled) {
            globalDur += mixer.getExtraRenderTime();
        }
        for (Instrument instrument : alwaysOnInstruments) {
            int instrId = arrangement.addInstrumentAtEnd(instrument);
            try {
                Note n = Note.createNote((String)("i" + instrId + " 0 " + globalDur));
                generatedNotes.add((Object)n);
            }
            catch (NoteParseException ex) {
                ex.printStackTrace();
            }
        }
        if (mixerEnabled) {
            this.clearUnusedMixerChannels(mixer, arrangement);
            globalOrcSco.appendGlobalOrc(mixer.getInitStatements(compileData, nchnls) + "\n");
            int instrId = arrangement.addInstrumentAtEnd((Instrument)mixer.getMixerInstrument(compileData, udos, nchnls));
            try {
                Note n = Note.createNote((String)("i" + instrId + " 0 " + globalDur));
                generatedNotes.add((Object)n);
            }
            catch (NoteParseException ex) {
                ex.printStackTrace();
            }
        }
        this.handleParameters(originalParameters, stringChannels, globalOrcSco, generatedNotes, arrangement, startTime, startTime + globalDur, isRealTime, _usingAPI);
        if (isRealTime && !usingAPI) {
            Instrument instr = this.createBlueTimePointerInstrument();
            int instrId = arrangement.addInstrument(instr);
            try {
                Note n = Note.createNote((String)("i" + instrId + " 0 " + globalDur));
                generatedNotes.add((Object)n);
            }
            catch (NoteParseException ex) {
                ex.printStackTrace();
            }
        }
        if ((tempGlobalOrc = compileData.getGlobalOrc()) != null && tempGlobalOrc.length() > 0) {
            globalOrcSco.appendGlobalOrc(tempGlobalOrc);
        }
        StrBuilder csd = new StrBuilder();
        this.appendProjectInfo(data, csd);
        csd.append("<CsoundSynthesizer>\n\n");
        this.appendCsInstruments(compileData, data, udos, arrangement, globalOrcSco, csd, mixer, isRealTime);
        this.appendCsScore(globalSco, ftables, generatedNotes, totalDur, csd);
        csd.append("</CsoundSynthesizer>");
        CsdRenderResult renderResult = new CsdRenderResult(csd.toString(), tempoMapper, originalParameters, stringChannels);
        return renderResult;
    }

    private ArrayList<StringChannel> getStringChannels(Arrangement arrangement, StringChannelNameManager scnm) {
        ArrayList<StringChannel> params = new ArrayList<StringChannel>();
        for (int i = 0; i < arrangement.size(); ++i) {
            Automatable auto;
            ArrayList stringChannels;
            Instrument instr;
            InstrumentAssignment ia = arrangement.getInstrumentAssignment(i);
            if (!ia.enabled || !((instr = ia.instr) instanceof Automatable) || (stringChannels = (auto = (Automatable)instr).getStringChannels()) == null) continue;
            params.addAll(stringChannels);
        }
        for (StringChannel strChannel : params) {
            strChannel.setChannelName(scnm.getUniqueStringChannel());
        }
        return params;
    }

    private void clearUnusedMixerChannels(Mixer mixer, Arrangement arrangement) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < arrangement.getRowCount(); ++i) {
            InstrumentAssignment ia = arrangement.getInstrumentAssignment(i);
            ids.add(ia.arrangementId);
        }
        ChannelList channelList = mixer.getChannels();
        channelList.clearChannelsNotInList(ids);
    }

    private void appendFtgenTableNumbers(String globalOrc, Tables tables) {
        Pattern p = Pattern.compile("ftgen\\s+-?(\\d+)");
        Matcher m = p.matcher(globalOrc);
        while (m.find()) {
            int ftgenNum = Integer.parseInt(m.group(1));
            if (ftgenNum == 0) continue;
            tables.addFtgenNumber(ftgenNum);
        }
    }

    private void createParamNote(StrBuilder paramScore, int instrId, double startTime, double dur, double startVal, double endVal) {
        paramScore.append("i");
        paramScore.append(instrId).append("\t");
        paramScore.append(NumberUtilities.formatDouble((double)startTime)).append("\t");
        paramScore.append(NumberUtilities.formatDouble((double)dur)).append("\t");
        paramScore.append(NumberUtilities.formatDouble((double)startVal)).append("\t");
        paramScore.append(NumberUtilities.formatDouble((double)endVal)).append("\n");
    }

    private double getGlobalDuration(String globalSco) throws SoundObjectException {
        NoteList globalNotes;
        try {
            globalNotes = ScoreUtilities.getNotes((String)globalSco);
        }
        catch (NoteParseException e) {
            GenericScore gs = new GenericScore();
            gs.setName("Global Orchestra Text");
            throw new SoundObjectException((SoundObject)gs, (Throwable)e);
        }
        double globalDur = ScoreUtilities.getTotalDuration((NoteList)globalNotes);
        return globalDur;
    }

    private int getNchnls(BlueData data, boolean isRealtime) {
        int nchnls = 2;
        try {
            ProjectProperties props = data.getProjectProperties();
            nchnls = isRealtime ? Integer.parseInt(props.channels.trim()) : Integer.parseInt(props.diskChannels.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return nchnls;
    }

    private Instrument createRenderEndInstrument() {
        GenericInstrument instr = new GenericInstrument();
        String instrText = "event \"e\", 0, 0, 0.1";
        instr.setText(instrText);
        return instr;
    }

    private Instrument createBlueTimePointerInstrument() {
        GenericInstrument instr = new GenericInstrument();
        int fps = PlaybackSettings.getInstance().getPlaybackFPS();
        double time = 1.0f / (float)fps;
        String instrText = "ktime\ttimes\nprintks \"blueTimePointer=%f\\\\n\", " + time + ", ktime";
        instr.setText(instrText);
        return instr;
    }

    protected Instrument createAllNotesOffInstrument(String[] instrIds) {
        GenericInstrument instr = new GenericInstrument();
        StrBuilder buffer = new StrBuilder();
        buffer.append("koff init 0\nif (koff == 0) then\n");
        for (int i = 0; i < instrIds.length; ++i) {
            String id = instrIds[i];
            String[] parts = StringUtils.split((String)id, (String)",");
            for (int j = 0; j < parts.length; ++j) {
                String tempId = parts[j];
                try {
                    int instrIdNum = Integer.parseInt(tempId.trim());
                    buffer.append("turnoff2 ").append(instrIdNum);
                    buffer.append(", 0, 1\n");
                    continue;
                }
                catch (NumberFormatException nfe) {
                    buffer.append("insno").append(i).append(j);
                    buffer.append(" nstrnum \"").append(tempId).append("\"\n");
                    buffer.append("turnoff2 insno").append(i).append(j);
                    buffer.append(", 0, 1\n");
                }
            }
        }
        buffer.append("koff = 1\nelse\nturnoff\nendif\n");
        instr.setText(buffer.toString());
        return instr;
    }

    private void appendProjectInfo(BlueData data, StrBuilder score) {
        ProjectProperties props = data.getProjectProperties();
        String notes = props.notes.replaceAll("\n", "\n; ");
        score.append(";\n");
        score.append("; \"").append(props.title).append("\"\n");
        score.append("; by ").append(props.author).append("\n");
        score.append(";\n");
        score.append("; ").append(notes).append("\n");
        score.append(";\n");
        score.append("; Generated by blue ").append(BlueConstants.getVersion()).append(" (http://blue.kunstmusik.com)\n");
        score.append(";\n\n");
    }

    private void appendCsScore(String globalSco, String ftables, NoteList generatedNotes, double totalDur, StrBuilder score) {
        score.append("<CsScore>\n\n");
        score.append(ftables).append("\n");
        score.append("\n");
        score.append(globalSco).append("\n\n");
        if (generatedNotes != null) {
            score.append(generatedNotes.toString()).append("\n");
        } else {
            score.append("f0 ").append(totalDur).append("\n");
        }
        score.append("e\n\n");
        score.append("</CsScore>\n\n");
    }

    private void appendCsInstruments(CompileData compileData, BlueData data, OpcodeList udos, Arrangement arrangement, GlobalOrcSco globalOrcSco, StrBuilder score, Mixer mixer, boolean isRealTime) {
        ProjectProperties projProps = data.getProjectProperties();
        score.append("<CsInstruments>\n");
        int nchnls = 2;
        if (isRealTime) {
            try {
                nchnls = Integer.parseInt(projProps.channels.trim());
            }
            catch (NumberFormatException nfe) {
                System.err.println("Could not parse nchnls: defaulting to 2");
            }
            score.append("sr=").append(projProps.sampleRate).append("\n");
            score.append("ksmps=").append(projProps.getKsmps()).append("\n");
            score.append("nchnls=").append(nchnls).append("\n");
            if (projProps.useZeroDbFS) {
                score.append("0dbfs=").append(projProps.zeroDbFS).append("\n");
            }
        } else {
            try {
                nchnls = Integer.parseInt(projProps.diskChannels.trim());
            }
            catch (NumberFormatException nfe) {
                System.err.println("Could not parse nchnls: defaulting to 2");
            }
            score.append("sr=").append(projProps.diskSampleRate).append("\n");
            score.append("ksmps=").append(projProps.diskKsmps).append("\n");
            score.append("nchnls=").append(nchnls).append("\n");
            if (projProps.diskUseZeroDbFS) {
                score.append("0dbfs=").append(projProps.diskZeroDbFS).append("\n");
            }
        }
        score.append("\n");
        score.append(globalOrcSco.getGlobalOrc()).append("\n");
        score.append("\n");
        score.append(CommandProcessor.processCommandBlocks(arrangement.generateGlobalOrc(compileData))).append("\n");
        score.append("\n");
        score.append(udos.toString()).append("\n");
        score.append("\n");
        score.append(arrangement.generateOrchestra(compileData, mixer, nchnls));
        score.append("\n");
        score.append("</CsInstruments>\n\n");
    }

    private String preprocessSco(String in, double totalDur, double renderStartTime, double processingStart, TempoMapper tempoMapper) {
        String temp = TextUtilities.replaceAll((String)in, (String)"<TOTAL_DUR>", (String)Double.toString(totalDur));
        temp = TextUtilities.replaceAll((String)temp, (String)"<PROCESSING_START>", (String)Double.toString(processingStart));
        temp = TextUtilities.replaceAll((String)temp, (String)"<RENDER_START>", (String)Double.toString(renderStartTime));
        TempoMapper localTempoMapper = tempoMapper;
        if (localTempoMapper == null) {
            localTempoMapper = this.getTempoMapper(in);
        }
        temp = tempoMapper != null ? TextUtilities.replaceAll((String)temp, (String)"<RENDER_START_ABSOLUTE>", (String)Double.toString(tempoMapper.beatsToSeconds(renderStartTime))) : TextUtilities.replaceAll((String)temp, (String)"<RENDER_START_ABSOLUTE>", (String)Double.toString(renderStartTime));
        return temp;
    }

    private GenericInstrument getParameterInstrument(Parameter param) {
        GenericInstrument instr = new GenericInstrument();
        instr.setName("Param: " + param.getName());
        StrBuilder buffer = new StrBuilder();
        String compilationVarName = param.getCompilationVarName();
        if (param.getResolution().doubleValue() > 0.0) {
            buffer.append(compilationVarName);
            buffer.append(" init p4\nturnoff");
        } else {
            buffer.append("if (p4 == p5) then\n");
            buffer.append(compilationVarName);
            buffer.append(" init p4\nturnoff\nelse\n");
            buffer.append(compilationVarName);
            buffer.append(" line p4, p3, p5\nendif");
        }
        instr.setText(buffer.toString());
        return instr;
    }

    private void appendParameterScore(Parameter param, int instrId, StrBuilder paramScore, double renderStart, double renderEnd) {
        Line line = param.getLine();
        if (line.size() < 2) {
            return;
        }
        double resolution = param.getResolution().doubleValue();
        double startAdj = 0.0;
        double durationAdj = 1.0;
        boolean adjustPoints = line instanceof SoundObjectParameterLine;
        if (adjustPoints) {
            SoundObjectParameterLine paramLine = (SoundObjectParameterLine)line;
            startAdj = paramLine.getSourceStart();
            durationAdj = paramLine.getSourceDuration();
        }
        if (resolution > 0.0) {
            for (int i = 1; i < line.size(); ++i) {
                LinePoint p1 = line.getLinePoint(i - 1);
                LinePoint p2 = line.getLinePoint(i);
                double startTime = p1.getX();
                double endTime = p2.getX();
                if (adjustPoints) {
                    startTime = startTime * durationAdj + startAdj;
                    endTime = endTime * durationAdj + startAdj;
                }
                if (renderEnd > 0.0 && startTime >= renderEnd) {
                    return;
                }
                if (endTime <= renderStart) continue;
                double startVal = p1.getY();
                double endVal = p2.getY();
                if (startTime == endTime) {
                    if (i != line.size() - 1) continue;
                    this.createParamNote(paramScore, instrId, endTime, 1.0E-4f, p2.getY(), p2.getY());
                    continue;
                }
                if (startVal == endVal) continue;
                double dur = endTime - startTime;
                double currentVal = startVal;
                int numSteps = (int)Math.abs(Math.round((endVal - startVal) / resolution));
                double step = dur / (double)numSteps;
                double start = startTime;
                double valStep = resolution;
                if (endVal < startVal) {
                    valStep = -valStep;
                }
                for (int j = 0; j < numSteps - 1; ++j) {
                    currentVal += valStep;
                    if ((start += step) <= renderStart) continue;
                    if (renderEnd > 0.0 && start >= renderEnd) {
                        return;
                    }
                    paramScore.append("i");
                    paramScore.append(instrId).append("\t");
                    paramScore.append(NumberUtilities.formatDouble((double)(start - renderStart))).append("\t");
                    paramScore.append(".0001\t");
                    paramScore.append(NumberUtilities.formatDouble((double)currentVal)).append("\n");
                }
                start += step;
                if (renderEnd > 0.0 && start >= renderEnd) {
                    return;
                }
                paramScore.append("i");
                paramScore.append(instrId).append("\t");
                paramScore.append(NumberUtilities.formatDouble((double)(start - renderStart))).append("\t");
                paramScore.append(".0001\t");
                paramScore.append(NumberUtilities.formatDouble((double)endVal)).append("\n");
            }
        } else {
            double lastValue = line.getLinePoint(0).getY();
            for (int i = 1; i < line.size(); ++i) {
                LinePoint p1 = line.getLinePoint(i - 1);
                LinePoint p2 = line.getLinePoint(i);
                double startTime = p1.getX();
                double endTime = p2.getX();
                if (adjustPoints) {
                    startTime = startTime * durationAdj + startAdj;
                    endTime = endTime * durationAdj + startAdj;
                }
                if (renderEnd > 0.0 && startTime >= renderEnd) {
                    return;
                }
                if (endTime <= renderStart) {
                    lastValue = p2.getY();
                    continue;
                }
                if (p1.getX() == p2.getX()) {
                    if (i != line.size() - 1) continue;
                    this.createParamNote(paramScore, instrId, p2.getX(), 1.0E-4f, p2.getY(), p2.getY());
                    continue;
                }
                double startVal = p1.getY();
                double endVal = p2.getY();
                if (startTime < renderStart) {
                    startVal = line.getValue(renderStart);
                    startTime = renderStart;
                }
                if (renderEnd > 0.0 && endTime > renderEnd) {
                    endVal = line.getValue(renderEnd);
                    endTime = renderEnd;
                }
                lastValue = endVal;
                double dur = p1.getY() == p2.getY() ? (double)1.0E-4f : endTime - startTime;
                this.createParamNote(paramScore, instrId, startTime -= renderStart, dur, startVal, endVal);
                if (i != line.size() - 1) continue;
                this.createParamNote(paramScore, instrId, startTime + dur, 1.0E-4f, endVal, endVal);
            }
        }
    }

    protected String getTempoScore(Tempo tempo, double renderStart, double renderEnd) {
        Line line = tempo.getLine();
        if (line.size() == 1) {
            return "t 0 " + line.getLinePoint(0).getY();
        }
        if (renderStart > line.getLinePoint(line.size() - 1).getX()) {
            return "t 0 " + line.getLinePoint(line.size() - 1).getY();
        }
        StrBuilder buffer = new StrBuilder();
        buffer.append("t 0 ").append(line.getValue(renderStart));
        for (int i = 0; i < line.size(); ++i) {
            LinePoint lp = line.getLinePoint(i);
            double pointBeat = lp.getX();
            if (!(pointBeat > renderStart)) continue;
            if (!(renderEnd < 0.0) && !(pointBeat < renderEnd)) break;
            buffer.append(" ").append(pointBeat - renderStart);
            buffer.append(" ").append(lp.getY());
        }
        if (renderEnd > 0.0) {
            buffer.append(" ").append(renderEnd - renderStart);
            buffer.append(" ").append(line.getValue(renderEnd));
        }
        buffer.append("\n");
        return buffer.toString();
    }

    private void assignParameterNames(ArrayList parameters, ParameterNameManager pnm) {
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter param = (Parameter)parameters.get(i);
            param.setCompilationVarName(pnm.getUniqueParamName());
        }
    }

    private void handleParameters(ArrayList parameters, ArrayList<StringChannel> stringChannels, GlobalOrcSco globalOrcSco, NoteList notes, Arrangement arrangement, double startTime, double endTime, boolean isRealTime, boolean _usingAPI) {
        String varName;
        Object[] varNum = new Object[1];
        StrBuilder initStatements = new StrBuilder();
        StrBuilder paramScore = new StrBuilder();
        boolean useAPI = isRealTime && _usingAPI;
        for (StringChannel strChannel : stringChannels) {
            varName = strChannel.getChannelName();
            initStatements.append(varName);
            initStatements.append(" = ");
            initStatements.append("\"").append(strChannel.getValue()).append("\"\n");
            if (!useAPI) continue;
            initStatements.append(varName).append(" chnexport \"");
            initStatements.append(varName).append("\", 3\n");
        }
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter param = (Parameter)parameters.get(i);
            varNum[0] = new Integer(i);
            varName = param.getCompilationVarName();
            double initialVal = param.isAutomationEnabled() ? param.getLine().getValue(startTime) : param.getFixedValue();
            initStatements.append(varName);
            initStatements.append(" init ");
            initStatements.append(NumberUtilities.formatDouble((double)initialVal));
            initStatements.append("\n");
            if (useAPI) {
                initStatements.append(varName).append(" chnexport \"");
                initStatements.append(varName).append("\", 3\n");
                continue;
            }
            if (!param.isAutomationEnabled()) continue;
            GenericInstrument instr = this.getParameterInstrument(param);
            int instrId = arrangement.addInstrumentAtEnd((Instrument)instr);
            this.appendParameterScore(param, instrId, paramScore, startTime, endTime);
        }
        globalOrcSco.appendGlobalOrc(initStatements.toString());
        try {
            notes.addAll((Collection)ScoreUtilities.getNotes((String)paramScore.toString()));
        }
        catch (NoteParseException ex) {
            ex.printStackTrace();
        }
    }

    private void handleParametersForBlueLive(ArrayList parameters, ArrayList<StringChannel> stringChannels, GlobalOrcSco globalOrcSco, NoteList notes, Arrangement arrangement, boolean useAPI) {
        String varName;
        Object[] varNum = new Object[1];
        StrBuilder initStatements = new StrBuilder();
        StrBuilder paramScore = new StrBuilder();
        for (StringChannel strChannel : stringChannels) {
            varName = strChannel.getChannelName();
            initStatements.append(varName);
            initStatements.append(" = ");
            initStatements.append("\"").append(strChannel.getValue()).append("\"\n");
            if (!useAPI) continue;
            initStatements.append(varName).append(" chnexport \"");
            initStatements.append(varName).append("\", 3\n");
        }
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter param = (Parameter)parameters.get(i);
            varNum[0] = new Integer(i);
            varName = param.getCompilationVarName();
            double initialVal = param.getFixedValue();
            initStatements.append(varName);
            initStatements.append(" init ");
            initStatements.append(NumberUtilities.formatDouble((double)initialVal));
            initStatements.append("\n");
            if (!useAPI) continue;
            initStatements.append(varName).append(" chnexport \"");
            initStatements.append(varName).append("\", 3\n");
        }
        globalOrcSco.appendGlobalOrc(initStatements.toString());
        try {
            notes.addAll((Collection)ScoreUtilities.getNotes((String)paramScore.toString()));
        }
        catch (NoteParseException ex) {
            ex.printStackTrace();
        }
    }

    protected TempoMapper getTempoMapper(Tempo tempo) {
        StrBuilder buffer = new StrBuilder();
        Line line = tempo.getLine();
        for (int i = 0; i < line.size(); ++i) {
            LinePoint lp = line.getLinePoint(i);
            buffer.append(" ").append(lp.getX());
            buffer.append(" ").append(lp.getY());
        }
        return TempoMapper.createTempoMapper((String)buffer.toString());
    }

    private TempoMapper getTempoMapper(String globalSco) {
        TempoMapper mapper = null;
        StringTokenizer st = new StringTokenizer(globalSco, "\n");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken().trim();
            if (!temp.startsWith("t")) continue;
            mapper = TempoMapper.createTempoMapper((String)temp.substring(1));
        }
        return mapper;
    }

    private void assignChannelIds(CompileData compileData, Mixer mixer) {
        Map assignments = compileData.getChannelIdAssignments();
        int i = 0;
        for (Channel channel : mixer.getAllSourceChannels()) {
            assignments.put(channel, i++);
        }
        for (Channel channel : mixer.getSubChannels()) {
            assignments.put(channel, i++);
        }
        assignments.put(mixer.getMaster(), i);
    }
}

