/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.render;

import blue.Arrangement;
import blue.BlueData;
import blue.InstrumentAssignment;
import blue.automation.Automatable;
import blue.automation.Parameter;
import blue.automation.ParameterList;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.EffectsChain;
import blue.mixer.Mixer;
import blue.orchestra.Instrument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ParameterHelper {
    public static ArrayList<Parameter> getAllParameters(Arrangement arr, Mixer mixer) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (int i = 0; i < arr.size(); ++i) {
            Instrument instr;
            InstrumentAssignment ia = arr.getInstrumentAssignment(i);
            if (!ia.enabled || !((instr = ia.instr) instanceof Automatable)) continue;
            Automatable auto = (Automatable)instr;
            ParameterList list = auto.getParameterList();
            params.addAll((Collection<Parameter>)list);
        }
        if (mixer != null && mixer.isEnabled()) {
            List channels = mixer.getAllSourceChannels();
            for (Channel channel : channels) {
                ParameterHelper.appendAllParametersFromChannel(params, channel);
            }
            ChannelList subChannels = mixer.getSubChannels();
            for (Channel channel : subChannels) {
                ParameterHelper.appendAllParametersFromChannel(params, channel);
            }
            ParameterHelper.appendAllParametersFromChannel(params, mixer.getMaster());
        }
        return params;
    }

    public static List<Parameter> getActiveParameters(Arrangement arr, Mixer mixer) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (int i = 0; i < arr.size(); ++i) {
            Instrument instr;
            InstrumentAssignment ia = arr.getInstrumentAssignment(i);
            if (!ia.enabled || !((instr = ia.instr) instanceof Automatable)) continue;
            Automatable auto = (Automatable)instr;
            ParameterList list = auto.getParameterList();
            ParameterHelper.addActiveParametersFromList(params, list);
        }
        if (mixer != null && mixer.isEnabled()) {
            List channels = mixer.getAllSourceChannels();
            for (Channel channel : channels) {
                ParameterHelper.appendParametersFromChannel(params, channel);
            }
            ChannelList subChannels = mixer.getSubChannels();
            for (Channel subChannel : subChannels) {
                ParameterHelper.appendParametersFromChannel(params, subChannel);
            }
            ParameterHelper.appendParametersFromChannel(params, mixer.getMaster());
        }
        return params;
    }

    private static void appendAllParametersFromChannel(ArrayList<Parameter> params, Channel channel) {
        EffectsChain pre = channel.getPreEffects();
        for (int i = 0; i < pre.size(); ++i) {
            ParameterList list = ((Automatable)pre.getElementAt(i)).getParameterList();
            params.addAll((Collection<Parameter>)list);
        }
        EffectsChain post = channel.getPostEffects();
        for (int i = 0; i < post.size(); ++i) {
            ParameterList list = ((Automatable)post.getElementAt(i)).getParameterList();
            params.addAll((Collection<Parameter>)list);
        }
        Parameter levelParameter = channel.getLevelParameter();
        params.add(levelParameter);
    }

    private static void appendParametersFromChannel(List<Parameter> params, Channel channel) {
        EffectsChain pre = channel.getPreEffects();
        for (int i = 0; i < pre.size(); ++i) {
            ParameterList list = ((Automatable)pre.getElementAt(i)).getParameterList();
            ParameterHelper.addActiveParametersFromList(params, list);
        }
        EffectsChain post = channel.getPostEffects();
        for (int i = 0; i < post.size(); ++i) {
            ParameterList list = ((Automatable)post.getElementAt(i)).getParameterList();
            ParameterHelper.addActiveParametersFromList(params, list);
        }
        if (channel.getLevelParameter().isAutomationEnabled()) {
            params.add(channel.getLevelParameter());
        }
    }

    private static void addActiveParametersFromList(List<Parameter> params, ParameterList list) {
        for (Parameter param : params) {
            if (!param.isAutomationEnabled()) continue;
            params.add(param);
        }
    }

    public static void clearCompilationVarNames(BlueData data) {
        Arrangement arrangement = data.getArrangement();
        for (int i = 0; i < arrangement.size(); ++i) {
            Instrument instr = arrangement.getInstrument(i);
            if (!(instr instanceof Automatable)) continue;
            Automatable temp = (Automatable)instr;
            temp.getParameterList().clearCompilationVarNames();
        }
        Mixer mixer = data.getMixer();
        List channels = mixer.getAllSourceChannels();
        for (Channel channel : channels) {
            ParameterHelper.clearChannelCompilationVar(channel);
        }
        ChannelList subChannels = mixer.getSubChannels();
        for (Channel subChannel : subChannels) {
            ParameterHelper.clearChannelCompilationVar(subChannel);
        }
        ParameterHelper.clearChannelCompilationVar(mixer.getMaster());
    }

    private static void clearChannelCompilationVar(Channel channel) {
        channel.getLevelParameter().setCompilationVarName(null);
        EffectsChain preEffectsChain = channel.getPreEffects();
        for (int j = 0; j < preEffectsChain.size(); ++j) {
            Automatable automatable = (Automatable)preEffectsChain.getElementAt(j);
            automatable.getParameterList().clearCompilationVarNames();
        }
        EffectsChain postEffectsChain = channel.getPostEffects();
        for (int j = 0; j < postEffectsChain.size(); ++j) {
            Automatable automatable = (Automatable)postEffectsChain.getElementAt(j);
            automatable.getParameterList().clearCompilationVarNames();
        }
    }
}

