/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.BlueSystem;
import blue.gui.LabelledItemPanel;
import blue.score.ScoreObject;
import blue.ui.core.score.undo.ResizeScoreObjectEdit;
import blue.ui.core.score.undo.StartTimeEdit;
import blue.undo.BlueUndoManager;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEdit;

public class QuickTimeDialog
extends JDialog {
    LabelledItemPanel itemPanel = new LabelledItemPanel();
    JTextField startText = new JTextField();
    JTextField durText = new JTextField();
    private ScoreObject scoreObj;

    public QuickTimeDialog(Frame owner) {
        super(owner);
        this.setTitle(BlueSystem.getString((String)"scoreGUI.quickTimeDialog.title"));
        this.itemPanel.addItem(BlueSystem.getString((String)"soundObjectProperties.startTime"), this.startText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundObjectProperties.subjectiveDuration"), this.durText);
        this.startText.setPreferredSize(new Dimension(130, 17));
        this.durText.setPreferredSize(new Dimension(130, 17));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                QuickTimeDialog.this.hide();
            }
        });
        KeyAdapter k = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                QuickTimeDialog.this.handleKeyTyped(e);
            }
        };
        this.startText.addKeyListener(k);
        this.durText.addKeyListener(k);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.itemPanel, "Center");
        this.pack();
        GUI.centerOnScreen((Component)this);
    }

    private void handleKeyTyped(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                this.hide();
                break;
            }
            case 10: {
                this.handleWindowDeactivated();
            }
        }
    }

    private void handleWindowDeactivated() {
        if (this.scoreObj != null) {
            try {
                double initialStart = this.scoreObj.getStartTime();
                double initialSubjectiveDuration = this.scoreObj.getSubjectiveDuration();
                double newStart = Double.parseDouble(this.startText.getText());
                double newSubjectiveDuration = Double.parseDouble(this.durText.getText());
                BlueUndoManager.setUndoManager((String)"score");
                StartTimeEdit edit = null;
                if (initialStart != newStart) {
                    this.scoreObj.setStartTime(newStart);
                    edit = new StartTimeEdit(initialStart, newStart, this.scoreObj);
                    BlueUndoManager.addEdit((UndoableEdit)edit);
                }
                if (initialSubjectiveDuration != newSubjectiveDuration) {
                    this.scoreObj.setSubjectiveDuration(newSubjectiveDuration);
                    ResizeScoreObjectEdit resizeEdit = new ResizeScoreObjectEdit(this.scoreObj, initialSubjectiveDuration, newSubjectiveDuration);
                    if (edit != null) {
                        edit.addEdit(resizeEdit);
                    } else {
                        BlueUndoManager.addEdit((UndoableEdit)resizeEdit);
                    }
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"scoreGUI.quickTimeDialog.notDouble.message"), BlueSystem.getString((String)"scoreGUI.quickTimeDialog.notDouble.title"), 0);
                this.show();
                this.startText.requestFocus();
                return;
            }
        }
        this.hide();
    }

    public void show(ScoreObject scoreObject) {
        this.scoreObj = scoreObject;
        this.startText.setText(Double.toString(this.scoreObj.getStartTime()));
        this.durText.setText(Double.toString(this.scoreObj.getSubjectiveDuration()));
        super.show();
        this.startText.requestFocus();
    }
}

