/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.BlueData;
import blue.SoundLayer;
import blue.SoundLayerListener;
import blue.components.AlphaMarquee;
import blue.projects.BlueProjectManager;
import blue.score.TimeState;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ModeListener;
import blue.ui.core.score.ModeManager;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.ScoreObjectView;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.ui.core.score.layers.SelectionMarquee;
import blue.ui.core.score.layers.soundObject.AutomationLayerPanel;
import blue.ui.core.score.layers.soundObject.ScoreTimelineDropTargetListener;
import blue.ui.core.score.layers.soundObject.SoundObjectView;
import blue.ui.utilities.ParentDispatchingMouseAdapter;
import blue.utility.ObjectUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;

public final class ScoreTimeCanvas
extends JLayeredPane
implements PropertyChangeListener,
LayerGroupListener,
SoundLayerListener,
LayerGroupPanel<PolyObject>,
ModeListener {
    private static final MessageFormat toolTipFormat = new MessageFormat("<html><b>Name:</b> {0}<br><b>Type:</b> {1}<br><b>Start Time:</b> {2}<br><b>Duration:</b> {3}<br><b>End Time:</b> {4}</html>");
    private final HashMap<SoundObject, SoundObjectView> soundObjectToViewMap = new HashMap();
    int time;
    PolyObject pObj;
    TimeState timeState = null;
    AlphaMarquee marquee = new AlphaMarquee();
    Point start = new Point(0, 0);
    Point end;
    AutomationLayerPanel automationPanel = new AutomationLayerPanel(this.marquee);
    JPanel sObjPanel = new JPanel();
    private final PropertyChangeListener heightListener;
    private final BlueData data;
    private final InstanceContent content;
    private final ScoreTimelineDropTargetListener dropTargetListener;
    int maxUnitIncrement = 200;

    public ScoreTimeCanvas(BlueData blueData, InstanceContent ic) {
        this.content = ic;
        this.data = blueData;
        this.heightListener = evt -> this.reset();
        this.sObjPanel.setLayout(null);
        this.time = 3;
        ModeManager.getInstance().addModeListener(this);
        this.sObjPanel.setOpaque(false);
        this.add((Component)this.automationPanel, MODAL_LAYER);
        this.add((Component)this.sObjPanel, DEFAULT_LAYER);
        this.add((Component)this.marquee, JLayeredPane.DRAG_LAYER);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension size = ScoreTimeCanvas.this.getSize();
                ScoreTimeCanvas.this.automationPanel.setSize(size);
                ScoreTimeCanvas.this.sObjPanel.setSize(size);
            }
        });
        this.dropTargetListener = new ScoreTimelineDropTargetListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setFocusable(true);
        ParentDispatchingMouseAdapter mouseAdapter = new ParentDispatchingMouseAdapter((Component)this);
        this.addMouseListener((MouseListener)mouseAdapter);
        this.addMouseMotionListener((MouseMotionListener)mouseAdapter);
    }

    public JPanel getSoundObjectPanel() {
        return this.sObjPanel;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Component obj = this.getComponentAt(e.getPoint());
        if (obj instanceof SoundObjectView) {
            SoundObject sObj = ((SoundObjectView)obj).getSoundObject();
            double subjectiveDuration = sObj.getSubjectiveDuration();
            double startTime = sObj.getStartTime();
            Object[] args = new Object[]{sObj.getName(), ObjectUtilities.getShortClassName((Object)sObj), new Double(startTime), new Double(subjectiveDuration), new Double(startTime + subjectiveDuration)};
            tip = toolTipFormat.format(args);
        }
        return tip;
    }

    public void setSelectionDragRegions() {
    }

    public void reset() {
        SwingUtilities.invokeLater(() -> {
            BlueData data1;
            Component[] components = this.sObjPanel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                Component c = components[i];
                if (!(c instanceof SoundObjectView)) continue;
                SoundObjectView sObjView = (SoundObjectView)c;
                int index = this.getPolyObject().getSoundLayerIndex(sObjView.getSoundObject());
                if (index < 0) {
                    sObjView.cleanup();
                    this.sObjPanel.remove(c);
                    this.soundObjectToViewMap.remove(sObjView.getSoundObject());
                    continue;
                }
                int newY = this.getPolyObject().getYForLayerNum(index);
                int newHeight = this.getPolyObject().getSoundLayerHeight(index);
                sObjView.updateView(newY, newHeight);
            }
            if (ScoreController.getInstance().getScorePath().getLastLayerGroup() == null && (data1 = BlueProjectManager.getInstance().getCurrentBlueData()) != null) {
                int startTime = (int)(data1.getRenderStartTime() * (double)this.timeState.getPixelSecond());
                int n = (int)(data1.getRenderEndTime() * (double)this.timeState.getPixelSecond());
            }
            this.checkSize();
            this.automationPanel.revalidate();
            this.revalidate();
            this.repaint();
        });
    }

    public void setPolyObject(PolyObject pObj, TimeState timeState) {
        Component[] components = this.sObjPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (!(c instanceof SoundObjectView)) continue;
            SoundObjectView sObjView = (SoundObjectView)c;
            sObjView.cleanup();
        }
        this.sObjPanel.removeAll();
        this.soundObjectToViewMap.clear();
        this.marquee.setVisible(false);
        if (this.getPolyObject() != null) {
            this.timeState.removePropertyChangeListener((PropertyChangeListener)this);
            this.getPolyObject().removeLayerGroupListener((LayerGroupListener)this);
            for (int i = 0; i < pObj.size(); ++i) {
                SoundLayer tempLayer = (SoundLayer)pObj.get(i);
                tempLayer.removePropertyChangeListener(this.heightListener);
                tempLayer.removeSoundLayerListener((SoundLayerListener)this);
            }
        }
        this.pObj = pObj;
        this.timeState = timeState;
        this.dropTargetListener.setTimeState(timeState);
        if (this.getPolyObject() != null) {
            timeState.addPropertyChangeListener((PropertyChangeListener)this);
            pObj.addLayerGroupListener((LayerGroupListener)this);
        }
        this.automationPanel.setLayerGroup((LayerGroup)pObj, timeState);
        int size = pObj.size();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                SoundLayer tempLayer = (SoundLayer)pObj.get(i);
                tempLayer.addPropertyChangeListener(this.heightListener);
                tempLayer.addSoundLayerListener((SoundLayerListener)this);
                for (SoundObject tempSObj : tempLayer) {
                    this.addSoundObjectView(i, tempSObj);
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "ScoreTimeCanvas: setPObj found size == 0");
        }
        this.checkSize(true);
        this.revalidate();
        this.repaint();
    }

    public void checkSize() {
        this.checkSize(false);
    }

    public void checkSize(boolean setSize) {
        if (this.getPolyObject() == null || this.timeState == null) {
            return;
        }
        int tempTime = (int)(this.getPolyObject().getMaxTime() / 60.0) + 2;
        int height = this.getPolyObject().getTotalHeight();
        int width = tempTime * this.timeState.getPixelSecond() * 60;
        if (width == this.getWidth() && height == this.getHeight()) {
            return;
        }
        Dimension d = new Dimension(width, height);
        if (setSize) {
            this.setSize(d);
        }
        this.setPreferredSize(d);
    }

    private void addSoundObjectView(int soundLayerIndex, SoundObject sObj) {
        SoundObjectView temp = new SoundObjectView(sObj, this.timeState);
        this.sObjPanel.add((Component)temp, 0);
        temp.setLocation((int)(sObj.getStartTime() * (double)this.timeState.getPixelSecond()), this.getPolyObject().getYForLayerNum(soundLayerIndex));
        temp.setSize((int)(sObj.getSubjectiveDuration() * (double)this.timeState.getPixelSecond()), this.getPolyObject().getSoundLayerHeight(soundLayerIndex));
        this.soundObjectToViewMap.put(sObj, temp);
    }

    private void removeSoundObjectView(SoundObject sObj) {
        SoundObjectView sObjView = this.soundObjectToViewMap.remove(sObj);
        sObjView.cleanup();
        this.sObjPanel.remove(sObjView);
        this.sObjPanel.repaint(sObjView.getBounds());
    }

    public void updateSoundObjectViewLayerIndex(SoundObject sObj, int soundLayerIndex) {
        SoundObjectView sObjView = this.soundObjectToViewMap.get(sObj);
        sObjView.setLocation(sObjView.getX(), this.getPolyObject().getYForLayerNum(soundLayerIndex));
    }

    public SoundObjectView getViewForSoundObject(SoundObject sObj) {
        return this.soundObjectToViewMap.get(sObj);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, width, this.getHeight());
        if (this.getPolyObject() == null || this.timeState == null) {
            return;
        }
        int y = 0;
        g.setColor(Color.DARK_GRAY);
        g.drawLine(0, 0, width, 0);
        for (SoundLayer layer : this.getPolyObject()) {
            g.drawLine(0, y += layer.getSoundLayerHeight(), width, y);
        }
        g.drawLine(0, this.getHeight() - 1, width, this.getHeight() - 1);
        if (this.timeState.isSnapEnabled()) {
            int snapPixels = (int)(this.timeState.getSnapValue() * (double)this.timeState.getPixelSecond());
            int x = 0;
            if (snapPixels <= 0) {
                return;
            }
            int height = this.getPolyObject().getTotalHeight();
            double snapValue = this.timeState.getSnapValue();
            int pixelSecond = this.timeState.getPixelSecond();
            int i = 0;
            while (x < width) {
                x = (int)((double)i * snapValue * (double)pixelSecond);
                g.drawLine(x, 0, x, height);
                ++i;
            }
        }
    }

    @Override
    public void paintNavigatorView(Graphics2D g2d) {
        Component[] components;
        for (Component c : components = this.getSoundObjectPanel().getComponents()) {
            SoundObjectView component = (SoundObjectView)c;
            Rectangle r = component.getBounds();
            g2d.setColor(component.getSoundObject().getBackgroundColor());
            g2d.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    public void update() {
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public PolyObject getPolyObject() {
        return this.pObj;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (evt.getSource() == this.timeState) {
            switch (prop) {
                case "pixelSecond": {
                    this.reset();
                    break;
                }
                case "snapEnabled": 
                case "snapValue": {
                    this.repaint();
                }
            }
        }
    }

    public void soundObjectAdded(SoundLayer source, SoundObject sObj) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addSoundObjectView(this.getPolyObject().getLayerNum(source), sObj);
        } else {
            SwingUtilities.invokeLater(() -> this.addSoundObjectView(this.getPolyObject().getLayerNum(source), sObj));
        }
    }

    public void soundObjectRemoved(SoundLayer source, SoundObject sObj) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.removeSoundObjectView(sObj);
        } else {
            SwingUtilities.invokeLater(() -> this.removeSoundObjectView(sObj));
        }
    }

    public void modifyLayerHeight(int value, int y) {
        int index = this.getPolyObject().getLayerNumForY(y);
        if (index < 0 || index >= this.getPolyObject().size()) {
            return;
        }
        SoundLayer layer = (SoundLayer)this.getPolyObject().get(index);
        int hIndex = layer.getHeightIndex();
        if (value < 0 && hIndex < 1) {
            return;
        }
        if (value > 0 && hIndex > 8) {
            return;
        }
        layer.setHeightIndex(hIndex + value);
    }

    public void layerGroupChanged(LayerGroupDataEvent event) {
        if (event.getType() == 0) {
            SoundLayer layer = (SoundLayer)this.getPolyObject().get(event.getStartIndex());
            layer.addPropertyChangeListener(this.heightListener);
            layer.addSoundLayerListener((SoundLayerListener)this);
        }
        this.reset();
    }

    @Override
    public void modeChanged(ScoreMode mode) {
        this.marquee.setVisible(false);
    }

    @Override
    public void removeNotify() {
        this.data.removePropertyChangeListener((PropertyChangeListener)this);
        ModeManager.getInstance().removeModeListener(this);
    }

    @Override
    public void marqueeSelectionPerformed(SelectionMarquee marquee) {
        Component[] comps = this.sObjPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof SoundObjectView) || !marquee.intersects((JComponent)comps[i])) continue;
            this.content.add((Object)((SoundObjectView)comps[i]).getSoundObject());
        }
    }

    @Override
    public ScoreObjectView getScoreObjectViewAtPoint(Point p) {
        Component c = this.sObjPanel.getComponentAt(p);
        if (c instanceof ScoreObjectView) {
            return (ScoreObjectView)((Object)c);
        }
        return null;
    }

    @Override
    public Action[] getLayerActions() {
        List list = Utilities.actionsForPath((String)"blue/score/layers/soundObject/actions");
        return list.toArray(new Action[0]);
    }

    @Override
    public PolyObject getLayerGroup() {
        return this.pObj;
    }
}

