/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.BlueSystem;
import blue.SoundObjectLibrary;
import blue.soundObject.SoundObject;
import javax.swing.table.AbstractTableModel;

class SoundObjectLibraryTableModel
extends AbstractTableModel {
    SoundObjectLibrary sObjLib;
    static final String NAME = BlueSystem.getString((String)"soundObjectLibrary.table.name");
    static final String TYPE = BlueSystem.getString((String)"soundObjectLibrary.table.type");
    static final String INSTANCE_COUNT = BlueSystem.getString((String)"soundObjectLibrary.table.instanceCount");

    public SoundObjectLibraryTableModel(SoundObjectLibrary sObjLib) {
        this.sObjLib = sObjLib;
    }

    @Override
    public String getColumnName(int i) {
        switch (i) {
            case 0: {
                return NAME;
            }
            case 1: {
                return TYPE;
            }
            case 2: {
                return INSTANCE_COUNT;
            }
        }
        return BlueSystem.getString((String)"message.error");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.sObjLib == null) {
            return null;
        }
        SoundObject sObj = this.sObjLib.getSoundObject(row);
        switch (column) {
            case 0: {
                return sObj.getName();
            }
            case 1: {
                return BlueSystem.getShortClassName((String)sObj.getClass().getName());
            }
            case 2: {
                return BlueSystem.getString((String)"common.notYetImplemented");
            }
        }
        return BlueSystem.getString((String)"message.error");
    }

    @Override
    public int getRowCount() {
        return this.sObjLib.size();
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            try {
                String val = (String)value;
                this.sObjLib.getSoundObject(row).setName(val);
            }
            catch (Exception e) {
                System.out.println("error in OrchestraTableModel: setValueAt");
                e.printStackTrace();
            }
        }
        this.fireTableCellUpdated(row, col);
    }
}

