/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.BlueData;
import blue.SoundLayer;
import blue.SoundObjectLibrary;
import blue.score.Score;
import blue.score.ScoreObject;
import blue.score.layers.LayerGroup;
import blue.soundObject.Instance;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import java.util.ArrayList;

public class SoundObjectLibraryUtils {
    public static void removeLibrarySoundObject(BlueData data, SoundObject sObj) {
        SoundObjectLibrary library = data.getSoundObjectLibrary();
        library.removeSoundObject(sObj);
        for (SoundObject tempObj : library) {
            if (!(tempObj instanceof PolyObject)) continue;
            SoundObjectLibraryUtils.removeSoundObjectInstances((PolyObject)tempObj, sObj);
        }
        Score score = data.getScore();
        for (LayerGroup layerGroup : score) {
            if (!(layerGroup instanceof PolyObject)) continue;
            PolyObject pObj = (PolyObject)layerGroup;
            SoundObjectLibraryUtils.removeSoundObjectInstances(pObj, sObj);
        }
    }

    protected static void removeSoundObjectInstances(PolyObject polyObject, SoundObject sObj) {
        for (int i = 0; i < polyObject.size(); ++i) {
            SoundLayer layer = (SoundLayer)polyObject.get(i);
            ArrayList<Instance> instances = new ArrayList<Instance>();
            for (SoundObject soundObject : layer) {
                if (soundObject instanceof Instance) {
                    Instance instance = (Instance)soundObject;
                    if (instance.getSoundObject() != sObj) continue;
                    instances.add(instance);
                    continue;
                }
                if (!(soundObject instanceof PolyObject)) continue;
                SoundObjectLibraryUtils.removeSoundObjectInstances((PolyObject)soundObject, sObj);
            }
            for (SoundObject soundObject : instances) {
                layer.remove((ScoreObject)soundObject);
            }
        }
    }
}

