/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject.actions;

import blue.SoundLayer;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.ui.core.score.layers.soundObject.ScoreTimeCanvas;
import blue.ui.core.score.undo.AddScoreObjectEdit;
import blue.ui.utilities.FileChooserManager;
import blue.undo.BlueUndoManager;
import blue.utility.ObjectUtilities;
import electric.xml.Document;
import electric.xml.Element;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class ImportSoundObjectAction
extends AbstractAction
implements ContextAwareAction {
    private static final String IMPORT_DIALOG = "sObj.import";
    protected LayerGroupPanel lGroupPanel;
    protected Point p;
    private final TimeState timeState;
    private final ScorePath scorePath;

    public ImportSoundObjectAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ImportSoundObjectAction(Lookup lookup) {
        super(NbBundle.getMessage(ImportSoundObjectAction.class, (String)"CTL_ImportSoundObjectAction"));
        this.lGroupPanel = (LayerGroupPanel)lookup.lookup(LayerGroupPanel.class);
        this.p = (Point)lookup.lookup(Point.class);
        this.timeState = (TimeState)lookup.lookup(TimeState.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScoreTimeCanvas sCanvas = (ScoreTimeCanvas)this.lGroupPanel;
        List retVal = FileChooserManager.getDefault().showOpenDialog((Object)IMPORT_DIALOG, (Component)WindowManager.getDefault().getMainWindow());
        if (!retVal.isEmpty()) {
            File f = (File)retVal.get(0);
            try {
                Document doc = new Document(f);
                Element root = doc.getRoot();
                if (root.getName().equals("soundObject")) {
                    SoundObject tempSobj = (SoundObject)ObjectUtilities.loadFromXML((Element)root, null);
                    int start = this.p.x;
                    Layer layer = this.scorePath.getGlobalLayerForY(this.p.y);
                    if (this.timeState.isSnapEnabled()) {
                        int snapPixels = (int)(this.timeState.getSnapValue() * (double)this.timeState.getPixelSecond());
                        start -= start % snapPixels;
                    }
                    float startTime = (float)start / (float)this.timeState.getPixelSecond();
                    tempSobj.setStartTime((double)startTime);
                    ((SoundLayer)layer).add(tempSobj);
                    AddScoreObjectEdit edit = new AddScoreObjectEdit((ScoreObjectLayer)layer, (ScoreObject)tempSobj);
                    BlueUndoManager.setUndoManager((String)"score");
                    BlueUndoManager.addEdit((UndoableEdit)edit);
                } else {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Error: File did not contain Sound Object", "Error", 0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Error: Could not read Sound Object from file", "Error", 0);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.lGroupPanel != null && this.p != null && this.lGroupPanel instanceof ScoreTimeCanvas;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ImportSoundObjectAction(actionContext);
    }
}

