/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.mouse;

import blue.BlueSystem;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.mouse.BlueMouseAdapter;
import blue.ui.core.score.undo.MoveScoreObjectsEdit;
import blue.undo.BlueUndoManager;
import blue.utility.ScoreUtilities;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;

public class MoveScoreObjectsListener
extends BlueMouseAdapter {
    private static final int OS_CTRL_KEY = BlueSystem.getMenuShortcutKey();
    private Point startPoint;
    boolean initialDrag = true;
    private ScoreObject[] selectedScoreObjects = null;
    private double[] startTimes = null;
    private double minDiffTime = Double.MIN_VALUE;
    private int[] startLayerIndices = null;
    private int[] currentLayerIndices = null;
    private int startLayer = 0;
    private int lastLayerAdjust = 0;
    private int minYAdjust = 0;
    private int maxYAdjust = 0;

    protected static int getMinYAdjust(List<Layer> layers, ScoreObject scoreObj, int sObjLayerIndex) {
        for (int index = sObjLayerIndex - 1; index >= 0; --index) {
            if (layers.get(index).accepts(scoreObj)) continue;
            return index + 1 - sObjLayerIndex;
        }
        return -sObjLayerIndex;
    }

    protected static int getMaxYAdjust(List<Layer> layers, ScoreObject scoreObj, int sObjLayerIndex) {
        for (int index = sObjLayerIndex + 1; index < layers.size(); ++index) {
            if (layers.get(index).accepts(scoreObj)) continue;
            return index - 1 - sObjLayerIndex;
        }
        return layers.size() - 1 - sObjLayerIndex;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (currentScoreObjectView == null || !SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Object scoreObj = currentScoreObjectView.getScoreObject();
        Collection<? extends ScoreObject> temp = ScoreController.getInstance().getSelectedScoreObjects();
        if (!temp.contains(scoreObj)) {
            return;
        }
        e.consume();
        ScorePath scorePath = ScoreController.getInstance().getScorePath();
        this.startPoint = e.getPoint();
        this.selectedScoreObjects = temp.toArray(new ScoreObject[0]);
        this.startTimes = new double[this.selectedScoreObjects.length];
        this.startLayerIndices = new int[this.selectedScoreObjects.length];
        this.currentLayerIndices = new int[this.selectedScoreObjects.length];
        this.minDiffTime = Double.MAX_VALUE;
        this.startLayer = scorePath.getGlobalLayerIndexForY(e.getY());
        this.lastLayerAdjust = 0;
        this.minYAdjust = Integer.MIN_VALUE;
        this.maxYAdjust = Integer.MAX_VALUE;
        this.initialDrag = true;
        List<Layer> allLayers = scorePath.getAllLayers();
        for (int i = 0; i < this.selectedScoreObjects.length; ++i) {
            this.startTimes[i] = this.selectedScoreObjects[i].getStartTime();
            if (this.startTimes[i] < this.minDiffTime) {
                this.minDiffTime = this.startTimes[i];
            }
            this.startLayerIndices[i] = this.currentLayerIndices[i] = scorePath.getGlobalLayerIndexForScoreObject(this.selectedScoreObjects[i]);
            int minY = MoveScoreObjectsListener.getMinYAdjust(allLayers, scoreObj, this.startLayerIndices[i]);
            int maxY = MoveScoreObjectsListener.getMaxYAdjust(allLayers, scoreObj, this.startLayerIndices[i]);
            this.minYAdjust = minY > this.minYAdjust ? minY : this.minYAdjust;
            this.maxYAdjust = maxY < this.maxYAdjust ? maxY : this.maxYAdjust;
        }
        this.minDiffTime = -this.minDiffTime;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean layerAdjusted;
        ScoreController scoreController = ScoreController.getInstance();
        ScorePath scorePath = ScoreController.getInstance().getScorePath();
        List<Layer> allLayers = scorePath.getAllLayers();
        e.consume();
        if (this.initialDrag) {
            this.initialDrag = false;
            if ((e.getModifiers() & OS_CTRL_KEY) == OS_CTRL_KEY) {
                for (int i = 0; i < this.selectedScoreObjects.length; ++i) {
                    ScoreObject original = this.selectedScoreObjects[i];
                    ScoreObject clone = (ScoreObject)original.deepCopy();
                    ScoreObjectLayer layer = (ScoreObjectLayer)allLayers.get(this.startLayerIndices[i]);
                    layer.add((Object)clone);
                    scoreController.removeSelectedScoreObject(original);
                    scoreController.addSelectedScoreObject(clone);
                    this.selectedScoreObjects[i] = clone;
                }
            }
        }
        double diffTime = e.getX() - this.startPoint.x;
        TimeState timeState = scoreTC.getTimeState();
        if ((diffTime /= (double)timeState.getPixelSecond()) < this.minDiffTime) {
            diffTime = this.minDiffTime;
        }
        if (timeState.isSnapEnabled()) {
            double tempStart = -this.minDiffTime + diffTime;
            double snappedStart = ScoreUtilities.getSnapValueMove((double)tempStart, (double)timeState.getSnapValue());
            diffTime = snappedStart + this.minDiffTime;
        }
        int newLayerIndex = scorePath.getGlobalLayerIndexForY(e.getY());
        int layerAdjust = newLayerIndex - this.startLayer;
        layerAdjust = Math.max(layerAdjust, this.minYAdjust);
        boolean bl = layerAdjusted = this.lastLayerAdjust != (layerAdjust = Math.min(layerAdjust, this.maxYAdjust));
        if (layerAdjusted) {
            this.lastLayerAdjust = layerAdjust;
        }
        for (int i = 0; i < this.selectedScoreObjects.length; ++i) {
            this.selectedScoreObjects[i].setStartTime(this.startTimes[i] + diffTime);
            if (!layerAdjusted) continue;
            ScoreObject scoreObj = this.selectedScoreObjects[i];
            int startIndex = this.startLayerIndices[i];
            int curLayerIndex = this.currentLayerIndices[i];
            int newSObjLayerIndex = startIndex + layerAdjust;
            allLayers.get(curLayerIndex).remove(scoreObj);
            scoreController.addSelectedScoreObject(scoreObj);
            ((ScoreObjectLayer)allLayers.get(newSObjLayerIndex)).add((Object)scoreObj);
            this.currentLayerIndices[i] = newSObjLayerIndex;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        if (!this.initialDrag) {
            List<Layer> allLayers = ScoreController.getInstance().getScorePath().getAllLayers();
            int len = this.startTimes.length;
            double[] endTimes = new double[len];
            ScoreObjectLayer[] startLayers = new ScoreObjectLayer[len];
            ScoreObjectLayer[] endLayers = new ScoreObjectLayer[len];
            for (int i = 0; i < this.selectedScoreObjects.length; ++i) {
                endTimes[i] = this.selectedScoreObjects[i].getStartTime();
                startLayers[i] = (ScoreObjectLayer)allLayers.get(this.startLayerIndices[i]);
                endLayers[i] = (ScoreObjectLayer)allLayers.get(this.currentLayerIndices[i]);
            }
            MoveScoreObjectsEdit edit = new MoveScoreObjectsEdit(this.selectedScoreObjects, startLayers, endLayers, this.startTimes, endTimes);
            BlueUndoManager.setUndoManager((String)"score");
            BlueUndoManager.addEdit((UndoableEdit)edit);
        }
        this.selectedScoreObjects = null;
        this.startTimes = null;
        this.startLayerIndices = null;
        this.currentLayerIndices = null;
    }

    @Override
    public boolean acceptsMode(ScoreMode mode) {
        return mode == ScoreMode.SCORE;
    }
}

