/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.BlueData;
import blue.BlueSystem;
import blue.SoundLayer;
import blue.mixer.Mixer;
import blue.projects.BlueProjectManager;
import blue.score.Score;
import blue.score.ScoreObject;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import blue.settings.UtilitySettings;
import blue.soundObject.FrozenSoundObject;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.core.render.DiskRenderManager;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.utility.FileUtilities;
import blue.utility.SoundFileUtilities;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class FreezeUnfreezeAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> scoreObjects;
    private final Collection<? extends SoundObject> soundObjects;
    private final Point p;
    private final ScorePath scorePath;

    public FreezeUnfreezeAction() {
        this(Utilities.actionsGlobalContext());
    }

    public FreezeUnfreezeAction(Lookup lookup) {
        super(NbBundle.getMessage(FreezeUnfreezeAction.class, (String)"CTL_FreezeUnfreezeAction"));
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
        this.soundObjects = lookup.lookupAll(SoundObject.class);
        this.p = (Point)lookup.lookup(Point.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Layer> allLayers = this.scorePath.getAllLayers();
        ArrayList<SoundObject> sObjList = new ArrayList<SoundObject>(this.soundObjects);
        ArrayList<Layer> layers = new ArrayList<Layer>();
        block0: for (SoundObject sObj : sObjList) {
            for (Layer layer : allLayers) {
                if (!layer.contains((ScoreObject)sObj)) continue;
                layers.add(layer);
                continue block0;
            }
        }
        if (layers.size() != sObjList.size()) {
            throw new RuntimeException("Error: Could not find layers for selected SoundObjects");
        }
        ProgressUtils.showProgressDialogAndRun((ProgressRunnable)new FreezeRunnable(sObjList, layers), (String)"Freeze/Unfreeze SoundObjects", (boolean)true);
    }

    @Override
    public boolean isEnabled() {
        return !this.soundObjects.isEmpty() && this.soundObjects.size() == this.scoreObjects.size();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new FreezeUnfreezeAction(actionContext);
    }

    static class FreezeRunnable
    implements ProgressRunnable<Void> {
        private List<SoundObject> soundObjects;
        private List<Layer> layers;

        public FreezeRunnable(List<SoundObject> soundObjects, List<Layer> layers) {
            this.soundObjects = soundObjects;
            this.layers = layers;
        }

        public Void run(ProgressHandle handle) {
            handle.switchToDeterminate(this.soundObjects.size());
            for (int i = 0; i < this.soundObjects.size(); ++i) {
                FrozenSoundObject frozenObj;
                SoundObject sObj = this.soundObjects.get(i);
                SoundLayer layer = (SoundLayer)this.layers.get(i);
                if (sObj instanceof FrozenSoundObject) {
                    handle.progress("Unfreezing SoundObject...", i);
                    frozenObj = (FrozenSoundObject)sObj;
                    layer.remove((ScoreObject)sObj);
                    this.unfreezeSoundObject(frozenObj);
                    SoundObject source = frozenObj.getFrozenSoundObject();
                    source.setStartTime(frozenObj.getStartTime());
                    layer.add(source);
                    continue;
                }
                handle.progress("Freezing SoundObject...", i);
                frozenObj = this.freezeSoundObject(sObj);
                if (frozenObj == null) {
                    return null;
                }
                frozenObj.setStartTime(sObj.getStartTime());
                layer.remove((ScoreObject)sObj);
                layer.add((SoundObject)frozenObj);
            }
            handle.finish();
            return null;
        }

        protected FrozenSoundObject freezeSoundObject(SoundObject sObj) {
            String tempCSD;
            File projectDir = BlueSystem.getCurrentProjectDirectory();
            if (projectDir == null) {
                JOptionPane.showMessageDialog(null, "Project must be saved before soundObjects can be frozen.");
                return null;
            }
            BlueData data = BlueProjectManager.getInstance().getCurrentProject().getData();
            BlueData tempData = new BlueData(data);
            PolyObject tempPObj = new PolyObject(true);
            SoundLayer sLayer = tempPObj.newLayerAt(-1);
            SoundObject tempSObj = sObj.deepCopy();
            tempData.setRenderStartTime(tempSObj.getStartTime());
            double renderEndTime = tempSObj.getStartTime() + tempSObj.getSubjectiveDuration();
            Mixer m = data.getMixer();
            if (m.isEnabled()) {
                renderEndTime += m.getExtraRenderTime();
            }
            tempData.setRenderEndTime(renderEndTime);
            sLayer.add(tempSObj);
            tempData.getScore().clear();
            tempData.getScore().add((Object)tempPObj);
            try {
                CsdRenderResult result = CSDRenderService.getDefault().generateCSD(tempData, tempSObj.getStartTime(), renderEndTime, false, false);
                tempCSD = result.getCsdText();
            }
            catch (Exception e) {
                throw new RuntimeException("CSDRender Failed", e);
            }
            String tempFileName = this.getAvailableFreezeFileName(projectDir);
            String fullTempFileName = projectDir.getAbsolutePath() + File.separatorChar + tempFileName;
            System.out.println("TEMP FILE NAME: " + tempFileName);
            UtilitySettings utilitySettings = UtilitySettings.getInstance();
            String csoundExec = utilitySettings.csoundExecutable;
            String flags = utilitySettings.freezeFlags;
            String command = csoundExec + " " + flags + " ";
            try {
                File temp = FileUtilities.createTempTextFile((String)"tempCsd", (String)".csd", (File)projectDir, (String)tempCSD);
                String[] args = command.split("\\s+");
                String[] args2 = new String[args.length + 2];
                System.arraycopy(args, 0, args2, 0, args.length);
                args2[args.length] = fullTempFileName;
                args2[args.length + 1] = temp.getAbsolutePath();
                String csoundOutput = DiskRenderManager.getInstance().execWaitAndCollect(args2, projectDir);
                FrozenSoundObject fso = new FrozenSoundObject();
                fso.setFrozenSoundObject(sObj);
                fso.setFrozenWaveFileName(tempFileName);
                fso.setName("F: " + sObj.getName());
                double soundFileDuration = SoundFileUtilities.getDurationInSeconds((String)fullTempFileName);
                fso.setSubjectiveDuration(soundFileDuration);
                int numChannels = SoundFileUtilities.getNumberOfChannels((String)fullTempFileName);
                fso.setNumChannels(numChannels);
                return fso;
            }
            catch (Exception ex) {
                System.err.println("[" + BlueSystem.getString((String)"message.error") + "] " + ex.getLocalizedMessage());
                ex.printStackTrace();
                return null;
            }
        }

        private String getAvailableFreezeFileName(File projectDir) {
            String[] files = projectDir.list();
            int counter = -1;
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].startsWith("freeze")) continue;
                try {
                    int num = Integer.parseInt(files[i].substring(6, files[i].indexOf(".")));
                    if (counter >= num) continue;
                    counter = num;
                    continue;
                }
                catch (NumberFormatException num) {
                    // empty catch block
                }
            }
            ++counter;
            String extension = ".wav";
            if (System.getProperty("os.name").contains("Mac")) {
                extension = ".aif";
            }
            String tempFileName = "freeze" + counter + extension;
            while (new File(tempFileName).exists()) {
                tempFileName = "freeze" + ++counter + extension;
            }
            return tempFileName;
        }

        protected void unfreezeSoundObject(FrozenSoundObject fso) {
            String waveFileName = fso.getFrozenWaveFileName();
            int refCount = this.freezeReferenceCount(ScoreController.getInstance().getScore(), waveFileName);
            System.out.println("Reference Count: " + refCount);
            if (refCount <= 0) {
                File projectDir = BlueSystem.getCurrentProjectDirectory();
                File f = new File(projectDir, waveFileName);
                f.delete();
                System.out.println("Deleting File: " + f.getAbsolutePath());
            }
        }

        private int freezeReferenceCount(Score score, String waveFileName) {
            int retVal = 0;
            for (LayerGroup lGroup : score) {
                if (!(lGroup instanceof PolyObject)) continue;
                PolyObject pObj = (PolyObject)lGroup;
                retVal += this.freezeReferenceCount(pObj, waveFileName);
            }
            return retVal;
        }

        private int freezeReferenceCount(PolyObject pObj, String waveFileName) {
            int retVal = 0;
            List sObjects = pObj.getSoundObjects(true);
            for (SoundObject sObj : sObjects) {
                FrozenSoundObject fso;
                if (sObj instanceof PolyObject) {
                    retVal += this.freezeReferenceCount((PolyObject)sObj, waveFileName);
                    continue;
                }
                if (!(sObj instanceof FrozenSoundObject) || !(fso = (FrozenSoundObject)sObj).getFrozenWaveFileName().equals(waveFileName)) continue;
                ++retVal;
            }
            return retVal;
        }
    }
}

