/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.undo.MoveScoreObjectsEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ReverseAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> scoreObjects = ScoreController.getInstance().getSelectedScoreObjects();

    public ReverseAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ReverseAction(Lookup lookup) {
        super(NbBundle.getMessage(ReverseAction.class, (String)"CTL_ReverseAction"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.scoreObjects.size() < 2) {
            return;
        }
        double start = Double.MAX_VALUE;
        double end = Double.MIN_VALUE;
        for (ScoreObject scoreObject : this.scoreObjects) {
            double tempStart = scoreObject.getStartTime();
            double tempEnd = tempStart + scoreObject.getSubjectiveDuration();
            if (tempStart < start) {
                start = tempStart;
            }
            if (!(tempEnd > end)) continue;
            end = tempEnd;
        }
        int len = this.scoreObjects.size();
        ScoreObject[] scoreObjectArray = this.scoreObjects.toArray(new ScoreObject[this.scoreObjects.size()]);
        double[] startTimes = new double[len];
        double[] endTimes = new double[len];
        for (int i = 0; i < len; ++i) {
            ScoreObject scoreObj = scoreObjectArray[i];
            double tempStart = scoreObj.getStartTime();
            double tempEnd = tempStart + scoreObj.getSubjectiveDuration();
            double newStart = start + (end - tempEnd);
            scoreObj.setStartTime(newStart);
            startTimes[i] = tempStart;
            endTimes[i] = newStart;
        }
        BlueUndoManager.setUndoManager((String)"score");
        MoveScoreObjectsEdit edit = new MoveScoreObjectsEdit(scoreObjectArray, null, null, startTimes, endTimes);
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit((UndoableEdit)edit);
    }

    @Override
    public boolean isEnabled() {
        return this.scoreObjects.size() > 1;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ReverseAction(actionContext);
    }
}

