/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.BlueSystem;
import blue.score.ScoreObject;
import blue.ui.core.score.undo.AlignEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ShiftAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> selected;

    public ShiftAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ShiftAction(Lookup lookup) {
        super(NbBundle.getMessage(ShiftAction.class, (String)"CTL_ShiftAction"));
        this.selected = lookup.lookupAll(ScoreObject.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.selected == null || this.selected.size() <= 0) {
            return;
        }
        String value = JOptionPane.showInputDialog(null, (Object)BlueSystem.getString((String)"scoreGUI.action.shift.message"));
        try {
            double val = Double.parseDouble(value);
            for (ScoreObject scoreObject : this.selected) {
                if (!(scoreObject.getStartTime() + val < 0.0)) continue;
                JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"scoreGUI.action.shift.error"));
                return;
            }
            int len = this.selected.size();
            ScoreObject[] scoreObjectArray = this.selected.toArray(new ScoreObject[this.selected.size()]);
            double[] startTimes = new double[len];
            double[] endTimes = new double[len];
            for (int i = 0; i < len; ++i) {
                ScoreObject scoreObj = scoreObjectArray[i];
                startTimes[i] = scoreObj.getStartTime();
                endTimes[i] = startTimes[i] + val;
                scoreObj.setStartTime(endTimes[i]);
            }
            AlignEdit edit = new AlignEdit(scoreObjectArray, startTimes, endTimes);
            BlueUndoManager.setUndoManager((String)"score");
            BlueUndoManager.addEdit((UndoableEdit)edit);
        }
        catch (NumberFormatException nfe) {
            System.err.println(nfe.getMessage());
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ShiftAction(actionContext);
    }
}

