/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.tables;

import blue.Tables;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TablesTopComponent", persistenceType=0)
public final class TablesTopComponent
extends TopComponent {
    private static TablesTopComponent instance;
    private MimeTypeEditorComponent tablesText = new MimeTypeEditorComponent("text/x-csound-sco");
    private Tables tables = null;
    UndoManager undo = new UndoRedo.Manager();

    private TablesTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(TablesTopComponent.class, (String)"CTL_TablesTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TablesTopComponent.class, (String)"HINT_TablesTopComponent"));
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.tables = null;
                this.reinitialize();
            }
        });
        this.reinitialize();
        this.tablesText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (TablesTopComponent.this.tables != null) {
                    TablesTopComponent.this.tables.setTables(TablesTopComponent.this.tablesText.getText());
                }
            }
        });
        this.tablesText.setUndoManager(this.undo);
        this.tablesText.getDocument().addUndoableEditListener(this.undo);
        this.add((Component)this.tablesText, "Center");
    }

    private void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project == null) {
            this.tablesText.setText("");
            this.tablesText.getJEditorPane().setEditable(false);
        } else {
            Tables localTables = project.getData().getTableSet();
            this.tablesText.setText(localTables.getTables());
            this.tablesText.getJEditorPane().setEditable(true);
            this.tables = localTables;
        }
        this.undo.discardAllEdits();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

