/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FileChooserManager {
    private HashMap<Object, DialogInfoSet> dialogInfoSets = new HashMap();
    private FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"});
    private static FileChooserManager instance = null;

    public static FileChooserManager getDefault() {
        if (instance == null) {
            instance = new FileChooserManager();
        }
        return instance;
    }

    public void addFilter(Object fileChooserId, FileChooser.ExtensionFilter filter) {
        DialogInfoSet temp = this.getDialogInfoSet(fileChooserId);
        temp.filters.add(filter);
    }

    public void setSelectedFile(Object fileChooserId, File f) {
        DialogInfoSet temp = this.getDialogInfoSet(fileChooserId);
        temp.currentDirectory = null;
        temp.selectedFile = f;
    }

    public void setCurrentDirectory(Object fileChooserId, File f) {
        DialogInfoSet temp = this.getDialogInfoSet(fileChooserId);
        temp.selectedFile = null;
        temp.currentDirectory = f;
    }

    public void setDialogTitle(Object fileChooserId, String title) {
        DialogInfoSet temp = this.getDialogInfoSet(fileChooserId);
        temp.dialogTitle = title;
    }

    public void setMultiSelectionEnabled(Object fileChooserId, boolean val) {
        DialogInfoSet temp = this.getDialogInfoSet(fileChooserId);
        temp.isMultiSelect = val;
    }

    public List<File> showOpenDialog(Object fileChooserId, Component parent) {
        DialogInfoSet temp = this.getDialogInfoSet(fileChooserId);
        CountDownLatch c = new CountDownLatch(1);
        ArrayList<File> retVal = new ArrayList<File>();
        Runnable r = () -> {
            Stage s = new Stage();
            s.initOwner(null);
            s.initModality(Modality.APPLICATION_MODAL);
            if (temp.directoriesOnly) {
                DirectoryChooser chooser = new DirectoryChooser();
                chooser.setTitle(temp.dialogTitle);
                File f = chooser.showDialog((Window)s);
                if (f != null) {
                    retVal.add(f);
                }
            } else {
                FileChooser f = new FileChooser();
                f.setTitle(temp.dialogTitle);
                f.getExtensionFilters().addAll(temp.filters);
                f.getExtensionFilters().add((Object)this.allFilter);
                if (temp.selectedFile != null) {
                    f.setInitialFileName(temp.selectedFile.getName());
                }
                if (temp.currentDirectory != null) {
                    f.setInitialDirectory(temp.currentDirectory);
                }
                if (temp.isMultiSelect) {
                    temp.selectedFile = null;
                    List found = f.showOpenMultipleDialog((Window)s);
                    if (found != null) {
                        retVal.addAll(found);
                    }
                } else {
                    File ret = f.showOpenDialog((Window)s);
                    if (ret != null) {
                        retVal.add(ret);
                    }
                }
            }
            c.countDown();
        };
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
            try {
                c.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FileChooserManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return retVal;
    }

    public File showSaveDialog(Object fileChooserId, Component parent) {
        DialogInfoSet temp = this.getDialogInfoSet(fileChooserId);
        CountDownLatch c = new CountDownLatch(1);
        AtomicReference<Object> retVal = new AtomicReference<Object>(null);
        Platform.runLater(() -> {
            File ret;
            Stage s = new Stage();
            s.initOwner(null);
            s.initModality(Modality.APPLICATION_MODAL);
            FileChooser f = new FileChooser();
            f.setTitle(temp.dialogTitle);
            f.getExtensionFilters().addAll(temp.filters);
            if (temp.selectedFile != null) {
                f.setInitialFileName(temp.selectedFile.getName());
            }
            if (temp.currentDirectory != null) {
                f.setInitialDirectory(temp.currentDirectory);
            }
            if ((ret = f.showSaveDialog((Window)s)) != null) {
                retVal.set(ret);
            }
            c.countDown();
        });
        try {
            c.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FileChooserManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return retVal.get();
    }

    private DialogInfoSet getDialogInfoSet(Object fileChooserId) {
        if (this.dialogInfoSets.containsKey(fileChooserId)) {
            DialogInfoSet infoSet = this.dialogInfoSets.get(fileChooserId);
            return infoSet;
        }
        DialogInfoSet temp = new DialogInfoSet();
        temp.selectedFile = new File(System.getProperty("user.home"));
        this.dialogInfoSets.put(fileChooserId, temp);
        return temp;
    }

    public boolean isDialogDefined(Object fileChooserId) {
        return this.dialogInfoSets.containsKey(fileChooserId);
    }

    public static class DialogInfoSet {
        List<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();
        File selectedFile;
        File currentDirectory;
        File[] selectedFiles;
        String dialogTitle = "Select File";
        boolean directoriesOnly = false;
        boolean isMultiSelect = false;
    }
}

